/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globalshortcut;

import java.awt.AWTKeyStroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.globalshortcut.CallShortcut;
import net.java.sip.communicator.impl.globalshortcut.GlobalShortcutActivator;
import net.java.sip.communicator.impl.globalshortcut.NativeKeyboardHook;
import net.java.sip.communicator.impl.globalshortcut.NativeKeyboardHookDelegate;
import net.java.sip.communicator.impl.globalshortcut.UIShortcut;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutEvent;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutListener;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutService;
import net.java.sip.communicator.service.keybindings.GlobalKeybindingSet;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public class GlobalShortcutServiceImpl
implements GlobalShortcutService,
NativeKeyboardHookDelegate {
    private static final Logger logger = Logger.getLogger(GlobalShortcutServiceImpl.class);
    private final Map<GlobalShortcutListener, List<AWTKeyStroke>> mapActions = new HashMap<GlobalShortcutListener, List<AWTKeyStroke>>();
    private final List<GlobalShortcutListener> specialKeyNotifiers = new ArrayList<GlobalShortcutListener>();
    private boolean isRunning = false;
    private NativeKeyboardHook keyboardHook = new NativeKeyboardHook();
    private final CallShortcut callShortcut = new CallShortcut();
    private final UIShortcut uiShortcut = new UIShortcut();
    private AWTKeyStroke specialKeyDetected = null;
    private final Object specialKeySyncRoot = new Object();

    @Override
    public void registerShortcut(GlobalShortcutListener listener, AWTKeyStroke keyStroke) {
        this.registerShortcut(listener, keyStroke, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShortcut(GlobalShortcutListener listener, AWTKeyStroke keyStroke, boolean add) {
        Map<GlobalShortcutListener, List<AWTKeyStroke>> map = this.mapActions;
        synchronized (map) {
            List<AWTKeyStroke> keystrokes = this.mapActions.get(listener);
            boolean ok = false;
            if (keyStroke == null) {
                return;
            }
            if (keystrokes == null) {
                keystrokes = new ArrayList<AWTKeyStroke>();
            }
            if ((ok = keyStroke.getModifiers() != 16367 ? this.keyboardHook.registerShortcut(keyStroke.getKeyCode(), GlobalShortcutServiceImpl.getModifiers(keyStroke), keyStroke.isOnKeyRelease()) : this.keyboardHook.registerSpecial(keyStroke.getKeyCode(), keyStroke.isOnKeyRelease())) && add) {
                keystrokes.add(keyStroke);
            }
            if (add) {
                this.mapActions.put(listener, keystrokes);
            }
        }
    }

    @Override
    public void unregisterShortcut(GlobalShortcutListener listener, AWTKeyStroke keyStroke) {
        this.unregisterShortcut(listener, keyStroke, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShortcut(GlobalShortcutListener listener, AWTKeyStroke keyStroke, boolean remove) {
        Map<GlobalShortcutListener, List<AWTKeyStroke>> map = this.mapActions;
        synchronized (map) {
            List<AWTKeyStroke> keystrokes = this.mapActions.get(listener);
            if (keystrokes != null && keyStroke != null) {
                int keycode = keyStroke.getKeyCode();
                int modifiers = keyStroke.getModifiers();
                AWTKeyStroke ks = null;
                for (AWTKeyStroke l : keystrokes) {
                    if (l.getKeyCode() != keycode || l.getModifiers() != modifiers) continue;
                    ks = l;
                }
                if (modifiers != 16367) {
                    this.keyboardHook.unregisterShortcut(keyStroke.getKeyCode(), GlobalShortcutServiceImpl.getModifiers(keyStroke));
                } else {
                    this.keyboardHook.unregisterSpecial(keyStroke.getKeyCode());
                }
                if (remove) {
                    if (ks != null) {
                        keystrokes.remove(ks);
                    }
                    if (keystrokes.size() == 0) {
                        this.mapActions.remove(listener);
                    }
                }
            }
        }
    }

    public void start() {
        if (!this.isRunning) {
            this.keyboardHook.setDelegate(this);
            this.keyboardHook.start();
            this.isRunning = true;
        }
    }

    public void stop() {
        this.isRunning = false;
        if (this.keyboardHook != null) {
            this.keyboardHook.setDelegate(null);
            this.keyboardHook.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receiveKey(int keycode, int modifiers, boolean onRelease) {
        if (this.keyboardHook.isSpecialKeyDetection()) {
            this.specialKeyDetected = AWTKeyStroke.getAWTKeyStroke(keycode, modifiers);
            Object object = this.specialKeySyncRoot;
            synchronized (object) {
                this.specialKeySyncRoot.notify();
            }
            GlobalShortcutEvent evt = new GlobalShortcutEvent(this.specialKeyDetected, onRelease);
            ArrayList<GlobalShortcutListener> copyListeners = new ArrayList<GlobalShortcutListener>(this.specialKeyNotifiers);
            for (GlobalShortcutListener l : copyListeners) {
                l.shortcutReceived(evt);
            }
            return;
        }
        Map<GlobalShortcutListener, List<AWTKeyStroke>> map = this.mapActions;
        synchronized (map) {
            for (Map.Entry<GlobalShortcutListener, List<AWTKeyStroke>> entry : this.mapActions.entrySet()) {
                List<AWTKeyStroke> lst = entry.getValue();
                for (AWTKeyStroke l : lst) {
                    if (l.getKeyCode() != keycode || GlobalShortcutServiceImpl.getModifiers(l) != modifiers && (modifiers != 16367 || l.getModifiers() != modifiers)) continue;
                    GlobalShortcutEvent evt = new GlobalShortcutEvent(l, onRelease);
                    entry.getKey().shortcutReceived(evt);
                    return;
                }
            }
        }
    }

    private static int getModifiers(AWTKeyStroke keystroke) {
        int modifiers = keystroke.getModifiers();
        int ret = 0;
        if ((modifiers & 0x80) > 0) {
            ret |= 1;
        }
        if ((modifiers & 0x200) > 0) {
            ret |= 2;
        }
        if ((modifiers & 0x40) > 0) {
            ret |= 4;
        }
        if ((modifiers & 0x100) > 0) {
            ret |= 8;
        }
        return ret;
    }

    @Override
    public synchronized void reloadGlobalShortcuts() {
        GlobalKeybindingSet set = GlobalShortcutActivator.getKeybindingsService().getGlobalBindings();
        for (Map.Entry<GlobalShortcutListener, List<AWTKeyStroke>> entry : this.mapActions.entrySet()) {
            GlobalShortcutListener l = entry.getKey();
            for (AWTKeyStroke e : entry.getValue()) {
                this.unregisterShortcut(l, e, false);
            }
        }
        this.mapActions.clear();
        for (Map.Entry<GlobalShortcutListener, List<AWTKeyStroke>> entry : set.getBindings().entrySet()) {
            if (((String)((Object)entry.getKey())).equals("answer") || ((String)((Object)entry.getKey())).equals("hangup") || ((String)((Object)entry.getKey())).equals("answer_hangup") || ((String)((Object)entry.getKey())).equals("mute") || ((String)((Object)entry.getKey())).equals("push_to_talk")) {
                for (AWTKeyStroke e : entry.getValue()) {
                    if (((String)((Object)entry.getKey())).equals("push_to_talk")) {
                        if (e == null) continue;
                        this.registerShortcut(this.callShortcut, AWTKeyStroke.getAWTKeyStroke(e.getKeyCode(), e.getModifiers(), true));
                        continue;
                    }
                    this.registerShortcut(this.callShortcut, e);
                }
                continue;
            }
            if (!((String)((Object)entry.getKey())).equals("contactlist")) continue;
            for (AWTKeyStroke e : entry.getValue()) {
                this.registerShortcut(this.uiShortcut, e);
            }
        }
    }

    public CallShortcut getCallShortcut() {
        return this.callShortcut;
    }

    public UIShortcut getUIShortcut() {
        return this.uiShortcut;
    }

    @Override
    public void setEnable(boolean enable) {
        block6: {
            if (this.mapActions.size() <= 0) break block6;
            if (enable) {
                for (Map.Entry<GlobalShortcutListener, List<AWTKeyStroke>> entry : this.mapActions.entrySet()) {
                    GlobalShortcutListener l = entry.getKey();
                    for (AWTKeyStroke e : entry.getValue()) {
                        this.registerShortcut(l, e, false);
                    }
                }
            } else {
                for (Map.Entry<GlobalShortcutListener, List<AWTKeyStroke>> entry : this.mapActions.entrySet()) {
                    GlobalShortcutListener l = entry.getKey();
                    for (AWTKeyStroke e : entry.getValue()) {
                        this.unregisterShortcut(l, e, false);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void setSpecialKeyDetection(boolean enable, GlobalShortcutListener callback) {
        this.keyboardHook.detectSpecialKeyPress(enable);
        if (this.specialKeyNotifiers.contains(callback) == enable) {
            return;
        }
        if (enable) {
            this.specialKeyNotifiers.add(callback);
        } else {
            this.specialKeyNotifiers.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWTKeyStroke getSpecialKey() {
        AWTKeyStroke ret = null;
        this.specialKeyDetected = null;
        this.keyboardHook.detectSpecialKeyPress(true);
        if (OSUtils.IS_WINDOWS) {
            Object object = this.specialKeySyncRoot;
            synchronized (object) {
                try {
                    this.specialKeySyncRoot.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ret = this.specialKeyDetected;
            this.specialKeyDetected = null;
        }
        this.keyboardHook.detectSpecialKeyPress(false);
        return ret;
    }

    public void test() {
        GlobalShortcutListener l = new GlobalShortcutListener(){

            @Override
            public void shortcutReceived(GlobalShortcutEvent evt) {
                System.out.println("global shortcut event");
            }
        };
        AWTKeyStroke ks = AWTKeyStroke.getAWTKeyStroke("control B");
        AWTKeyStroke ks2 = AWTKeyStroke.getAWTKeyStroke("control E");
        if (ks == null) {
            logger.info((Object)"Failed to register keystroke");
            System.out.println("failed to register keystroke");
            return;
        }
        this.registerShortcut(l, ks);
        this.registerShortcut(l, ks2);
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.unregisterShortcut(l, ks);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.unregisterShortcut(l, ks2);
    }
}

