/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JLabel;
import net.java.sip.communicator.util.Logger;

public class FileDragLabel
extends JLabel
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(FileDragLabel.class);
    private final DragSource dragSource = DragSource.getDefaultDragSource();
    private File file;

    public FileDragLabel() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public synchronized void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to drop label.", (Throwable)ex);
            }
            event.rejectDrop();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.file == null) {
            this.getToolkit().beep();
        } else {
            FileTransferable transferable = new FileTransferable(this.file);
            dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, transferable, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragExit(DragSourceEvent DragSourceEvent2) {
    }

    @Override
    public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private class FileTransferable
    extends Vector<File>
    implements Transferable {
        private static final long serialVersionUID = 0L;
        static final int FILE = 0;
        static final int STRING = 1;
        static final int PLAIN = 2;
        DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

        public FileTransferable(File file) {
            this.addElement(file);
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.flavors[0]) || flavor.equals(this.flavors[1]) || flavor.equals(this.flavors[2]);
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.flavors[0])) {
                return this;
            }
            if (flavor.equals(this.flavors[2])) {
                return new StringReader(FileDragLabel.this.file.getAbsolutePath());
            }
            if (flavor.equals(this.flavors[1])) {
                return FileDragLabel.this.file.getAbsolutePath();
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

