/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;

public class ChatOperationReasonDialog
extends MessageDialog {
    private static final long serialVersionUID = 3290030744711759011L;
    private final JTextField reasonField = new JTextField();
    private final JPanel reasonFieldPanel = new JPanel(new BorderLayout());

    public ChatOperationReasonDialog() {
        this(null, DesktopUtilActivator.getResources().getI18NString("service.gui.REASON"), DesktopUtilActivator.getResources().getI18NString("service.gui.SPECIFY_REASON"), DesktopUtilActivator.getResources().getI18NString("service.gui.OK"), true, false);
    }

    public ChatOperationReasonDialog(boolean disableOKIfReasonIsEmpty) {
        this(null, DesktopUtilActivator.getResources().getI18NString("service.gui.REASON"), DesktopUtilActivator.getResources().getI18NString("service.gui.SPECIFY_REASON"), DesktopUtilActivator.getResources().getI18NString("service.gui.OK"), true, disableOKIfReasonIsEmpty);
    }

    public ChatOperationReasonDialog(String title, String message) {
        this(null, title, message, DesktopUtilActivator.getResources().getI18NString("service.gui.OK"), true, false);
    }

    public ChatOperationReasonDialog(String title, String message, boolean showReasonLabel, boolean disableOKIfReasonIsEmpty) {
        this(null, title, message, DesktopUtilActivator.getResources().getI18NString("service.gui.OK"), showReasonLabel, disableOKIfReasonIsEmpty);
    }

    public ChatOperationReasonDialog(Frame chatWindow, String title, String message, String okButtonName, boolean showReasonLabel) {
        this(chatWindow, title, message, okButtonName, showReasonLabel, false);
    }

    public ChatOperationReasonDialog(Frame chatWindow, String title, String message, String okButtonName, boolean showReasonLabel, boolean disableOKIfReasonIsEmpty) {
        super(chatWindow, title, message, okButtonName, false);
        JPanel reasonPanel = new JPanel(new BorderLayout());
        JLabel reasonLabel = new JLabel(showReasonLabel ? DesktopUtilActivator.getResources().getI18NString("service.gui.REASON") + ":" : "");
        reasonPanel.add((Component)reasonLabel, "West");
        reasonPanel.add((Component)new JLabel("          "), "East");
        this.reasonFieldPanel.add((Component)this.reasonField, "North");
        this.reasonFieldPanel.setOpaque(false);
        reasonPanel.add((Component)this.reasonFieldPanel, "Center");
        reasonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        reasonPanel.setOpaque(false);
        this.replaceCheckBoxPanel(reasonPanel);
        if (disableOKIfReasonIsEmpty) {
            this.updateOKButtonState();
            this.reasonField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent ev) {
                    ChatOperationReasonDialog.this.updateOKButtonState();
                }

                @Override
                public void insertUpdate(DocumentEvent ev) {
                    ChatOperationReasonDialog.this.updateOKButtonState();
                }

                @Override
                public void changedUpdate(DocumentEvent ev) {
                    ChatOperationReasonDialog.this.updateOKButtonState();
                }
            });
        }
        this.pack();
    }

    public void addToReasonFieldPannel(Component comp) {
        this.reasonFieldPanel.add(comp, "Center");
    }

    private void updateOKButtonState() {
        this.okButton.setEnabled(!this.reasonField.getText().trim().equals(""));
    }

    public String getReason() {
        return this.reasonField.getText();
    }

    public void setReasonFieldText(String value) {
        this.reasonField.setText(value);
    }

    @Override
    public void setMessage(String message) {
        super.setMessage(message);
        this.setMaxWidth(400);
    }
}

