/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.sip;

import java.io.Serializable;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.EncodingsRegistrationUtil;
import net.java.sip.communicator.service.protocol.SecurityAccountRegistration;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.neomedia.MediaService;
import org.osgi.framework.BundleContext;

public class SIPAccountRegistration
extends SipAccountID
implements Serializable {
    private String defaultDomain = null;
    private boolean rememberPassword = true;
    private EncodingsRegistrationUtil encodingsRegistration = new EncodingsRegistrationUtil();
    private SecurityAccountRegistration securityAccountRegistration = new SecurityAccountRegistration(){

        @Override
        public void setSavpOption(int savpOption) {
            SIPAccountRegistration.this.putAccountProperty("SAVP_OPTION", Integer.toString(savpOption));
        }

        @Override
        public int getSavpOption() {
            String savpOption = SIPAccountRegistration.this.getAccountPropertyString("SAVP_OPTION");
            return Integer.parseInt(savpOption);
        }
    };

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public EncodingsRegistrationUtil getEncodingsRegistration() {
        return this.encodingsRegistration;
    }

    public SecurityAccountRegistration getSecurityRegistration() {
        return this.securityAccountRegistration;
    }

    public void loadAccount(AccountID accountID, String password, BundleContext bundleContext) {
        SIPAccountRegistration.mergeProperties(accountID.getAccountProperties(), this.accountProperties);
        String serverAddress = this.getServerAddress();
        String userID = serverAddress == null ? accountID.getUserID() : accountID.getAccountPropertyString("USER_ID");
        this.setUserID(userID);
        this.setPassword(password);
        this.rememberPassword = password != null;
        this.setClistOptionPassword(accountID.getAccountPropertyString("OPT_CLIST_PASSWORD"));
        this.securityAccountRegistration.loadAccount(accountID);
        this.encodingsRegistration.loadAccount(accountID, (MediaService)ServiceUtils.getService((BundleContext)bundleContext, MediaService.class));
    }

    public void storeProperties(String userName, String passwd, String protocolIconPath, String accountIconPath, Boolean isModification, Map<String, String> accountProperties) {
        if (this.rememberPassword) {
            this.setPassword(passwd);
        } else {
            this.setPassword(null);
        }
        String serverAddress = null;
        String serverFromUsername = SIPAccountRegistration.getServerFromUserName(userName);
        if (this.getServerAddress() != null) {
            serverAddress = this.getServerAddress();
        }
        if (serverFromUsername == null && this.getDefaultDomain() != null) {
            userName = userName + "@" + this.getDefaultDomain();
            if (serverAddress == null) {
                serverAddress = this.getDefaultDomain();
            }
        } else if (serverAddress == null && serverFromUsername != null) {
            serverAddress = serverFromUsername;
        }
        if (serverAddress != null) {
            accountProperties.put("SERVER_ADDRESS", serverAddress);
            if (userName.indexOf(serverAddress) < 0) {
                accountProperties.put("IS_SERVER_OVERRIDDEN", Boolean.toString(true));
            }
        }
        if (this.isProxyAutoConfigure()) {
            this.removeAccountProperty("PROXY_ADDRESS");
            this.removeAccountProperty("PROXY_PORT");
            this.removeAccountProperty("PREFERRED_TRANSPORT");
        }
        if (serverAddress == null) {
            this.setForceP2PMode(true);
        }
        this.securityAccountRegistration.storeProperties(this.accountProperties);
        this.encodingsRegistration.storeProperties(this.accountProperties);
        if (isModification.booleanValue()) {
            if (this.isMessageWaitingIndicationsEnabled()) {
                this.setVoicemailURI("");
                this.setVoicemailCheckURI("");
                this.removeAccountProperty("VOICEMAIL_ENABLED");
            } else {
                accountProperties.put("VOICEMAIL_ENABLED", Boolean.FALSE.toString());
            }
        }
        super.storeProperties(protocolIconPath, accountIconPath, accountProperties);
    }
}

