/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.WritableIRCChannel;
import com.ircclouds.irc.api.domain.WritableIRCTopic;
import com.ircclouds.irc.api.domain.WritableIRCUser;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.utils.SynchronizedUnmodifiableSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelJoinListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractChannelJoinListener.class);
    private final Map<String, Callback<IRCChannel>> callbacks = new HashMap<String, Callback<IRCChannel>>();
    private WritableIRCChannel channel;
    private WritableIRCTopic topic;

    public void submit(String aChannelName, Callback<IRCChannel> aCallback) {
        this.callbacks.put(aChannelName, aCallback);
    }

    public void onChanJoinMessage(ChanJoinMessage aMsg) {
        this.channel = new WritableIRCChannel(aMsg.getChannelName());
        this.saveChannel(this.channel);
    }

    public void onServerMessage(ServerNumericMessage aServerMessage) {
        int _numcode = aServerMessage.getNumericCode();
        if (_numcode == 470 || _numcode == 333 || _numcode == 353 || _numcode == 332 || _numcode == 366 || _numcode == 473 || _numcode == 475 || _numcode == 471 || _numcode == 474) {
            if (this.channel != null) {
                if (_numcode == 353) {
                    String[] _nicks;
                    for (String _nick : _nicks = aServerMessage.getText().substring(aServerMessage.getText().indexOf(":") + 1).split(" ")) {
                        this.add(_nick);
                    }
                } else if (_numcode == 332) {
                    this.topic = new WritableIRCTopic(this.getTopic(aServerMessage));
                } else if (_numcode == 333) {
                    String[] _cmpnts = aServerMessage.getText().split(" ");
                    this.topic.setSetBy(_cmpnts[1]);
                    this.topic.setDate(new Date(Long.parseLong(_cmpnts[2] + "000")));
                    this.channel.setTopic(this.topic);
                } else if (_numcode == 366) {
                    Callback<IRCChannel> _chanCallback = this.callbacks.remove(this.channel.getName());
                    if (_chanCallback != null) {
                        _chanCallback.onSuccess(this.channel);
                    }
                    this.channel = null;
                    this.topic = null;
                }
            } else if (this.callbacks.containsKey(this.getChannelNameFrom(aServerMessage.getText()))) {
                String[] _components;
                Callback<IRCChannel> callback;
                if (_numcode == 473) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 475) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 474) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 471) {
                    this.callbacks.remove(this.getChannelNameFrom(aServerMessage.getText())).onFailure(new IRCException(aServerMessage.getText()));
                } else if (_numcode == 470 && (callback = this.callbacks.remove((_components = aServerMessage.getText().split(" "))[0])) != null) {
                    this.callbacks.put(_components[1], callback);
                }
            }
        }
    }

    protected abstract void saveChannel(WritableIRCChannel var1);

    protected abstract IRCUserStatuses getIRCUserStatuses();

    private String getChannelNameFrom(String aMessage) {
        return aMessage.split(" ")[0];
    }

    private void add(String aNick) {
        Map<Character, IRCUserStatus> statuses = AbstractChannelJoinListener.mapPrefixes(this.getIRCUserStatuses());
        HashSet<IRCUserStatus> active = new HashSet<IRCUserStatus>();
        WritableIRCUser user = null;
        for (int i = 0; i < aNick.length(); ++i) {
            char p = aNick.charAt(i);
            if (!statuses.containsKey(Character.valueOf(p))) {
                user = new WritableIRCUser(aNick.substring(i));
                break;
            }
            active.add(statuses.get(Character.valueOf(p)));
        }
        if (user == null) {
            LOG.debug("Skipping user {}: not able to extract a valid nick name.", (Object)aNick);
            return;
        }
        this.channel.addUser(user, new SynchronizedUnmodifiableSet<IRCUserStatus>(active));
    }

    private String getTopic(ServerNumericMessage aServMsg) {
        return aServMsg.getText().substring(aServMsg.getText().indexOf(":") + 1);
    }

    private static Map<Character, IRCUserStatus> mapPrefixes(IRCUserStatuses statuses) {
        HashMap<Character, IRCUserStatus> map = new HashMap<Character, IRCUserStatus>();
        for (IRCUserStatus status : statuses) {
            map.put(status.getPrefix(), status);
        }
        return map;
    }
}

