/**
 * SECTION:edsf-persona-store
 * @short_description: A persona store representing a single EDS address book.
 * 
 * <para>The persona store will contain <link linkend="EdsfPersona"><type>EdsfPersona</type></link>s for each contact in the address book it represents.</para>
 */
/**
 * EDSF_TYPE_PERSONA_STORE:
 * 
 * The type for <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link>.
 */
/**
 * edsf_persona_store_new:
 * @s: (in): &nbsp;.  <para>the e-d-s source being represented by the persona store </para>
 * 
 * Create a new PersonaStore.
 * 
 * <para>Create a new persona store to store the <link linkend="EdsfPersona"><type>EdsfPersona</type></link>s for the contacts</para>
 *
 * Since: 0.6.0
 * Deprecated: 0.7.2: No replacement specified.
 */
/**
 * edsf_persona_store_new_with_source_registry:
 * @r: (in): &nbsp;.  <para>the EDS source registry giving access to all EDS sources </para>
 * @s: (in): &nbsp;.  <para>the EDS source being represented by the persona store </para>
 * 
 * Create a new PersonaStore.
 * 
 * <para>Create a new persona store to store the <link linkend="EdsfPersona"><type>EdsfPersona</type></link>s for the contacts in <code>s</code>. Passing a re-used source registry to the constructor (compared to the old <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link> constructor) saves a lot of time and D-Bus round trips.</para>
 *
 * Since: 0.7.2
 */
/**
 * EdsfPersonaStore:source:
 * 
 * The EDS <link linkend="ESource"><type>ESource</type></link> associated with this persona store.
 *
 * Since: 0.6.6
 */
/**
 * edsf_persona_store_get_source:
 * @self: the <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="EdsfPersonaStore--source"><type>"source"</type></link> property.
 * 
 * The EDS <link linkend="ESource"><type>ESource</type></link> associated with this persona store.
 * 
 * Returns: the value of the <link linkend="EdsfPersonaStore--source"><type>"source"</type></link> property
 *
 * Since: 0.6.6
 */
/**
 * edsf_persona_store_create_address_book:
 * @id: (in): &nbsp;.  <para>the name and id for the new address book </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Create a new address book with the given ID.
 * 
 * <para>A new Address Book will be created with the given ID and the EDS SourceRegistry will notice the new Address Book source and will emit source_added with the new <link linkend="ESource"><type>ESource</type></link> object which Folks.Backends.Eds.Backend will then create a new <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link> from.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if an error occurred while creating or committing to the <link linkend="ESourceRegistry"><type>ESourceRegistry</type></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-store-create-address-book-finish"><function>edsf_persona_store_create_address_book_finish()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_store_create_address_book_finish:
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Create a new address book with the given ID.
 * 
 * <para>A new Address Book will be created with the given ID and the EDS SourceRegistry will notice the new Address Book source and will emit source_added with the new <link linkend="ESource"><type>ESource</type></link> object which Folks.Backends.Eds.Backend will then create a new <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link> from.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if an error occurred while creating or committing to the <link linkend="ESourceRegistry"><type>ESourceRegistry</type></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-store-create-address-book"><function>edsf_persona_store_create_address_book()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_store_remove_address_book:
 * @store: (in): &nbsp;.  <para>the PersonaStore to delete the address book for. </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove a persona store&apos;s address book permamently.
 * 
 * <para>This is a utility function to remove an <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link>&apos;s address book from the disk permanently. This simply wraps the EDS API to do the same.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if an error occurred in <link linkend="e-source-remove"><function>e_source_remove()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-store-remove-address-book-finish"><function>edsf_persona_store_remove_address_book_finish()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * edsf_persona_store_remove_address_book_finish:
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Remove a persona store&apos;s address book permamently.
 * 
 * <para>This is a utility function to remove an <link linkend="EdsfPersonaStore"><type>EdsfPersonaStore</type></link>&apos;s address book from the disk permanently. This simply wraps the EDS API to do the same.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if an error occurred in <link linkend="e-source-remove"><function>e_source_remove()</function></link> </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="edsf-persona-store-remove-address-book"><function>edsf_persona_store_remove_address_book()</function></link>
 *
 * Since: 0.9.0
 */
/**
 * EdsfPersonaStore:
 * 
 * A persona store representing a single EDS address book.
 * 
 * <para>The persona store will contain <link linkend="EdsfPersona"><type>EdsfPersona</type></link>s for each contact in the address book it represents.</para>
 */
/**
 * EdsfPersonaStoreClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="EDSF-TYPE-PERSONA-STORE:CAPS"><literal>EDSF_TYPE_PERSONA_STORE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
