/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.lang.reflect.Array;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class KernelJavaAddons {
    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject) {
        IRubyObject iRubyObject;
        if (fromObject instanceof RubyArray) {
            RubyArray ary = (RubyArray)fromObject;
            iRubyObject = KernelJavaAddons.toJavaArray(context, Object.class, ary);
        } else {
            iRubyObject = Java.getInstance(context.runtime, fromObject.toJava(Object.class));
        }
        return iRubyObject;
    }

    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject, IRubyObject type2) {
        if (type2.isNil()) {
            return KernelJavaAddons.to_java(context, fromObject);
        }
        Class<?> targetType = Java.resolveClassType(context, type2);
        if (fromObject instanceof RubyArray) {
            return KernelJavaAddons.toJavaArray(context, targetType, (RubyArray)fromObject);
        }
        return Java.getInstance(context.runtime, fromObject.toJava(targetType));
    }

    static ArrayJavaProxy toJavaArray(ThreadContext context, Class<?> type2, RubyArray fromArray) {
        Object newArray = KernelJavaAddons.toJavaArrayInternal(context, type2, fromArray);
        return new ArrayJavaProxy(context.runtime, Java.getProxyClassForObject(context, newArray), newArray, JavaUtil.getJavaConverter(type2));
    }

    private static Object toJavaArrayInternal(ThreadContext context, Class<?> type2, RubyArray fromArray) {
        Object newArray = Array.newInstance(type2, fromArray.size());
        if (type2.isArray()) {
            for (int i2 = 0; i2 < fromArray.size(); ++i2) {
                Class<?> nestedType = type2.getComponentType();
                Object element = fromArray.eltInternal(i2);
                Object nestedArray = element instanceof RubyArray ? KernelJavaAddons.toJavaArrayInternal(context, nestedType, (RubyArray)element) : (type2.isInstance(element) ? element : element.toJava(type2));
                ArrayUtils.setWithExceptionHandlingDirect(context.runtime, newArray, i2, nestedArray);
            }
        } else {
            ArrayUtils.copyDataToJavaArrayDirect(fromArray, newArray);
        }
        return newArray;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_signature(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_signature(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_signature(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_name(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_name(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_name(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_implements(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_implements(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_implements(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_annotation(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_annotation(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_annotation(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_require(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_require(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_require(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_package(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_package(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_package(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static IRubyObject java_field(IRubyObject recv2, IRubyObject[] args2) {
        return KernelJavaAddons.java_field(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_field(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return context.nil;
    }
}

