---@meta

--- **syntax:** *exdata = th_exdata(data?)*
---
--- This API allows for embedding user data into a thread (`lua_State`).
---
--- The retrieved `exdata` value on the Lua land is represented as a cdata object
--- of the ctype `void*`.
---
--- As of this version, retrieving the `exdata` (i.e. `th_exdata()` without any
--- argument) can be JIT compiled.
---
--- Usage:
---
--- ```lua
--- local th_exdata = require "thread.exdata"
---
--- th_exdata(0xdeadbeefLL)  -- set the exdata of the current Lua thread
--- local exdata = th_exdata()  -- fetch the exdata of the current Lua thread
--- ```
---
--- Also available are the following public C API functions for manipulating
--- `exdata` on the C land:
---
--- ```C
--- void lua_setexdata(lua_State *L, void *exdata);
--- void *lua_getexdata(lua_State *L);
--- ```
---
--- The `exdata` pointer is initialized to `NULL` when the main thread is created.
--- Any child Lua thread will inherit its parent's `exdata`, but still can override
--- it.
---
--- **Note:** This API will not be available if LuaJIT is compiled with
--- `-DLUAJIT_DISABLE_FFI`.
---
--- **Note bis:** This API is used internally by the OpenResty core, and it is
--- strongly discouraged to use it yourself in the context of OpenResty.
---@param data? any
---@return any? data
local function exdata(data) end

return exdata
