# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Git message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # Information about Git, provided by the Build/CI server as environment
    #  variables.
    ##
    class Git < Message
      attr_reader :remote

      attr_reader :revision

      attr_reader :branch

      attr_reader :tag

      def initialize(
        remote: '',
        revision: '',
        branch: nil,
        tag: nil
      )
        @remote = remote
        @revision = revision
        @branch = branch
        @tag = tag
        super()
      end

      ##
      # Returns a new Git from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Git.from_h(some_hash) # => #<Cucumber::Messages::Git:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          remote: hash[:remote],
          revision: hash[:revision],
          branch: hash[:branch],
          tag: hash[:tag]
        )
      end
    end
  end
end
