/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import java.io.File;
import java.net.URL;
import net.sf.antcontrib.net.Ivy20Adapter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.types.FileSet;

public class URLImportTask
extends ImportTask {
    private String org;
    private String module;
    private String rev = "latest.integration";
    private String conf = "default";
    private String type = "jar";
    private String repositoryUrl;
    private File repositoryDir;
    private URL ivyConfUrl;
    private File ivyConfFile;
    private String resource = "build.xml";
    private String artifactPattern = "/[org]/[module]/[ext]s/[module]-[revision].[ext]";
    private String ivyPattern = "/[org]/[module]/ivy-[revision].xml";

    public void setModule(String module) {
        this.module = module;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public void setIvyConfFile(File ivyConfFile) {
        this.ivyConfFile = ivyConfFile;
    }

    public void setIvyConfUrl(URL ivyConfUrl) {
        this.ivyConfUrl = ivyConfUrl;
    }

    public void setArtifactPattern(String artifactPattern) {
        this.artifactPattern = artifactPattern;
    }

    public void setIvyPattern(String ivyPattern) {
        this.ivyPattern = ivyPattern;
    }

    public void setRepositoryDir(File repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setOptional(boolean optional) {
        throw new BuildException("'optional' property not accessed for ImportURL.");
    }

    public void setFile(String file) {
        throw new BuildException("'file' property not accessed for ImportURL.");
    }

    public String getOrg() {
        return this.org;
    }

    public String getModule() {
        return this.module;
    }

    public String getRev() {
        return this.rev;
    }

    public String getConf() {
        return this.conf;
    }

    public String getType() {
        return this.type;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    public URL getIvyConfUrl() {
        return this.ivyConfUrl;
    }

    public File getIvyConfFile() {
        return this.ivyConfFile;
    }

    public String getResource() {
        return this.resource;
    }

    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    public String getIvyPattern() {
        return this.ivyPattern;
    }

    public void execute() throws BuildException {
        Ivy20Adapter adapter = null;
        try {
            Class.forName("org.apache.ivy.Ivy");
            adapter = new Ivy20Adapter();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String setId = this.org + "." + this.module + "." + this.rev + ".fileset";
        adapter.configure(this);
        adapter.fileset(this, setId);
        FileSet fileset = (FileSet)this.getProject().getReference(setId);
        DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
        String[] files = scanner.getIncludedFiles();
        File file = new File(scanner.getBasedir(), files[0]);
        File importFile = null;
        if ("xml".equalsIgnoreCase(this.type)) {
            importFile = file;
        } else if ("jar".equalsIgnoreCase(this.type) || "zip".equalsIgnoreCase(this.type)) {
            File dir = new File(file.getParentFile(), file.getName() + ".extracted");
            if (!dir.exists() || dir.lastModified() < file.lastModified()) {
                dir.mkdir();
                Expand expand = (Expand)this.getProject().createTask("unjar");
                expand.setSrc(file);
                expand.setDest(dir);
                expand.perform();
            }
            if (!(importFile = new File(dir, this.resource)).exists()) {
                throw new BuildException("Cannot find a '" + this.resource + "' file in " + file.getName());
            }
        } else {
            throw new BuildException("Don't know what to do with type: " + this.type);
        }
        this.log("Importing " + importFile.getName(), 2);
        super.setFile(importFile.getAbsolutePath());
        super.execute();
        this.log("Import complete.", 2);
    }
}

