/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;

public class RoundedButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    boolean mouseIn = false;

    public RoundedButton(String label) {
        super(label);
        this.setBorderPainted(false);
        this.addMouseListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.getModel().isPressed()) {
            g.setColor(g.getColor());
            g2.fillRect(3, 3, this.getWidth() - 6, this.getHeight() - 6);
        }
        super.paintComponent(g);
        if (this.mouseIn) {
            g2.setColor(Color.darkGray);
        } else {
            g2.setColor(new Color(128, 128, 128));
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.2f));
        g2.draw(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 3, this.getHeight() - 3, 12.0, 8.0));
        g2.setStroke(new BasicStroke(1.5f));
        g2.drawLine(4, this.getHeight() - 3, this.getWidth() - 4, this.getHeight() - 3);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseIn = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

