/*
 * Decompiled with CFR 0.152.
 */
package beast.app;

import beagle.BeagleFlag;
import beast.app.BEASTVersion2;
import beast.app.beastapp.BeastDialog;
import beast.app.beastapp.BeastMain;
import beast.app.beauti.Beauti;
import beast.app.draw.ExtensionFileFilter;
import beast.app.util.Version;
import beast.core.Logger;
import beast.core.Runnable;
import beast.core.util.Log;
import beast.util.AddOnManager;
import beast.util.JSONParser;
import beast.util.Randomizer;
import beast.util.XMLParser;
import beast.util.XMLParserException;
import jam.util.IconUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class BeastMCMC {
    public static final String VERSION = "2.0 Release candidate";
    public static final String DEVELOPERS = "Beast 2 development team";
    public static final String COPYRIGHT = "Beast 2 development team 2011";
    public static int m_nThreads = 1;
    public static ExecutorService g_exec = Executors.newFixedThreadPool(m_nThreads);
    long m_nSeed = 127L;
    Runnable m_runnable;

    public void parseArgs(String[] stringArray) throws IOException, XMLParserException, JSONException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        try {
            while (n < stringArray.length) {
                int n2 = n;
                if (n >= stringArray.length) continue;
                if (stringArray[n].equals("")) {
                    ++n;
                } else if (stringArray[n].equals("-batch")) {
                    Logger.FILE_MODE = Logger.LogFileMode.only_new_or_exit;
                    ++n;
                } else if (stringArray[n].equals("-resume")) {
                    bl = true;
                    Logger.FILE_MODE = Logger.LogFileMode.resume;
                    System.setProperty("beast.resume", "true");
                    System.setProperty("beast.debug", "false");
                    ++n;
                } else if (stringArray[n].equals("-overwrite")) {
                    Logger.FILE_MODE = Logger.LogFileMode.overwrite;
                    ++n;
                } else if (stringArray[n].equals("-seed")) {
                    this.m_nSeed = stringArray[n + 1].equals("random") ? Randomizer.getSeed() : Long.parseLong(stringArray[n + 1]);
                    n += 2;
                } else if (stringArray[n].equals("-threads")) {
                    m_nThreads = Integer.parseInt(stringArray[n + 1]);
                    g_exec = Executors.newFixedThreadPool(m_nThreads);
                    n += 2;
                } else if (stringArray[n].equals("-prefix")) {
                    System.setProperty("file.name.prefix", stringArray[n + 1].trim());
                    n += 2;
                } else if (stringArray[n].equals("-strictversions")) {
                    bl2 = true;
                    ++n;
                }
                if (n != n2) continue;
                if (n == stringArray.length - 1) {
                    file = new File(stringArray[n]);
                    ++n;
                    continue;
                }
                throw new IllegalArgumentException("Wrong argument");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Error parsing command line arguments: " + Arrays.toString(stringArray) + "\nArguments ignored\n\n" + BeastMCMC.getUsage());
        }
        if (file == null) {
            String string;
            Icon icon;
            ArrayList<String> arrayList = new ArrayList<String>();
            BEASTVersion2 bEASTVersion2 = new BEASTVersion2();
            String string2 = "<html><center><p>Bayesian Evolutionary Analysis Sampling Trees<br>Version " + ((Version)bEASTVersion2).getVersionString() + ", " + ((Version)bEASTVersion2).getDateString() + "</p></center></html>";
            BeastDialog beastDialog = new BeastDialog(new JFrame(), string2, icon = IconUtils.getIcon(BeastMain.class, "images/beast.png"));
            if (!beastDialog.showDialog(string = "BEAST " + ((Version)bEASTVersion2).getVersionString(), this.m_nSeed)) {
                return;
            }
            switch (beastDialog.getLogginMode()) {
                case 0: {
                    break;
                }
                case 1: {
                    arrayList.add("-overwrite");
                    break;
                }
                case 2: {
                    arrayList.add("-resume");
                }
            }
            arrayList.add("-seed");
            arrayList.add(beastDialog.getSeed() + "");
            if (beastDialog.getThreadPoolSize() > 0) {
                arrayList.add("-threads");
                arrayList.add(beastDialog.getThreadPoolSize() + "");
            }
            boolean bl3 = beastDialog.useBeagle();
            boolean bl4 = false;
            long l = 0L;
            if (bl3) {
                bl4 = beastDialog.showBeagleInfo();
                if (beastDialog.preferBeagleCPU()) {
                    l |= BeagleFlag.PROCESSOR_CPU.getMask();
                }
                if (beastDialog.preferBeagleSSE()) {
                    l |= BeagleFlag.VECTOR_SSE.getMask();
                }
                if (beastDialog.preferBeagleGPU()) {
                    l |= BeagleFlag.PROCESSOR_GPU.getMask();
                }
                if (beastDialog.preferBeagleDouble()) {
                    l |= BeagleFlag.PRECISION_DOUBLE.getMask();
                }
                if (beastDialog.preferBeagleSingle()) {
                    l |= BeagleFlag.PRECISION_SINGLE.getMask();
                }
            }
            if (l != 0L) {
                System.setProperty("beagle.preferred.flags", Long.toString(l));
            }
            if (!bl3) {
                System.setProperty("java.only", "true");
            }
            File file2 = beastDialog.getInputFile();
            if (!bl4 && file2 == null) {
                System.err.println("No input file specified");
                System.exit(1);
            }
            arrayList.add(file2.getAbsolutePath());
            this.parseArgs(arrayList.toArray(new String[0]));
            return;
        }
        Log.warning.println("File: " + file.getName() + " seed: " + this.m_nSeed + " threads: " + m_nThreads);
        if (bl) {
            Log.info.println("Resuming from file");
        }
        if (bl2) {
            if (file.getPath().toLowerCase().endsWith(".json")) {
                throw new IllegalArgumentException("The -strictversions flag is not implemented for JSON files yet (only XML files are supported).");
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            int n3 = 0;
            while (bufferedReader.ready() && n3 < 100) {
                string = bufferedReader.readLine();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
            bufferedReader.close();
            string = stringBuffer.toString();
            int n4 = string.indexOf("required=");
            if (n4 < 0) {
                throw new IllegalArgumentException("Could not find a 'required' attribute in the XML. Add the required attribute, or run without the -strictversions flag");
            }
            char c = string.charAt(n4 + 9);
            int n5 = string.indexOf(c, n4 += 10);
            String string3 = string.substring(n4, n5);
            AddOnManager.loadExternalJars(string3);
        } else {
            AddOnManager.loadExternalJars();
        }
        Randomizer.setSeed(this.m_nSeed);
        if (file.getPath().toLowerCase().endsWith(".json")) {
            this.m_runnable = new JSONParser().parseFile(file);
        } else {
            try {
                this.m_runnable = new XMLParser().parseFile(file);
            }
            catch (ParserConfigurationException | SAXException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        this.m_runnable.setStateFile(file.getName() + ".state", bl);
    }

    public static String getUsage() {
        return "Usage: BeastMCMC [options] <Beast.xml>\nwhere <Beast.xml> the name of a file specifying a Beast run\nand the following options are allowed:\n-resume : read state that was stored at the end of the last run from file and append log file\n-overwrite : overwrite existing log files (if any). By default, existing files will not be overwritten.\n-seed [<int>|random] : sets random number seed (default 127), or picks a random seed\n-threads <int> : sets number of threads (default 1)\n-prefix <name> : use name as prefix for all log files\n-beastlib <path> : Colon separated list of directories. All jar files in the path are loaded. (default 'beastlib')";
    }

    String getFileNameByDialog() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName().toLowerCase();
                return string.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "xml files";
            }
        });
        jFileChooser.setDialogTitle("Load xml file");
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    public void run() throws Exception {
        g_exec = Executors.newFixedThreadPool(m_nThreads);
        this.m_runnable.run();
        g_exec.shutdown();
        g_exec.shutdownNow();
    }

    public static void main(String[] stringArray) {
        try {
            System.setProperty("beast.debug", "true");
            BeastMCMC beastMCMC = new BeastMCMC();
            beastMCMC.parseArgs(stringArray);
            beastMCMC.run();
        }
        catch (XMLParserException xMLParserException) {
            System.out.println(xMLParserException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(BeastMCMC.getUsage());
        }
        if (System.getProperty("beast.useWindow") == null) {
            System.exit(0);
        }
    }

    class BeastStartDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        boolean m_bOK = false;
        JTextField m_fileEntry;
        JTextField m_seedEntry;
        JCheckBox m_bUseGPU;
        JComboBox<String> m_mode;

        public BeastStartDialog() {
            this.setDefaultCloseOperation(2);
            this.setModalityType(DEFAULT_MODALITY_TYPE);
            this.init();
            this.setVisible(true);
        }

        String[] getArgs() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-seed");
            arrayList.add(this.m_seedEntry.getText());
            switch (this.m_mode.getSelectedIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    arrayList.add("-overwrite");
                    break;
                }
                case 2: {
                    arrayList.add("-resume");
                }
            }
            arrayList.add(this.m_fileEntry.getText());
            return arrayList.toArray(new String[0]);
        }

        void init() {
            try {
                this.setTitle("Beast Start Dialog");
                Box box = Box.createVerticalBox();
                box.add(this.createHeader());
                box.add(Box.createVerticalStrut(10));
                box.add(this.createFileInput());
                box.add(Box.createVerticalStrut(10));
                box.add(Box.createVerticalBox());
                box.add(Box.createVerticalStrut(10));
                box.add(this.createSeedInput());
                box.add(Box.createVerticalStrut(10));
                box.add(this.createModeInput());
                box.add(Box.createVerticalGlue());
                box.add(this.createRunQuitButtons());
                this.add(box);
                int n = UIManager.getFont("Label.font").getSize();
                this.setSize(600 * n / 13, 500 * n / 13);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not create dialog: " + exception.getMessage());
            }
        }

        private Component createHeader() {
            Serializable serializable;
            Box box = Box.createHorizontalBox();
            String string = "beast/app/draw/icons/beast.png";
            ImageIcon imageIcon = null;
            try {
                serializable = ClassLoader.getSystemResource(string);
                if (serializable == null) {
                    System.err.println("Cannot find icon " + string);
                    return null;
                }
                imageIcon = new ImageIcon((URL)serializable);
            }
            catch (Exception exception) {
                System.err.println("Cannot load icon " + string + " " + exception.getMessage());
                return null;
            }
            serializable = new JLabel(imageIcon);
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            box.add((Component)serializable, "West");
            serializable = new JLabel("<html><center>BEAST<br>Version: 2.0 Release candidate<br>Developers: Beast 2 development team<br>Copyright: Beast 2 development team 2011</html>");
            ((JLabel)serializable).setHorizontalAlignment(0);
            box.add((Component)serializable);
            return box;
        }

        private Component createFileInput() {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Beast XML File: "));
            this.m_fileEntry = new JTextField();
            int n = this.m_fileEntry.getFont().getSize();
            Dimension dimension = new Dimension(300 * n / 13, 20 * n / 13);
            this.m_fileEntry.setMinimumSize(dimension);
            this.m_fileEntry.setPreferredSize(dimension);
            this.m_fileEntry.setSize(dimension);
            this.m_fileEntry.setToolTipText("Enter file name of Beast 2 XML file");
            this.m_fileEntry.setMaximumSize(new Dimension(1024 * n / 13, 20 * n / 13));
            box.add(this.m_fileEntry);
            JButton jButton = new JButton("Choose file");
            jButton.addActionListener(actionEvent -> {
                JFileChooser jFileChooser = new JFileChooser(Beauti.g_sDir);
                File file = new File(this.m_fileEntry.getText());
                if (file.exists()) {
                    jFileChooser.setSelectedFile(file);
                }
                jFileChooser.addChoosableFileFilter(new ExtensionFileFilter(".xml", "Beast xml file (*.xml)"));
                jFileChooser.setDialogTitle("Select Beast 2 XML file");
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    String string = jFileChooser.getSelectedFile().toString();
                    if (string.lastIndexOf(47) > 0) {
                        Beauti.g_sDir = string.substring(0, string.lastIndexOf(47));
                    }
                    this.m_fileEntry.setText(string);
                }
            });
            box.add(jButton);
            return box;
        }

        private Component createSeedInput() {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Random number seed: "));
            this.m_seedEntry = new JTextField("127");
            this.m_seedEntry.setHorizontalAlignment(4);
            Dimension dimension = new Dimension(100, 20);
            this.m_seedEntry.setMinimumSize(dimension);
            this.m_seedEntry.setPreferredSize(dimension);
            this.m_seedEntry.setSize(dimension);
            this.m_seedEntry.setToolTipText("Enter seed number used for initialising the random number generator");
            int n = this.m_seedEntry.getFont().getSize();
            this.m_seedEntry.setMaximumSize(new Dimension(1024 * n / 13, 20 * n / 13));
            box.add(this.m_seedEntry);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        private Component createModeInput() {
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Mode of running: "));
            this.m_mode = new JComboBox<String>(new String[]{"default: only write new log files", "overwrite: overwrite log files", "resume: appends log to existing files (if any)"});
            Dimension dimension = new Dimension(350, 20);
            this.m_mode.setMinimumSize(dimension);
            this.m_mode.setPreferredSize(dimension);
            this.m_mode.setSize(dimension);
            this.m_mode.setMaximumSize(dimension);
            this.m_mode.setSelectedIndex(0);
            box.add(this.m_mode);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        Component createRunQuitButtons() {
            Box box = Box.createHorizontalBox();
            box.setBorder(new EtchedBorder());
            JButton jButton = new JButton("Run");
            jButton.addActionListener(actionEvent -> {
                this.m_bOK = true;
                this.dispose();
            });
            JButton jButton2 = new JButton("Quit");
            jButton2.addActionListener(actionEvent -> {
                this.dispose();
                System.exit(0);
            });
            box.add(Box.createHorizontalGlue());
            box.add(jButton2);
            box.add(Box.createHorizontalStrut(20));
            box.add(jButton);
            box.add(Box.createHorizontalStrut(20));
            return box;
        }
    }
}

