/*
 * Decompiled with CFR 0.152.
 */
package beast.app.seqgen;

import beast.app.beauti.BeautiDoc;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.util.XMLParser;
import beast.util.XMLParserException;
import beast.util.XMLProducer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Description(value="Helper for Sequence Simulator, allows specifying template input file and destination output file")
public class MergeDataWith
extends BEASTObject {
    public final Input<String> templateFileInput = new Input("template", "name of template file. The template file should be a valid beast2 XML file with a single (possibly empty) alignment. This alignment will be replaced by the alignment generated by the SequenceSimulator. Any occurrance of $(n) will be replaced by the iteration number of the SequenceSimulator. For example, calling a log filename \"output$(n).log\" will be replaced by \"output1.log\" at first iteration, \"output2.log\" at seccond iteration, etc..", Input.Validate.REQUIRED);
    public final Input<String> outputFileInput = new Input("output", "name of the output file. Instances of $(n) are replaced by iteration number.", Input.Validate.REQUIRED);
    File templateFile;

    @Override
    public void initAndValidate() {
        this.templateFile = new File(this.templateFileInput.get());
        if (!this.templateFile.exists()) {
            throw new RuntimeException("Template file " + this.templateFileInput.get() + " does not exist");
        }
    }

    void process(Alignment alignment, int n) throws IOException, XMLParserException, IllegalArgumentException, IllegalAccessException {
        String string = BeautiDoc.load(this.templateFile);
        string = string.replaceAll("\\$\\(n\\)", n + "");
        XMLParser xMLParser = new XMLParser();
        BEASTInterface bEASTInterface = xMLParser.parseBareFragment(string, false);
        Alignment alignment2 = this.getAlignment(bEASTInterface);
        List<Sequence> list = alignment2.sequenceInput.get();
        list.clear();
        list.addAll((Collection<Sequence>)alignment.sequenceInput.get());
        String string2 = this.outputFileInput.get();
        string2 = string2.replaceAll("\\$\\(n\\)", n + "");
        FileWriter fileWriter = new FileWriter(string2);
        HashSet<BEASTInterface> hashSet = new HashSet<BEASTInterface>();
        String string3 = new XMLProducer().toXML(bEASTInterface, hashSet);
        fileWriter.write(string3);
        fileWriter.close();
    }

    private Alignment getAlignment(BEASTInterface bEASTInterface) throws IllegalArgumentException, IllegalAccessException {
        Alignment alignment = null;
        for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
            if (bEASTInterface2.getClass().equals(Alignment.class)) {
                return (Alignment)bEASTInterface2;
            }
            alignment = this.getAlignment(bEASTInterface2);
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }
}

