/*
 * Decompiled with CFR 0.152.
 */
package beast.app.util;

import java.util.StringTokenizer;

public class Arguments {
    public static final String ARGUMENT_CHARACTER = "-";
    private Option[] options = null;
    private String[] leftoverArguments = null;
    private boolean caseSensitive = false;

    public Arguments(Option[] optionArray) {
        this.options = optionArray;
    }

    public Arguments(Option[] optionArray, boolean bl) {
        this.options = optionArray;
        this.caseSensitive = bl;
    }

    public void parseArguments(String[] stringArray) throws ArgumentException {
        int n;
        int n2;
        int[] nArray = new int[stringArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        for (n2 = 0; n2 < this.options.length; ++n2) {
            int n3;
            Option option;
            Option option2 = this.options[n2];
            int n4 = this.findArgument(stringArray, option2.label);
            if (n4 == -1) continue;
            if (nArray[n4] != -1) {
                throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
            }
            String string = stringArray[n4].substring(option2.label.length() + 1);
            nArray[n4] = n2;
            option2.isAvailable = true;
            if (option2 instanceof IntegerArrayOption) {
                option = (IntegerArrayOption)option2;
                option.values = new int[option.count];
                n3 = n4;
                int n5 = 0;
                while (n5 < option.count) {
                    if (string.length() > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            if (string2.length() <= 0) continue;
                            try {
                                option.values[n5] = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad integer value: " + string2);
                            }
                            if (option.values[n5] > option.maxValue || option.values[n5] < option.minValue) {
                                throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad integer value: " + string2);
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                    if (n5 >= option.count) continue;
                    if (n3 >= stringArray.length) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " is missing one or more values: expecting " + option.count + " integers");
                    }
                    if (nArray[n3] != -1) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                    }
                    string = stringArray[n3];
                    nArray[n3] = n2;
                }
                continue;
            }
            if (option2 instanceof IntegerOption) {
                option = (IntegerOption)option2;
                if (string.length() == 0) {
                    n3 = n4 + 1;
                    if (n3 >= stringArray.length) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " is missing its value: expecting an integer");
                    }
                    if (nArray[n3] != -1) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                    }
                    string = stringArray[n3];
                    nArray[n3] = n2;
                }
                try {
                    option.value = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad integer value: " + string);
                }
                if (option.value <= option.maxValue && option.value >= option.minValue) continue;
                throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad integer value: " + string);
            }
            if (option2 instanceof LongOption) {
                option = (LongOption)option2;
                if (string.length() == 0) {
                    n3 = n4 + 1;
                    if (n3 >= stringArray.length) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " is missing its value: expecting a long integer");
                    }
                    if (nArray[n3] != -1) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                    }
                    string = stringArray[n3];
                    nArray[n3] = n2;
                }
                try {
                    ((LongOption)option).value = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad integer value: " + string);
                }
                if (((LongOption)option).value <= ((LongOption)option).maxValue && ((LongOption)option).value >= ((LongOption)option).minValue) continue;
                throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad long integer value: " + string);
            }
            if (option2 instanceof RealArrayOption) {
                int n6;
                option = (RealArrayOption)option2;
                if (((RealArrayOption)option).count >= 0) {
                    n3 = ((RealArrayOption)option).count;
                    ((RealArrayOption)option).values = new double[n3];
                    n6 = n4;
                    int n7 = 0;
                    while (n7 < n3) {
                        if (string.length() > 0) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t ");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                if (string3.length() <= 0) continue;
                                try {
                                    ((RealArrayOption)option).values[n7] = Double.parseDouble(string3);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string3);
                                }
                                if (((RealArrayOption)option).values[n7] > ((RealArrayOption)option).maxValue || ((RealArrayOption)option).values[n7] < ((RealArrayOption)option).minValue) {
                                    throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string3);
                                }
                                ++n7;
                            }
                        }
                        ++n6;
                        if (n7 >= n3) continue;
                        if (n6 >= stringArray.length) {
                            throw new ArgumentException("Argument, " + stringArray[n4] + " is missing one or more values: expecting " + n3 + " integers");
                        }
                        if (nArray[n6] != -1) {
                            throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                        }
                        string = stringArray[n6];
                        nArray[n6] = n2;
                    }
                    continue;
                }
                double[] dArray = new double[100];
                string = stringArray[++n4];
                nArray[n4] = n2;
                n6 = 0;
                if (string.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",\t ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.length() <= 0) continue;
                        try {
                            dArray[n6] = Double.parseDouble(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string4);
                        }
                        if (dArray[n6] > ((RealArrayOption)option).maxValue || dArray[n6] < ((RealArrayOption)option).minValue) {
                            throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string4);
                        }
                        ++n6;
                    }
                }
                ((RealArrayOption)option).values = new double[n6];
                System.arraycopy(dArray, 0, ((RealArrayOption)option).values, 0, n6);
                continue;
            }
            if (option2 instanceof RealOption) {
                option = (RealOption)option2;
                if (string.length() == 0) {
                    n3 = n4 + 1;
                    if (n3 >= stringArray.length) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " is missing its value: expecting a real number");
                    }
                    if (nArray[n3] != -1) {
                        throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                    }
                    string = stringArray[n3];
                    nArray[n3] = n2;
                }
                try {
                    ((RealOption)option).value = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string);
                }
                if (!(((RealOption)option).value > ((RealOption)option).maxValue) && !(((RealOption)option).value < ((RealOption)option).minValue)) continue;
                throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad real value: " + string);
            }
            if (!(option2 instanceof StringOption)) continue;
            option = (StringOption)option2;
            if (string.length() == 0) {
                n3 = n4 + 1;
                if (n3 >= stringArray.length) {
                    throw new ArgumentException("Argument, " + stringArray[n4] + " is missing its value: expecting a string");
                }
                if (nArray[n3] != -1) {
                    throw new ArgumentException("Argument, " + stringArray[n4] + " overlaps with another argument");
                }
                string = stringArray[n3];
                nArray[n3] = n2;
            }
            ((StringOption)option).value = string;
            if (((StringOption)option).options == null) continue;
            n3 = 0;
            for (String string3 : ((StringOption)option).options) {
                if ((this.caseSensitive || !string3.equalsIgnoreCase(((StringOption)option).value)) && !string3.equals(((StringOption)option).value)) continue;
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            throw new ArgumentException("Argument, " + stringArray[n4] + " has a bad string value: " + string);
        }
        n2 = 0;
        for (n = stringArray.length - 1; n >= 0 && nArray[n] == -1 && !stringArray[n].startsWith(ARGUMENT_CHARACTER); --n) {
            ++n2;
        }
        this.leftoverArguments = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.leftoverArguments[n] = stringArray[stringArray.length - n2 + n];
        }
        for (n = 0; n < stringArray.length - n2; ++n) {
            if (nArray[n] != -1) continue;
            throw new ArgumentException("Unrecognized argument: " + stringArray[n]);
        }
    }

    private int findArgument(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() - 1 < string.length() || !stringArray[i].startsWith(ARGUMENT_CHARACTER)) continue;
            String string2 = stringArray[i].substring(1, stringArray[i].length());
            if ((this.caseSensitive || !string.equalsIgnoreCase(string2)) && !string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasOption(String string) {
        int n = this.findOption(string);
        if (n == -1) {
            return false;
        }
        return this.options[n].isAvailable;
    }

    public int getIntegerOption(String string) {
        IntegerOption integerOption = (IntegerOption)this.options[this.findOption(string)];
        return integerOption.value;
    }

    public int[] getIntegerArrayOption(String string) {
        IntegerArrayOption integerArrayOption = (IntegerArrayOption)this.options[this.findOption(string)];
        return integerArrayOption.values;
    }

    public long getLongOption(String string) {
        LongOption longOption = (LongOption)this.options[this.findOption(string)];
        return longOption.value;
    }

    public double getRealOption(String string) {
        RealOption realOption = (RealOption)this.options[this.findOption(string)];
        return realOption.value;
    }

    public double[] getRealArrayOption(String string) {
        RealArrayOption realArrayOption = (RealArrayOption)this.options[this.findOption(string)];
        return realArrayOption.values;
    }

    public String getStringOption(String string) {
        StringOption stringOption = (StringOption)this.options[this.findOption(string)];
        return stringOption.value;
    }

    public String[] getLeftoverArguments() {
        return this.leftoverArguments;
    }

    public void printUsage(String string, String string2) {
        System.out.print("  Usage: " + string);
        for (Option option : this.options) {
            int n;
            Option option2;
            System.out.print(" [-" + option.label);
            if (option instanceof IntegerArrayOption) {
                option2 = (IntegerArrayOption)option;
                for (n = 1; n <= option2.count; ++n) {
                    System.out.print(" <i" + n + ">");
                }
                System.out.print("]");
                continue;
            }
            if (option instanceof IntegerOption) {
                System.out.print(" <i>]");
                continue;
            }
            if (option instanceof RealArrayOption) {
                option2 = (RealArrayOption)option;
                for (n = 1; n <= ((RealArrayOption)option2).count; ++n) {
                    System.out.print(" <r" + n + ">");
                }
                System.out.print("]");
                continue;
            }
            if (option instanceof RealOption) {
                System.out.print(" <r>]");
                continue;
            }
            if (option instanceof StringOption) {
                option2 = (StringOption)option;
                if (((StringOption)option2).options != null) {
                    System.out.print(" <" + ((StringOption)option2).options[0]);
                    for (n = 1; n < ((StringOption)option2).options.length; ++n) {
                        System.out.print("|" + ((StringOption)option2).options[n]);
                    }
                    System.out.print(">]");
                    continue;
                }
                System.out.print(" <" + ((StringOption)option2).tag + ">]");
                continue;
            }
            System.out.print("]");
        }
        System.out.println(" " + string2);
        for (Option option : this.options) {
            System.out.println("    -" + option.label + " " + option.description);
        }
    }

    private int findOption(String string) {
        for (int i = 0; i < this.options.length; ++i) {
            String string2 = this.options[i].label;
            if ((this.caseSensitive || !string.equalsIgnoreCase(string2)) && !string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public static class RealArrayOption
    extends RealOption {
        private int count;
        double[] values = null;

        public RealArrayOption(String string, int n, String string2) {
            this(string, n, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, string2);
        }

        public RealArrayOption(String string, int n, double d, double d2, String string2) {
            super(string, d, d2, string2);
            this.count = n;
        }
    }

    public static class RealOption
    extends Option {
        double minValue = Double.NEGATIVE_INFINITY;
        double maxValue = Double.POSITIVE_INFINITY;
        double value = 0.0;

        public RealOption(String string, String string2) {
            super(string, string2);
        }

        public RealOption(String string, double d, double d2, String string2) {
            super(string, string2);
            this.minValue = d;
            this.maxValue = d2;
        }
    }

    public static class LongOption
    extends Option {
        long minValue = Long.MIN_VALUE;
        long maxValue = Long.MAX_VALUE;
        long value = 0L;

        public LongOption(String string, String string2) {
            super(string, string2);
        }

        public LongOption(String string, long l, long l2, String string2) {
            super(string, string2);
            this.minValue = l;
            this.maxValue = l2;
        }
    }

    public static class IntegerArrayOption
    extends IntegerOption {
        int count;
        int[] values = null;

        public IntegerArrayOption(String string, String string2) {
            this(string, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, string2);
        }

        public IntegerArrayOption(String string, int n, String string2) {
            this(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE, string2);
        }

        public IntegerArrayOption(String string, int n, int n2, String string2) {
            this(string, 0, n, n2, string2);
        }

        public IntegerArrayOption(String string, int n, int n2, int n3, String string2) {
            super(string, n2, n3, string2);
            this.count = n;
        }
    }

    public static class IntegerOption
    extends Option {
        int minValue = Integer.MIN_VALUE;
        int maxValue = Integer.MAX_VALUE;
        int value = 0;

        public IntegerOption(String string, String string2) {
            super(string, string2);
        }

        public IntegerOption(String string, int n, int n2, String string2) {
            super(string, string2);
            this.minValue = n;
            this.maxValue = n2;
        }
    }

    public static class StringOption
    extends Option {
        String[] options = null;
        String tag = null;
        boolean caseSensitive = false;
        String value = null;

        public StringOption(String string, String string2, String string3) {
            super(string, string3);
            this.tag = string2;
        }

        public StringOption(String string, String[] stringArray, boolean bl, String string2) {
            super(string, string2);
            this.options = stringArray;
            this.caseSensitive = bl;
        }
    }

    public static class Option {
        String label;
        String description;
        boolean isAvailable = false;

        public Option(String string, String string2) {
            this.label = string;
            this.description = string2;
        }
    }

    public static class ArgumentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ArgumentException() {
        }

        public ArgumentException(String string) {
            super(string);
        }
    }
}

