/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.StateNode;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public interface Parameter<T>
extends Function {
    public T getValue(int var1);

    public T getValue();

    public void setValue(int var1, T var2);

    public void setValue(T var1);

    public T getLower();

    public void setLower(T var1);

    public T getUpper();

    public void setUpper(T var1);

    public T[] getValues();

    public String getID();

    public int getMinorDimension1();

    public int getMinorDimension2();

    public T getMatrixValue(int var1, int var2);

    public void swap(int var1, int var2);

    @Description(value="A parameter represents a value in the state space that can be changed by operators.")
    public static abstract class Base<T>
    extends StateNode
    implements Parameter<T> {
        public final Input<List<T>> valuesInput = new Input("value", "start value(s) for this parameter. If multiple values are specified, they should be separated by whitespace.", new ArrayList(), Input.Validate.REQUIRED, this.getMax().getClass());
        public final Input<Integer> dimensionInput = new Input<Integer>("dimension", "dimension of the parameter (default 1, i.e scalar)", 1);
        public final Input<Integer> minorDimensionInput = new Input<Integer>("minordimension", "minor-dimension when the parameter is interpreted as a matrix (default 1)", 1);
        protected T m_fUpper;
        protected T m_fLower;
        protected T[] values;
        protected T[] storedValues;
        protected int minorDimension = 1;
        protected boolean[] m_bIsDirty;
        protected int m_nLastDirty;

        public Base() {
        }

        public Base(T[] TArray) {
            this.values = (Object[])TArray.clone();
            this.storedValues = (Object[])TArray.clone();
            this.m_fUpper = this.getMax();
            this.m_fLower = this.getMin();
            this.m_bIsDirty = new boolean[TArray.length];
            for (T t : TArray) {
                this.valuesInput.get().add(t);
            }
        }

        @Override
        public void initAndValidate() {
            Object[] objectArray = this.valuesInput.get().toArray((Object[])Array.newInstance(this.getMax().getClass(), 0));
            int n = Math.max(this.dimensionInput.get(), objectArray.length);
            this.dimensionInput.setValue(n, this);
            this.values = (Object[])Array.newInstance(this.getMax().getClass(), n);
            this.storedValues = (Object[])Array.newInstance(this.getMax().getClass(), n);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = objectArray[i % objectArray.length];
            }
            this.m_bIsDirty = new boolean[this.dimensionInput.get().intValue()];
            this.minorDimension = this.minorDimensionInput.get();
            if (this.minorDimension > 0 && this.dimensionInput.get() % this.minorDimension > 0) {
                throw new IllegalArgumentException("Dimension must be divisible by stride");
            }
            this.storedValues = (Object[])this.values.clone();
        }

        abstract T getMax();

        abstract T getMin();

        public boolean isDirty(int n) {
            return this.m_bIsDirty[n];
        }

        public int getLastDirty() {
            return this.m_nLastDirty;
        }

        @Override
        public void setEverythingDirty(boolean bl) {
            this.setSomethingIsDirty(bl);
            Arrays.fill(this.m_bIsDirty, bl);
        }

        @Override
        public int getDimension() {
            return this.values.length;
        }

        public void setDimension(int n) {
            if (this.getDimension() != n) {
                Object[] objectArray = (Object[])Array.newInstance(this.getMax().getClass(), n);
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.values[i % this.getDimension()];
                }
                this.values = objectArray;
            }
            this.m_bIsDirty = new boolean[n];
            try {
                this.dimensionInput.setValue(n, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setMinorDimension(int n) {
            this.minorDimension = n;
            if (this.minorDimension > 0 && this.dimensionInput.get() % this.minorDimension > 0) {
                throw new IllegalArgumentException("Dimension must be divisible by stride");
            }
        }

        @Override
        public T getValue() {
            return this.values[0];
        }

        @Override
        public T getLower() {
            return this.m_fLower;
        }

        @Override
        public void setLower(T t) {
            this.m_fLower = t;
        }

        @Override
        public T getUpper() {
            return this.m_fUpper;
        }

        @Override
        public void setUpper(T t) {
            this.m_fUpper = t;
        }

        @Override
        public T getValue(int n) {
            return this.values[n];
        }

        @Override
        public T[] getValues() {
            return Arrays.copyOf(this.values, this.values.length);
        }

        public void setBounds(T t, T t2) {
            this.m_fLower = t;
            this.m_fUpper = t2;
        }

        @Override
        public void setValue(T t) {
            this.startEditing(null);
            this.values[0] = t;
            this.m_bIsDirty[0] = true;
            this.m_nLastDirty = 0;
        }

        @Override
        public void setValue(int n, T t) {
            this.startEditing(null);
            this.values[n] = t;
            this.m_bIsDirty[n] = true;
            this.m_nLastDirty = n;
        }

        @Override
        public void swap(int n, int n2) {
            this.startEditing(null);
            T t = this.values[n];
            this.values[n] = this.values[n2];
            this.values[n2] = t;
            this.m_bIsDirty[n] = true;
            this.m_bIsDirty[n2] = true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getID()).append("[").append(this.values.length);
            if (this.minorDimension > 0) {
                stringBuilder.append(" ").append(this.minorDimension);
            }
            stringBuilder.append("] ");
            stringBuilder.append("(").append(this.m_fLower).append(",").append(this.m_fUpper).append("): ");
            for (T t : this.values) {
                stringBuilder.append(t).append(" ");
            }
            return stringBuilder.toString();
        }

        @Override
        public Base<T> copy() {
            try {
                Base base = (Base)this.clone();
                base.values = (Object[])this.values.clone();
                base.m_bIsDirty = new boolean[this.values.length];
                return base;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        @Override
        public void assignTo(StateNode stateNode) {
            Base base = (Base)stateNode;
            base.setID(this.getID());
            base.index = this.index;
            base.values = (Object[])this.values.clone();
            base.m_fLower = this.m_fLower;
            base.m_fUpper = this.m_fUpper;
            base.m_bIsDirty = new boolean[this.values.length];
        }

        @Override
        public void assignFrom(StateNode stateNode) {
            Base base = (Base)stateNode;
            this.setID(base.getID());
            this.values = (Object[])base.values.clone();
            this.storedValues = (Object[])base.storedValues.clone();
            System.arraycopy(base.values, 0, this.values, 0, this.values.length);
            this.m_fLower = base.m_fLower;
            this.m_fUpper = base.m_fUpper;
            this.m_bIsDirty = new boolean[base.values.length];
        }

        @Override
        public void assignFromFragile(StateNode stateNode) {
            Base base = (Base)stateNode;
            System.arraycopy(base.values, 0, this.values, 0, Math.min(this.values.length, base.getDimension()));
            Arrays.fill(this.m_bIsDirty, false);
        }

        @Override
        public void init(PrintStream printStream) {
            int n = this.getDimension();
            if (n == 1) {
                printStream.print(this.getID() + "\t");
            } else {
                for (int i = 0; i < n; ++i) {
                    printStream.print(this.getID() + (i + 1) + "\t");
                }
            }
        }

        @Override
        public void close(PrintStream printStream) {
        }

        @Override
        public void fromXML(Node node) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.setID(namedNodeMap.getNamedItem("id").getNodeValue());
            String string = node.getTextContent();
            Pattern pattern = Pattern.compile(".*\\[(.*) (.*)\\].*\\((.*),(.*)\\): (.*) ");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                String string5 = matcher.group(4);
                String string6 = matcher.group(5);
                String[] stringArray = string6.split(" ");
                this.minorDimension = Integer.parseInt(string3);
                this.fromXML(Integer.parseInt(string2), string4, string5, stringArray);
            } else {
                pattern = Pattern.compile(".*\\[(.*)\\].*\\((.*),(.*)\\): (.*) ");
                matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    String string7 = matcher.group(1);
                    String string8 = matcher.group(2);
                    String string9 = matcher.group(3);
                    String string10 = matcher.group(4);
                    String[] stringArray = string10.split(" ");
                    this.minorDimension = 0;
                    this.fromXML(Integer.parseInt(string7), string8, string9, stringArray);
                } else {
                    throw new RuntimeException("parameter could not be parsed");
                }
            }
        }

        abstract void fromXML(int var1, String var2, String var3, String[] var4);

        @Override
        public int getMinorDimension1() {
            return this.minorDimension;
        }

        @Override
        public int getMinorDimension2() {
            return this.getDimension() / this.minorDimension;
        }

        @Override
        public T getMatrixValue(int n, int n2) {
            return this.values[n * this.minorDimension + n2];
        }

        public void setMatrixValue(int n, int n2, T t) {
            this.setValue(n * this.minorDimension + n2, t);
        }

        public void getMatrixValues1(int n, T[] TArray) {
            assert (TArray.length == this.minorDimension);
            System.arraycopy(this.values, n * this.minorDimension, TArray, 0, this.minorDimension);
        }

        public void getMatrixValues1(int n, double[] dArray) {
            assert (dArray.length == this.minorDimension);
            for (int i = 0; i < this.minorDimension; ++i) {
                dArray[i] = this.getArrayValue(n * this.minorDimension + i);
            }
        }

        public void getMatrixValues2(int n, T[] TArray) {
            assert (TArray.length == this.getMinorDimension2());
            for (int i = 0; i < this.getMinorDimension2(); ++i) {
                TArray[i] = this.values[i * this.minorDimension + n];
            }
        }

        public void getMatrixValues2(int n, double[] dArray) {
            assert (dArray.length == this.getMinorDimension2());
            for (int i = 0; i < this.getMinorDimension2(); ++i) {
                dArray[i] = this.getArrayValue(i * this.minorDimension + n);
            }
        }

        @Override
        protected void store() {
            if (this.storedValues.length != this.values.length) {
                this.storedValues = (Object[])Array.newInstance(this.m_fUpper.getClass(), this.values.length);
            }
            System.arraycopy(this.values, 0, this.storedValues, 0, this.values.length);
        }

        @Override
        public void restore() {
            T[] TArray = this.storedValues;
            this.storedValues = this.values;
            this.values = TArray;
            this.hasStartedEditing = false;
            if (this.m_bIsDirty.length != this.values.length) {
                this.m_bIsDirty = new boolean[this.values.length];
            }
        }
    }
}

