/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.tree.Node;
import beast.evolution.tree.RandomTree;
import beast.evolution.tree.Tree;
import beast.evolution.tree.coalescent.PopulationFunction;
import java.util.List;

@Description(value="Generates a random gene tree conditioned on a species tree, such that the root of the species tree is lower than any coalescent events in the gene tree")
public class RandomGeneTree
extends RandomTree {
    public final Input<Tree> speciesTreeInput = new Input("speciesTree", "The species tree in which this random gene tree needs to fit", Input.Validate.REQUIRED);

    @Override
    public void initAndValidate() {
        super.initAndValidate();
    }

    @Override
    public Node simulateCoalescentWithMax(List<Node> list, PopulationFunction populationFunction, double d) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("empty nodes set");
        }
        double d2 = this.speciesTreeInput.get().getRoot().getHeight();
        for (int i = 0; i < 1000; ++i) {
            try {
                List<Node> list2 = this.simulateCoalescent(list, populationFunction, d2, d);
                if (list2.size() != 1) continue;
                return list2.get(0);
            }
            catch (RandomTree.ConstraintViolatedException constraintViolatedException) {
                // empty catch block
            }
        }
        throw new RuntimeException("failed to merge trees after 1000 tries!");
    }
}

