/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeUtils;
import beast.util.CredibleSet;
import beast.util.FrequencySet;
import beast.util.NexusParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeTraceAnalysis {
    public static final double DEFAULT_BURN_IN_FRACTION = 0.1;
    protected List<Tree> treeInTrace;
    protected int totalTrees;
    protected int burnin;
    protected FrequencySet<String> topologiesFrequencySet;
    protected CredibleSet<String> credibleSet;
    protected boolean isTaxaLabel = true;

    public TreeTraceAnalysis(List<Tree> list) {
        this(list, 0.1);
    }

    public TreeTraceAnalysis(List<Tree> list, double d) {
        assert (list != null);
        this.removeBurnin(list, d);
    }

    public void analyze() {
        this.analyze(0.95);
    }

    public void analyze(double d) {
        this.topologiesFrequencySet = new FrequencySet();
        this.topologiesFrequencySet.setCredSetProbability(d);
        for (Tree tree : this.treeInTrace) {
            String string = this.uniqueNewick(tree.getRoot());
            this.topologiesFrequencySet.add(string, 1);
        }
        this.credibleSet = this.topologiesFrequencySet.getCredibleSet();
    }

    public void report(PrintStream printStream, boolean bl) {
        printStream.println("# burnin = " + String.valueOf(this.burnin));
        printStream.println("# total trees used (total - burnin) = " + String.valueOf(this.treeInTrace.size()));
        printStream.print("# \n# " + String.valueOf(this.topologiesFrequencySet.getCredSetProbability() * 100.0) + "% credible set");
        printStream.println(" (" + String.valueOf(this.credibleSet.credibleSetList.size()) + " unique tree topologies, " + String.valueOf(this.credibleSet.sumFrequency) + " trees in total)");
        if (bl) {
            printStream.println("Rank\tCount\tPercent\tRunning\tTree");
            double d = 0.0;
            for (int i = 0; i < this.credibleSet.credibleSetList.size(); ++i) {
                double d2 = 100.0 * (double)this.credibleSet.getFrequency(i, this.topologiesFrequencySet) / (double)(this.totalTrees - this.burnin);
                printStream.print(i + 1 + "\t");
                printStream.print(this.credibleSet.getFrequency(i, this.topologiesFrequencySet) + "\t");
                printStream.format("%.2f%%\t", d2);
                printStream.format("%.2f%%\t", d += d2);
                printStream.println((String)this.credibleSet.credibleSetList.get(i));
            }
        }
    }

    public void report(PrintStream printStream) {
        this.report(printStream, true);
    }

    public String uniqueNewick(Node node) {
        return TreeUtils.sortedNewickTopology(node, this.isTaxaLabel);
    }

    public boolean isTaxaLabel() {
        return this.isTaxaLabel;
    }

    public void setTaxaLabel(boolean bl) {
        this.isTaxaLabel = bl;
    }

    public int getBurnin() {
        return this.burnin;
    }

    public double getBurninFraction() {
        return (double)this.burnin / (double)this.totalTrees;
    }

    public double getCredSetProbability() {
        return this.topologiesFrequencySet.getCredSetProbability();
    }

    public List<String> getCredibleSetList() {
        return this.credibleSet.credibleSetList;
    }

    public int getTotalTreesInLog() {
        return this.totalTrees;
    }

    public int getTotalTreesBurninRemoved() {
        return this.treeInTrace.size();
    }

    public Map<String, Integer> getTopologyCounts() {
        return this.topologiesFrequencySet.getFrequencyMap();
    }

    protected void removeBurnin(List<Tree> list, double d) {
        this.totalTrees = list.size();
        this.burnin = Utils.getBurnIn(this.totalTrees, d);
        this.treeInTrace = Utils.getSubListOfTrees(list, this.burnin);
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        File file = null;
        if (stringArray.length > 0) {
            System.out.println("Input file  = " + stringArray[0]);
            file = new File(stringArray[0]);
        } else {
            System.out.println("Error: Expected nexus file, but not file name was provided.");
            System.exit(1);
        }
        if (stringArray.length > 1) {
            System.out.println("Output file = " + stringArray[1]);
            try {
                printStream = new PrintStream(new FileOutputStream(stringArray[1]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Error: Unable to create output file.");
                System.exit(1);
            }
        }
        List<Tree> list = null;
        try {
            list = Utils.getTrees(file);
        }
        catch (Exception exception) {
            System.out.println("Error occurred while parsing input file.");
            System.exit(1);
        }
        TreeTraceAnalysis treeTraceAnalysis = new TreeTraceAnalysis(list);
        treeTraceAnalysis.analyze();
        treeTraceAnalysis.report(printStream);
    }

    public static class Utils {
        public static List<Tree> getTrees(File file) throws IOException {
            NexusParser nexusParser = new NexusParser();
            nexusParser.parseFile(file);
            return nexusParser.trees;
        }

        public static int getBurnIn(int n, double d) {
            int n2 = (int)((double)n * d);
            assert (n2 < n);
            return n2;
        }

        public static List<Tree> getSubListOfTrees(List<Tree> list, int n, int n2) {
            assert (n < n2);
            return new ArrayList<Tree>(list.subList(n, n2));
        }

        public static List<Tree> getSubListOfTrees(List<Tree> list, int n) {
            return Utils.getSubListOfTrees(list, n, list.size());
        }
    }
}

