/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.util.Log;
import beast.util.MersenneTwisterFast;

public class Randomizer {
    private static final MersenneTwisterFast random = MersenneTwisterFast.DEFAULT_INSTANCE;
    static int m_nIDNr = 0;

    private Randomizer() {
    }

    public static int randomChoice(double[] dArray) {
        int n;
        double d = random.nextDouble();
        if (d <= dArray[0]) {
            n = 0;
        } else {
            for (n = 1; !(n >= dArray.length || d <= dArray[n] && d > dArray[n - 1]); ++n) {
            }
        }
        return n;
    }

    public static int randomChoicePDF(double[] dArray) {
        int n;
        double d = random.nextDouble() * Randomizer.getTotal(dArray);
        for (n = 0; n < dArray.length; ++n) {
            if (!((d -= dArray[n]) < 0.0)) continue;
            return n;
        }
        for (n = 0; n < dArray.length; ++n) {
            Log.err.println(n + "\t" + dArray[n]);
        }
        throw new Error("randomChoiceUnnormalized falls through -- negative components in input distribution?");
    }

    public static double[] getNormalized(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = Randomizer.getTotal(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public static double getTotal(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double getTotal(double[] dArray) {
        return Randomizer.getTotal(dArray, 0, dArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSeed() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.getSeed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSeed(long l) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.setSeed(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte nextByte() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nextBoolean() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextBytes(byte[] byArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.nextBytes(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextChar() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGaussian() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGaussian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGamma(double d, double d2) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGamma(d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextPoisson(double d) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextPoisson(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextDouble() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextDouble();
        }
    }

    public static double randomLogDouble() {
        return Math.log(Randomizer.nextDouble());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextExponential(double d) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return -1.0 * Math.log(1.0 - random.nextDouble()) / d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextGeometric(double d) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            double d2 = -Math.log(1.0 - d);
            return Math.round(Math.floor(Randomizer.nextExponential(d2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nextFloat() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextLong() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short nextShort() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt(n);
        }
    }

    public static double uniform(double d, double d2) {
        return d + Randomizer.nextDouble() * (d2 - d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] nArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] nArray, int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(nArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] shuffled(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.shuffled(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] sampleIndicesWithReplacement(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = random.nextInt(n);
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void permute(int[] nArray) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.permute(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] permuted(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.permuted(n);
        }
    }

    public static int nextIDNr() {
        return m_nIDNr++;
    }
}

