/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.InputForAnnotatedConstructor;
import beast.core.Param;
import beast.core.util.Log;
import beast.util.AddOnManager;
import beast.util.InputType;
import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParserUtils {
    public static final List<String> beastObjectNames = AddOnManager.find(BEASTInterface.class, AddOnManager.IMPLEMENTATION_DIR);

    public static void processPlates(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = nodeList.item(0);
            String string2 = object4.getAttributes().getNamedItem("var").getNodeValue();
            String string3 = object4.getAttributes().getNamedItem("range").getNodeValue();
            if (object4.getAttributes().getNamedItem("fragment") != null) {
                object3 = object4.getAttributes().getNamedItem("fragment").getNodeValue();
                object2 = XMLParserUtils.getElementById(document, (String)object3);
                if (object2 == null) {
                    throw new RuntimeException("plate refers to fragment with id='" + (String)object3 + "' that cannot be found");
                }
                object2 = object2.cloneNode(true);
                object4.getParentNode().replaceChild((Node)object2, (Node)object4);
                object4 = object2;
            }
            object3 = string3.split(",");
            object2 = new ArrayList();
            for (String string4 : object3) {
                if (string4.indexOf(":") > 0) {
                    try {
                        object = string4.split(":");
                        int n = Integer.parseInt(object[0]);
                        int n2 = Integer.parseInt(object[1]);
                        for (int i = n; i <= n2; ++i) {
                            object2.add(String.valueOf(i));
                        }
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.warning.println("plate range value '" + string4 + "'contains a ':' but does not seem to be a range, (like 1:5).");
                        Log.warning.println("interpreting it as if it were not a range");
                        object2.add(string4);
                        continue;
                    }
                }
                object2.add(string4);
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                NodeList nodeList2 = object4.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    object = nodeList2.item(i);
                    Node node = object.cloneNode(true);
                    XMLParserUtils.replaceVariable(node, string2, string5);
                    object4.getParentNode().insertBefore(node, (Node)object4);
                }
            }
            object4.getParentNode().removeChild((Node)object4);
            XMLParserUtils.processPlates(document, string);
        }
    }

    static Node getElementById(Document document, String string) {
        if (document.getElementById(string) == null) {
            XMLParserUtils.registerIDs(document, document.getDocumentElement());
        }
        return document.getElementById(string);
    }

    static void registerIDs(Document document, Node node) {
        Object object;
        if (node.getNodeType() == 1 && node.getAttributes().getNamedItem("id") != null) {
            object = node.getAttributes().getNamedItem("id").getNodeValue();
            ((CoreDocumentImpl)document).putIdentifier((String)object, (Element)node);
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            XMLParserUtils.registerIDs(document, object.item(i));
        }
    }

    public static void saveDocAsXML(Document document, String string) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult streamResult = new StreamResult(new File(string));
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void replaceVariable(Node node, String string, String string2) {
        Object object;
        switch (node.getNodeType()) {
            case 1: {
                object = (Element)node;
                NamedNodeMap namedNodeMap = object.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.getValue().contains("$(" + string + ")")) continue;
                    String string3 = attr.getValue();
                    string3 = string3.replaceAll("\\$\\(" + string + "\\)", string2);
                    attr.setNodeValue(string3);
                }
            }
            case 4: {
                object = node.getTextContent();
                if (!((String)object).contains("$(" + string + ")")) break;
                object = ((String)object).replaceAll("\\$\\(" + string + "\\)", string2);
                node.setNodeValue((String)object);
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            XMLParserUtils.replaceVariable(node2, string, string2);
        }
    }

    public static List<InputType> listInputs(Class<?> clazz, BEASTInterface bEASTInterface) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        Object object;
        ArrayList<InputType> arrayList = new ArrayList<InputType>();
        try {
            if (bEASTInterface == null) {
                bEASTInterface = (BEASTInterface)clazz.newInstance();
            }
            object = null;
            object = bEASTInterface.listInputs();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Input input = (Input)iterator.next();
                if (input instanceof InputForAnnotatedConstructor) continue;
                try {
                    if (input.getType() == null) {
                        input.determineClass(bEASTInterface);
                    }
                    arrayList.add(new InputType(input.getName(), input.getType(), true, input.defaultValue));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        for (Object object2 : object = clazz.getDeclaredConstructors()) {
            Annotation[][] annotationArray = ((Constructor)object2).getParameterAnnotations();
            ArrayList<Param> arrayList2 = new ArrayList<Param>();
            for (Annotation[] annotationArray2 : annotationArray) {
                for (Annotation classNotFoundException : annotationArray2) {
                    if (!(classNotFoundException instanceof Param)) continue;
                    arrayList2.add((Param)classNotFoundException);
                }
            }
            Annotation[][] annotationArray3 = ((Constructor)object2).getParameterTypes();
            Type[] typeArray = ((Constructor)object2).getGenericParameterTypes();
            if (annotationArray3.length <= 0 || arrayList2.size() <= 0) continue;
            int n = 0;
            if (annotationArray3.length == arrayList2.size() + 1) {
                n = 1;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                Param param = (Param)arrayList2.get(i);
                Annotation[] annotationArray4 = annotationArray3[i + n];
                Class<List> clazz2 = null;
                try {
                    clazz2 = Class.forName(annotationArray4.getTypeName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                if (clazz2.isAssignableFrom(List.class)) {
                    Type[] typeArray2 = ((ParameterizedType)typeArray[i + n]).getActualTypeArguments();
                    Class clazz3 = (Class)typeArray2[0];
                    InputType inputType = new InputType(param.name(), clazz3, false, param.defaultValue());
                    arrayList.add(inputType);
                    continue;
                }
                InputType inputType = new InputType(param.name(), (Class<?>)annotationArray3[i + n], false, param.defaultValue());
                arrayList.add(inputType);
            }
        }
        return arrayList;
    }

    static String guessClass(String string) {
        String string2 = string;
        if (string.contains(".")) {
            string2 = string.substring(string.lastIndexOf(46) + 1);
        }
        int n = Integer.MAX_VALUE;
        String string3 = null;
        for (String string4 : beastObjectNames) {
            String string5 = string4.substring(string4.lastIndexOf(46) + 1);
            int n2 = XMLParserUtils.getLevenshteinDistance(string2, string5);
            if (n2 >= n) continue;
            n = n2;
            string3 = string4;
        }
        return string3;
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            nArray2[0] = i;
            for (n = 1; n <= n2; ++n) {
                int n4 = string.charAt(n - 1) == c ? 0 : 1;
                nArray2[n] = Math.min(Math.min(nArray2[n - 1] + 1, nArray[n] + 1), nArray[n - 1] + n4);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n2];
    }
}

