/*
 * Decompiled with CFR 0.152.
 */
package jam.framework;

import jam.framework.Application;
import jam.framework.Exportable;
import jam.util.PrintUtilities;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public abstract class AbstractFrame
extends JFrame
implements Exportable {
    private JMenuBar menuBar = null;
    private boolean isDirty = false;
    private AbstractAction saveAction = new AbstractAction("Save"){

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    };
    private AbstractAction saveAsAction = new AbstractAction("Save As..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    };
    private Action importAction = null;
    private Action exportAction = null;
    private AbstractAction printAction = new AbstractAction("Print..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doPrint();
        }
    };
    protected AbstractAction closeWindowAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doCloseWindow();
        }
    };
    private AbstractAction zoomWindowAction = new AbstractAction("Zoom Window"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doZoomWindow();
        }
    };
    private AbstractAction minimizeWindowAction = new AbstractAction("Minimize Window"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doMinimizeWindow();
        }
    };
    private AbstractAction cutAction = new AbstractAction("Cut"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doCut();
        }
    };
    private AbstractAction copyAction = new AbstractAction("Copy"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doCopy();
        }
    };
    private AbstractAction pasteAction = new AbstractAction("Paste"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doPaste();
        }
    };
    private AbstractAction deleteAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doDelete();
        }
    };
    private AbstractAction selectAllAction = new AbstractAction("Select All"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doSelectAll();
        }
    };
    private AbstractAction findAction = new AbstractAction("Find..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractFrame.this.doFind();
        }
    };

    public final void initialize() {
        this.initializeComponents();
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            if (Application.getMenuBarFactory() == null) {
                return;
            }
            Application.getMenuBarFactory().populateMenuBar(this.menuBar, this);
        }
        this.setJMenuBar(this.menuBar);
    }

    protected abstract void initializeComponents();

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty() {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        this.isDirty = true;
    }

    public final void clearDirty() {
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        this.isDirty = false;
    }

    public abstract boolean requestClose();

    public void doImport() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doExport() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public final void doPrint() {
        this.doPrint(false);
    }

    public final void doPrint(boolean scaleIfDoesntImplementPrintable) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        JComponent component = this.getExportableComponent();
        if (component != null) {
            if (component instanceof Printable) {
                printJob.setPrintable((Printable)((Object)component));
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException pe) {
                        JOptionPane.showMessageDialog(this, "Printing error: " + pe, "Error Printing", 0);
                    }
                }
            } else if (scaleIfDoesntImplementPrintable) {
                PrintUtilities.printComponentScaled(component);
            } else {
                PrintUtilities.printComponent(component);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Printing error: No panel provided to print", "Error Printing", 0);
        }
    }

    public void doCloseWindow() {
        if (this.requestClose()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void doZoomWindow() {
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.setExtendedState(6);
        }
    }

    public void doMinimizeWindow() {
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(1)) {
            this.setExtendedState(1);
        }
    }

    public void doCut() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doCopy() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doPaste() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doDelete() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doSelectAll() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public void doFind() {
        throw new RuntimeException("Not implemented in AbstractFrame - this must be overridden");
    }

    public Action getNewAction() {
        return Application.getApplication().getNewAction();
    }

    public Action getOpenAction() {
        return Application.getApplication().getOpenAction();
    }

    public Action getPageSetupAction() {
        return Application.getApplication().getPageSetupAction();
    }

    public Action getExitAction() {
        return Application.getApplication().getExitAction();
    }

    public Action getCloseWindowAction() {
        return this.closeWindowAction;
    }

    public Action getAboutAction() {
        return Application.getApplication().getAboutAction();
    }

    public Action getPreferencesAction() {
        return Application.getApplication().getPreferencesAction();
    }

    public Action getWebsiteAction() {
        return Application.getApplication().getWebsiteAction();
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    public Action getSaveAsAction() {
        return this.saveAsAction;
    }

    public Action getZoomWindowAction() {
        return this.zoomWindowAction;
    }

    public Action getMinimizeWindowAction() {
        return this.minimizeWindowAction;
    }

    public void setImportAction(Action importAction) {
        assert (importAction != null) : "Import Action already set for this frame";
        this.importAction = importAction;
    }

    public void setExportAction(Action exportAction) {
        assert (exportAction != null) : "Export Action already set for this frame";
        this.exportAction = exportAction;
    }

    public Action getImportAction() {
        return this.importAction;
    }

    public Action getExportAction() {
        return this.exportAction;
    }

    public Action getPrintAction() {
        return this.printAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public Action getHelpAction() {
        return null;
    }
}

