/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MaxIterationsExceededException;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double d) throws MathException {
        return this.evaluate(d, 1.0E-8, Integer.MAX_VALUE);
    }

    public double evaluate(double d, double d2) throws MathException {
        return this.evaluate(d, d2, Integer.MAX_VALUE);
    }

    public double evaluate(double d, int n) throws MathException {
        return this.evaluate(d, 1.0E-8, n);
    }

    public double evaluate(double d, double d2, int n) throws MathException {
        double d3 = 1.0;
        double d4 = this.getA(0, d);
        double d5 = 0.0;
        double d6 = 1.0;
        double d7 = d4 / d6;
        int n2 = 0;
        double d8 = Double.MAX_VALUE;
        while (n2 < n && d8 > d2) {
            double d9;
            double d10 = this.getA(++n2, d);
            double d11 = this.getB(n2, d);
            double d12 = d10 * d4 + d11 * d3;
            double d13 = d10 * d6 + d11 * d5;
            boolean bl = false;
            if (Double.isInfinite(d12) || Double.isInfinite(d13)) {
                d9 = 1.0;
                double d14 = 1.0;
                double d15 = Math.max(d10, d11);
                if (d15 <= 0.0) {
                    throw new ConvergenceException("Continued fraction convergents diverged to +/- infinity for value {0}", d);
                }
                bl = true;
                for (int i = 0; i < 5; ++i) {
                    d14 = d9;
                    d9 *= d15;
                    if (d10 != 0.0 && d10 > d11) {
                        d12 = d4 / d14 + d11 / d9 * d3;
                        d13 = d6 / d14 + d11 / d9 * d5;
                    } else if (d11 != 0.0) {
                        d12 = d10 / d9 * d4 + d3 / d14;
                        d13 = d10 / d9 * d6 + d5 / d14;
                    }
                    boolean bl2 = bl = Double.isInfinite(d12) || Double.isInfinite(d13);
                    if (!bl) break;
                }
            }
            if (bl) {
                throw new ConvergenceException("Continued fraction convergents diverged to +/- infinity for value {0}", d);
            }
            d9 = d12 / d13;
            if (Double.isNaN(d9)) {
                throw new ConvergenceException("Continued fraction diverged to NaN for value {0}", d);
            }
            d8 = Math.abs(d9 / d7 - 1.0);
            d7 = d12 / d13;
            d3 = d4;
            d4 = d12;
            d5 = d6;
            d6 = d13;
        }
        if (n2 >= n) {
            throw new MaxIterationsExceededException(n, "Continued fraction convergents failed to converge for value {0}", d);
        }
        return d7;
    }
}

