/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "annotate_options.h"

AnnotateOptions::AnnotateOptions (bool init /* = true */) :
    mOptions (AnnotateOptions::OptionNum),
    mNotify (AnnotateOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
AnnotateOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // initiate_free_draw_button
    mOptions[AnnotateOptions::InitiateFreeDrawButton].setName ("initiate_free_draw_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Alt>Button1");
    mOptions[AnnotateOptions::InitiateFreeDrawButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::InitiateFreeDrawButton].value ().action ());

    // initiate_line_button
    mOptions[AnnotateOptions::InitiateLineButton].setName ("initiate_line_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Alt>Button2");
    mOptions[AnnotateOptions::InitiateLineButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::InitiateLineButton].value ().action ());

    // initiate_rectangle_button
    mOptions[AnnotateOptions::InitiateRectangleButton].setName ("initiate_rectangle_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Alt><Shift>Button1");
    mOptions[AnnotateOptions::InitiateRectangleButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::InitiateRectangleButton].value ().action ());

    // initiate_ellipse_button
    mOptions[AnnotateOptions::InitiateEllipseButton].setName ("initiate_ellipse_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Alt><Shift>Button2");
    mOptions[AnnotateOptions::InitiateEllipseButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::InitiateEllipseButton].value ().action ());

    // draw
    mOptions[AnnotateOptions::Draw].setName ("draw", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[AnnotateOptions::Draw].value().set(CompAction ());
    mOptions[AnnotateOptions::Draw].value().action ().setState (state);

    // erase_button
    mOptions[AnnotateOptions::EraseButton].setName ("erase_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Alt>Button3");
    mOptions[AnnotateOptions::EraseButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::EraseButton].value ().action ());

    // clear_button
    mOptions[AnnotateOptions::ClearButton].setName ("clear_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[AnnotateOptions::ClearButton].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::ClearButton].value ().action ());

    // clear_key
    mOptions[AnnotateOptions::ClearKey].setName ("clear_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Alt>k");
    mOptions[AnnotateOptions::ClearKey].value().set (action);
    if (screen) screen->addAction (&mOptions[AnnotateOptions::ClearKey].value ().action ());

    // draw_shapes_from_center
    mOptions[AnnotateOptions::DrawShapesFromCenter].setName ("draw_shapes_from_center", CompOption::TypeBool);
    mOptions[AnnotateOptions::DrawShapesFromCenter].value().set(true);

    // fill_color
    mOptions[AnnotateOptions::FillColor].setName ("fill_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = 0;
    color[2] = 0;
    color[3] = MAX (0, MIN (0xffff, 0x8888));
    mOptions[AnnotateOptions::FillColor].value().set(color);

    // stroke_color
    mOptions[AnnotateOptions::StrokeColor].setName ("stroke_color", CompOption::TypeColor);
    color[0] = 0;
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = 0;
    color[3] = 0xffff;
    mOptions[AnnotateOptions::StrokeColor].value().set(color);

    // erase_width
    mOptions[AnnotateOptions::EraseWidth].setName ("erase_width", CompOption::TypeFloat);
    mOptions[AnnotateOptions::EraseWidth].rest ().set (1.0, 100.0, 0.1);
    mOptions[AnnotateOptions::EraseWidth].value().set((float) 20.0);

    // stroke_width
    mOptions[AnnotateOptions::StrokeWidth].setName ("stroke_width", CompOption::TypeFloat);
    mOptions[AnnotateOptions::StrokeWidth].rest ().set (1.0, 100.0, 0.1);
    mOptions[AnnotateOptions::StrokeWidth].value().set((float) 3.0);

}

AnnotateOptions::~AnnotateOptions ()
{
}


CompOption::Vector &
AnnotateOptions::getOptions ()
{
    return mOptions;
}

bool
AnnotateOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case AnnotateOptions::InitiateFreeDrawButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::InitiateFreeDrawButton].empty ())
                    mNotify[AnnotateOptions::InitiateFreeDrawButton] (o, AnnotateOptions::InitiateFreeDrawButton);
                return true;
            }
            break;
        case AnnotateOptions::InitiateLineButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::InitiateLineButton].empty ())
                    mNotify[AnnotateOptions::InitiateLineButton] (o, AnnotateOptions::InitiateLineButton);
                return true;
            }
            break;
        case AnnotateOptions::InitiateRectangleButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::InitiateRectangleButton].empty ())
                    mNotify[AnnotateOptions::InitiateRectangleButton] (o, AnnotateOptions::InitiateRectangleButton);
                return true;
            }
            break;
        case AnnotateOptions::InitiateEllipseButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::InitiateEllipseButton].empty ())
                    mNotify[AnnotateOptions::InitiateEllipseButton] (o, AnnotateOptions::InitiateEllipseButton);
                return true;
            }
            break;
        case AnnotateOptions::Draw:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::Draw].empty ())
                    mNotify[AnnotateOptions::Draw] (o, AnnotateOptions::Draw);
                return true;
            }
            break;
        case AnnotateOptions::EraseButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::EraseButton].empty ())
                    mNotify[AnnotateOptions::EraseButton] (o, AnnotateOptions::EraseButton);
                return true;
            }
            break;
        case AnnotateOptions::ClearButton:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::ClearButton].empty ())
                    mNotify[AnnotateOptions::ClearButton] (o, AnnotateOptions::ClearButton);
                return true;
            }
            break;
        case AnnotateOptions::ClearKey:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::ClearKey].empty ())
                    mNotify[AnnotateOptions::ClearKey] (o, AnnotateOptions::ClearKey);
                return true;
            }
            break;
        case AnnotateOptions::DrawShapesFromCenter:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::DrawShapesFromCenter].empty ())
                    mNotify[AnnotateOptions::DrawShapesFromCenter] (o, AnnotateOptions::DrawShapesFromCenter);
                return true;
            }
            break;
        case AnnotateOptions::FillColor:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::FillColor].empty ())
                    mNotify[AnnotateOptions::FillColor] (o, AnnotateOptions::FillColor);
                return true;
            }
            break;
        case AnnotateOptions::StrokeColor:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::StrokeColor].empty ())
                    mNotify[AnnotateOptions::StrokeColor] (o, AnnotateOptions::StrokeColor);
                return true;
            }
            break;
        case AnnotateOptions::EraseWidth:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::EraseWidth].empty ())
                    mNotify[AnnotateOptions::EraseWidth] (o, AnnotateOptions::EraseWidth);
                return true;
            }
            break;
        case AnnotateOptions::StrokeWidth:
            if (o->set (value))
            {
                if (!mNotify[AnnotateOptions::StrokeWidth].empty ())
                    mNotify[AnnotateOptions::StrokeWidth] (o, AnnotateOptions::StrokeWidth);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

