/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "blur_options.h"

BlurOptions::BlurOptions (bool init /* = true */) :
    mOptions (BlurOptions::OptionNum),
    mNotify (BlurOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
BlurOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // pulse
    mOptions[BlurOptions::Pulse].setName ("pulse", CompOption::TypeBell);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitBell);
    mOptions[BlurOptions::Pulse].value().set (action);
    if (screen) screen->addAction (&mOptions[BlurOptions::Pulse].value ().action ());

    // blur_speed
    mOptions[BlurOptions::BlurSpeed].setName ("blur_speed", CompOption::TypeFloat);
    mOptions[BlurOptions::BlurSpeed].rest ().set (0.1, 10.0, 0.1);
    mOptions[BlurOptions::BlurSpeed].value().set((float) 3.5);

    // focus_blur_match
    mOptions[BlurOptions::FocusBlurMatch].setName ("focus_blur_match", CompOption::TypeMatch);
    mOptions[BlurOptions::FocusBlurMatch].value().set(CompMatch ("toolbar | menu | utility | normal | dialog | modaldialog"));
    mOptions[BlurOptions::FocusBlurMatch].value().match ().update ();

    // focus_blur
    mOptions[BlurOptions::FocusBlur].setName ("focus_blur", CompOption::TypeBool);
    mOptions[BlurOptions::FocusBlur].value().set(false);

    // alpha_blur_match
    mOptions[BlurOptions::AlphaBlurMatch].setName ("alpha_blur_match", CompOption::TypeMatch);
    mOptions[BlurOptions::AlphaBlurMatch].value().set(CompMatch (""));
    mOptions[BlurOptions::AlphaBlurMatch].value().match ().update ();

    // alpha_blur
    mOptions[BlurOptions::AlphaBlur].setName ("alpha_blur", CompOption::TypeBool);
    mOptions[BlurOptions::AlphaBlur].value().set(true);

    // filter
    mOptions[BlurOptions::Filter].setName ("filter", CompOption::TypeInt);
    mOptions[BlurOptions::Filter].rest ().set (0, 2);
    mOptions[BlurOptions::Filter].value().set((int) 0);

    // gaussian_radius
    mOptions[BlurOptions::GaussianRadius].setName ("gaussian_radius", CompOption::TypeInt);
    mOptions[BlurOptions::GaussianRadius].rest ().set (1, 15);
    mOptions[BlurOptions::GaussianRadius].value().set((int) 3);

    // gaussian_strength
    mOptions[BlurOptions::GaussianStrength].setName ("gaussian_strength", CompOption::TypeFloat);
    mOptions[BlurOptions::GaussianStrength].rest ().set (0.0, 1.0, 0.1);
    mOptions[BlurOptions::GaussianStrength].value().set((float) 1.0);

    // mipmap_lod
    mOptions[BlurOptions::MipmapLod].setName ("mipmap_lod", CompOption::TypeFloat);
    mOptions[BlurOptions::MipmapLod].rest ().set (0.1, 5.0, 0.1);
    mOptions[BlurOptions::MipmapLod].value().set((float) 2.5);

    // saturation
    mOptions[BlurOptions::Saturation].setName ("saturation", CompOption::TypeInt);
    mOptions[BlurOptions::Saturation].rest ().set (0, 100);
    mOptions[BlurOptions::Saturation].value().set((int) 100);

    // occlusion
    mOptions[BlurOptions::Occlusion].setName ("occlusion", CompOption::TypeBool);
    mOptions[BlurOptions::Occlusion].value().set(true);

    // independent_tex
    mOptions[BlurOptions::IndependentTex].setName ("independent_tex", CompOption::TypeBool);
    mOptions[BlurOptions::IndependentTex].value().set(false);

}

BlurOptions::~BlurOptions ()
{
}


CompOption::Vector &
BlurOptions::getOptions ()
{
    return mOptions;
}

bool
BlurOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case BlurOptions::Pulse:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::Pulse].empty ())
                    mNotify[BlurOptions::Pulse] (o, BlurOptions::Pulse);
                return true;
            }
            break;
        case BlurOptions::BlurSpeed:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::BlurSpeed].empty ())
                    mNotify[BlurOptions::BlurSpeed] (o, BlurOptions::BlurSpeed);
                return true;
            }
            break;
        case BlurOptions::FocusBlurMatch:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::FocusBlurMatch].empty ())
                    mNotify[BlurOptions::FocusBlurMatch] (o, BlurOptions::FocusBlurMatch);
                return true;
            }
            break;
        case BlurOptions::FocusBlur:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::FocusBlur].empty ())
                    mNotify[BlurOptions::FocusBlur] (o, BlurOptions::FocusBlur);
                return true;
            }
            break;
        case BlurOptions::AlphaBlurMatch:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::AlphaBlurMatch].empty ())
                    mNotify[BlurOptions::AlphaBlurMatch] (o, BlurOptions::AlphaBlurMatch);
                return true;
            }
            break;
        case BlurOptions::AlphaBlur:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::AlphaBlur].empty ())
                    mNotify[BlurOptions::AlphaBlur] (o, BlurOptions::AlphaBlur);
                return true;
            }
            break;
        case BlurOptions::Filter:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::Filter].empty ())
                    mNotify[BlurOptions::Filter] (o, BlurOptions::Filter);
                return true;
            }
            break;
        case BlurOptions::GaussianRadius:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::GaussianRadius].empty ())
                    mNotify[BlurOptions::GaussianRadius] (o, BlurOptions::GaussianRadius);
                return true;
            }
            break;
        case BlurOptions::GaussianStrength:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::GaussianStrength].empty ())
                    mNotify[BlurOptions::GaussianStrength] (o, BlurOptions::GaussianStrength);
                return true;
            }
            break;
        case BlurOptions::MipmapLod:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::MipmapLod].empty ())
                    mNotify[BlurOptions::MipmapLod] (o, BlurOptions::MipmapLod);
                return true;
            }
            break;
        case BlurOptions::Saturation:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::Saturation].empty ())
                    mNotify[BlurOptions::Saturation] (o, BlurOptions::Saturation);
                return true;
            }
            break;
        case BlurOptions::Occlusion:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::Occlusion].empty ())
                    mNotify[BlurOptions::Occlusion] (o, BlurOptions::Occlusion);
                return true;
            }
            break;
        case BlurOptions::IndependentTex:
            if (o->set (value))
            {
                if (!mNotify[BlurOptions::IndependentTex].empty ())
                    mNotify[BlurOptions::IndependentTex] (o, BlurOptions::IndependentTex);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

