/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "cube_options.h"

CubeOptions::CubeOptions (bool init /* = true */) :
    mOptions (CubeOptions::OptionNum),
    mNotify (CubeOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
CubeOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // unfold_key
    mOptions[CubeOptions::UnfoldKey].setName ("unfold_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Down");
    mOptions[CubeOptions::UnfoldKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CubeOptions::UnfoldKey].value ().action ());

    // mipmap
    mOptions[CubeOptions::Mipmap].setName ("mipmap", CompOption::TypeBool);
    mOptions[CubeOptions::Mipmap].value().set(true);

    // multioutput_mode
    mOptions[CubeOptions::MultioutputMode].setName ("multioutput_mode", CompOption::TypeInt);
    mOptions[CubeOptions::MultioutputMode].rest ().set (0, 2);
    mOptions[CubeOptions::MultioutputMode].value().set((int) 0);

    // in
    mOptions[CubeOptions::In].setName ("in", CompOption::TypeBool);
    mOptions[CubeOptions::In].value().set(false);

    // acceleration
    mOptions[CubeOptions::Acceleration].setName ("acceleration", CompOption::TypeFloat);
    mOptions[CubeOptions::Acceleration].rest ().set (1.0, 20.0, 0.1);
    mOptions[CubeOptions::Acceleration].value().set((float) 4.0);

    // speed
    mOptions[CubeOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[CubeOptions::Speed].rest ().set (0.1, 50.0, 0.1);
    mOptions[CubeOptions::Speed].value().set((float) 1.5);

    // timestep
    mOptions[CubeOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[CubeOptions::Timestep].rest ().set (0.1, 50.0, 0.1);
    mOptions[CubeOptions::Timestep].value().set((float) 1.2);

    // top_color
    mOptions[CubeOptions::TopColor].setName ("top_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = 0xffff;
    mOptions[CubeOptions::TopColor].value().set(color);

    // bottom_color
    mOptions[CubeOptions::BottomColor].setName ("bottom_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = 0xffff;
    mOptions[CubeOptions::BottomColor].value().set(color);

    // skydome
    mOptions[CubeOptions::Skydome].setName ("skydome", CompOption::TypeBool);
    mOptions[CubeOptions::Skydome].value().set(false);

    // skydome_image
    mOptions[CubeOptions::SkydomeImage].setName ("skydome_image", CompOption::TypeString);

    // skydome_animated
    mOptions[CubeOptions::SkydomeAnimated].setName ("skydome_animated", CompOption::TypeBool);
    mOptions[CubeOptions::SkydomeAnimated].value().set(false);

    // skydome_gradient_start_color
    mOptions[CubeOptions::SkydomeGradientStartColor].setName ("skydome_gradient_start_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0d0d));
    color[1] = MAX (0, MIN (0xffff, 0xb1b1));
    color[2] = MAX (0, MIN (0xffff, 0xfdfd));
    color[3] = 0xffff;
    mOptions[CubeOptions::SkydomeGradientStartColor].value().set(color);

    // skydome_gradient_end_color
    mOptions[CubeOptions::SkydomeGradientEndColor].setName ("skydome_gradient_end_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfefe));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xc7c7));
    color[3] = 0xffff;
    mOptions[CubeOptions::SkydomeGradientEndColor].value().set(color);

    // active_opacity
    mOptions[CubeOptions::ActiveOpacity].setName ("active_opacity", CompOption::TypeFloat);
    mOptions[CubeOptions::ActiveOpacity].rest ().set (0.0, 100.0, 1.0);
    mOptions[CubeOptions::ActiveOpacity].value().set((float) 100.0);

    // inactive_opacity
    mOptions[CubeOptions::InactiveOpacity].setName ("inactive_opacity", CompOption::TypeFloat);
    mOptions[CubeOptions::InactiveOpacity].rest ().set (0.0, 100.0, 1.0);
    mOptions[CubeOptions::InactiveOpacity].value().set((float) 100.0);

    // transparent_manual_only
    mOptions[CubeOptions::TransparentManualOnly].setName ("transparent_manual_only", CompOption::TypeBool);
    mOptions[CubeOptions::TransparentManualOnly].value().set(true);

}

CubeOptions::~CubeOptions ()
{
}


CompOption::Vector &
CubeOptions::getOptions ()
{
    return mOptions;
}

bool
CubeOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case CubeOptions::UnfoldKey:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::UnfoldKey].empty ())
                    mNotify[CubeOptions::UnfoldKey] (o, CubeOptions::UnfoldKey);
                return true;
            }
            break;
        case CubeOptions::Mipmap:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::Mipmap].empty ())
                    mNotify[CubeOptions::Mipmap] (o, CubeOptions::Mipmap);
                return true;
            }
            break;
        case CubeOptions::MultioutputMode:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::MultioutputMode].empty ())
                    mNotify[CubeOptions::MultioutputMode] (o, CubeOptions::MultioutputMode);
                return true;
            }
            break;
        case CubeOptions::In:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::In].empty ())
                    mNotify[CubeOptions::In] (o, CubeOptions::In);
                return true;
            }
            break;
        case CubeOptions::Acceleration:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::Acceleration].empty ())
                    mNotify[CubeOptions::Acceleration] (o, CubeOptions::Acceleration);
                return true;
            }
            break;
        case CubeOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::Speed].empty ())
                    mNotify[CubeOptions::Speed] (o, CubeOptions::Speed);
                return true;
            }
            break;
        case CubeOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::Timestep].empty ())
                    mNotify[CubeOptions::Timestep] (o, CubeOptions::Timestep);
                return true;
            }
            break;
        case CubeOptions::TopColor:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::TopColor].empty ())
                    mNotify[CubeOptions::TopColor] (o, CubeOptions::TopColor);
                return true;
            }
            break;
        case CubeOptions::BottomColor:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::BottomColor].empty ())
                    mNotify[CubeOptions::BottomColor] (o, CubeOptions::BottomColor);
                return true;
            }
            break;
        case CubeOptions::Skydome:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::Skydome].empty ())
                    mNotify[CubeOptions::Skydome] (o, CubeOptions::Skydome);
                return true;
            }
            break;
        case CubeOptions::SkydomeImage:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::SkydomeImage].empty ())
                    mNotify[CubeOptions::SkydomeImage] (o, CubeOptions::SkydomeImage);
                return true;
            }
            break;
        case CubeOptions::SkydomeAnimated:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::SkydomeAnimated].empty ())
                    mNotify[CubeOptions::SkydomeAnimated] (o, CubeOptions::SkydomeAnimated);
                return true;
            }
            break;
        case CubeOptions::SkydomeGradientStartColor:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::SkydomeGradientStartColor].empty ())
                    mNotify[CubeOptions::SkydomeGradientStartColor] (o, CubeOptions::SkydomeGradientStartColor);
                return true;
            }
            break;
        case CubeOptions::SkydomeGradientEndColor:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::SkydomeGradientEndColor].empty ())
                    mNotify[CubeOptions::SkydomeGradientEndColor] (o, CubeOptions::SkydomeGradientEndColor);
                return true;
            }
            break;
        case CubeOptions::ActiveOpacity:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::ActiveOpacity].empty ())
                    mNotify[CubeOptions::ActiveOpacity] (o, CubeOptions::ActiveOpacity);
                return true;
            }
            break;
        case CubeOptions::InactiveOpacity:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::InactiveOpacity].empty ())
                    mNotify[CubeOptions::InactiveOpacity] (o, CubeOptions::InactiveOpacity);
                return true;
            }
            break;
        case CubeOptions::TransparentManualOnly:
            if (o->set (value))
            {
                if (!mNotify[CubeOptions::TransparentManualOnly].empty ())
                    mNotify[CubeOptions::TransparentManualOnly] (o, CubeOptions::TransparentManualOnly);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

