/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "decor_options.h"

DecorOptions::DecorOptions (bool init /* = true */) :
    mOptions (DecorOptions::OptionNum),
    mNotify (DecorOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
DecorOptions::initOptions ()
{
    unsigned short color[4];

    // active_shadow_radius
    mOptions[DecorOptions::ActiveShadowRadius].setName ("active_shadow_radius", CompOption::TypeFloat);
    mOptions[DecorOptions::ActiveShadowRadius].rest ().set (0.1, 18.0, 0.1);
    mOptions[DecorOptions::ActiveShadowRadius].value().set((float) 8.0);

    // active_shadow_opacity
    mOptions[DecorOptions::ActiveShadowOpacity].setName ("active_shadow_opacity", CompOption::TypeFloat);
    mOptions[DecorOptions::ActiveShadowOpacity].rest ().set (0.01, 6.0, 0.01);
    mOptions[DecorOptions::ActiveShadowOpacity].value().set((float) 0.5);

    // active_shadow_color
    mOptions[DecorOptions::ActiveShadowColor].setName ("active_shadow_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x8000));
    mOptions[DecorOptions::ActiveShadowColor].value().set(color);

    // active_shadow_x_offset
    mOptions[DecorOptions::ActiveShadowXOffset].setName ("active_shadow_x_offset", CompOption::TypeInt);
    mOptions[DecorOptions::ActiveShadowXOffset].rest ().set (-16, 16);
    mOptions[DecorOptions::ActiveShadowXOffset].value().set((int) 1);

    // active_shadow_y_offset
    mOptions[DecorOptions::ActiveShadowYOffset].setName ("active_shadow_y_offset", CompOption::TypeInt);
    mOptions[DecorOptions::ActiveShadowYOffset].rest ().set (-16, 16);
    mOptions[DecorOptions::ActiveShadowYOffset].value().set((int) 1);

    // inactive_shadow_radius
    mOptions[DecorOptions::InactiveShadowRadius].setName ("inactive_shadow_radius", CompOption::TypeFloat);
    mOptions[DecorOptions::InactiveShadowRadius].rest ().set (0.1, 13.0, 0.1);
    mOptions[DecorOptions::InactiveShadowRadius].value().set((float) 8.0);

    // inactive_shadow_opacity
    mOptions[DecorOptions::InactiveShadowOpacity].setName ("inactive_shadow_opacity", CompOption::TypeFloat);
    mOptions[DecorOptions::InactiveShadowOpacity].rest ().set (0.01, 6.0, 0.01);
    mOptions[DecorOptions::InactiveShadowOpacity].value().set((float) 0.5);

    // inactive_shadow_color
    mOptions[DecorOptions::InactiveShadowColor].setName ("inactive_shadow_color", CompOption::TypeColor);

    // inactive_shadow_x_offset
    mOptions[DecorOptions::InactiveShadowXOffset].setName ("inactive_shadow_x_offset", CompOption::TypeInt);
    mOptions[DecorOptions::InactiveShadowXOffset].rest ().set (-16, 16);
    mOptions[DecorOptions::InactiveShadowXOffset].value().set((int) 1);

    // inactive_shadow_y_offset
    mOptions[DecorOptions::InactiveShadowYOffset].setName ("inactive_shadow_y_offset", CompOption::TypeInt);
    mOptions[DecorOptions::InactiveShadowYOffset].rest ().set (-16, 16);
    mOptions[DecorOptions::InactiveShadowYOffset].value().set((int) 1);

    // command
    mOptions[DecorOptions::Command].setName ("command", CompOption::TypeString);
    mOptions[DecorOptions::Command].value().set(CompString ("exec /usr/bin/compiz-decorator"));

    // mipmap
    mOptions[DecorOptions::Mipmap].setName ("mipmap", CompOption::TypeBool);
    mOptions[DecorOptions::Mipmap].value().set(false);

    // decoration_match
    mOptions[DecorOptions::DecorationMatch].setName ("decoration_match", CompOption::TypeMatch);
    mOptions[DecorOptions::DecorationMatch].value().set(CompMatch ("any"));
    mOptions[DecorOptions::DecorationMatch].value().match ().update ();

    // shadow_match
    mOptions[DecorOptions::ShadowMatch].setName ("shadow_match", CompOption::TypeMatch);
    mOptions[DecorOptions::ShadowMatch].value().set(CompMatch ("any"));
    mOptions[DecorOptions::ShadowMatch].value().match ().update ();

}

DecorOptions::~DecorOptions ()
{
}


CompOption::Vector &
DecorOptions::getOptions ()
{
    return mOptions;
}

bool
DecorOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case DecorOptions::ActiveShadowRadius:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ActiveShadowRadius].empty ())
                    mNotify[DecorOptions::ActiveShadowRadius] (o, DecorOptions::ActiveShadowRadius);
                return true;
            }
            break;
        case DecorOptions::ActiveShadowOpacity:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ActiveShadowOpacity].empty ())
                    mNotify[DecorOptions::ActiveShadowOpacity] (o, DecorOptions::ActiveShadowOpacity);
                return true;
            }
            break;
        case DecorOptions::ActiveShadowColor:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ActiveShadowColor].empty ())
                    mNotify[DecorOptions::ActiveShadowColor] (o, DecorOptions::ActiveShadowColor);
                return true;
            }
            break;
        case DecorOptions::ActiveShadowXOffset:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ActiveShadowXOffset].empty ())
                    mNotify[DecorOptions::ActiveShadowXOffset] (o, DecorOptions::ActiveShadowXOffset);
                return true;
            }
            break;
        case DecorOptions::ActiveShadowYOffset:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ActiveShadowYOffset].empty ())
                    mNotify[DecorOptions::ActiveShadowYOffset] (o, DecorOptions::ActiveShadowYOffset);
                return true;
            }
            break;
        case DecorOptions::InactiveShadowRadius:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::InactiveShadowRadius].empty ())
                    mNotify[DecorOptions::InactiveShadowRadius] (o, DecorOptions::InactiveShadowRadius);
                return true;
            }
            break;
        case DecorOptions::InactiveShadowOpacity:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::InactiveShadowOpacity].empty ())
                    mNotify[DecorOptions::InactiveShadowOpacity] (o, DecorOptions::InactiveShadowOpacity);
                return true;
            }
            break;
        case DecorOptions::InactiveShadowColor:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::InactiveShadowColor].empty ())
                    mNotify[DecorOptions::InactiveShadowColor] (o, DecorOptions::InactiveShadowColor);
                return true;
            }
            break;
        case DecorOptions::InactiveShadowXOffset:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::InactiveShadowXOffset].empty ())
                    mNotify[DecorOptions::InactiveShadowXOffset] (o, DecorOptions::InactiveShadowXOffset);
                return true;
            }
            break;
        case DecorOptions::InactiveShadowYOffset:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::InactiveShadowYOffset].empty ())
                    mNotify[DecorOptions::InactiveShadowYOffset] (o, DecorOptions::InactiveShadowYOffset);
                return true;
            }
            break;
        case DecorOptions::Command:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::Command].empty ())
                    mNotify[DecorOptions::Command] (o, DecorOptions::Command);
                return true;
            }
            break;
        case DecorOptions::Mipmap:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::Mipmap].empty ())
                    mNotify[DecorOptions::Mipmap] (o, DecorOptions::Mipmap);
                return true;
            }
            break;
        case DecorOptions::DecorationMatch:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::DecorationMatch].empty ())
                    mNotify[DecorOptions::DecorationMatch] (o, DecorOptions::DecorationMatch);
                return true;
            }
            break;
        case DecorOptions::ShadowMatch:
            if (o->set (value))
            {
                if (!mNotify[DecorOptions::ShadowMatch].empty ())
                    mNotify[DecorOptions::ShadowMatch] (o, DecorOptions::ShadowMatch);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

