/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "opengl_options.h"

OpenglOptions::OpenglOptions (bool init /* = true */) :
    mOptions (OpenglOptions::OptionNum),
    mNotify (OpenglOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
OpenglOptions::initOptions ()
{
    CompOption::Value::Vector list;
    CompOption::Value value;

    // texture_filter
    mOptions[OpenglOptions::TextureFilter].setName ("texture_filter", CompOption::TypeInt);
    mOptions[OpenglOptions::TextureFilter].rest ().set (0, 2);
    mOptions[OpenglOptions::TextureFilter].value().set((int) 1);

    // lighting
    mOptions[OpenglOptions::Lighting].setName ("lighting", CompOption::TypeBool);
    mOptions[OpenglOptions::Lighting].value().set(false);

    // sync_to_vblank
    mOptions[OpenglOptions::SyncToVblank].setName ("sync_to_vblank", CompOption::TypeBool);
    mOptions[OpenglOptions::SyncToVblank].value().set(true);

    // texture_compression
    mOptions[OpenglOptions::TextureCompression].setName ("texture_compression", CompOption::TypeBool);
    mOptions[OpenglOptions::TextureCompression].value().set(false);

    // framebuffer_object
    mOptions[OpenglOptions::FramebufferObject].setName ("framebuffer_object", CompOption::TypeBool);
    mOptions[OpenglOptions::FramebufferObject].value().set(true);

    // vertex_buffer_object
    mOptions[OpenglOptions::VertexBufferObject].setName ("vertex_buffer_object", CompOption::TypeBool);
    mOptions[OpenglOptions::VertexBufferObject].value().set(true);

    // always_swap_buffers
    mOptions[OpenglOptions::AlwaysSwapBuffers].setName ("always_swap_buffers", CompOption::TypeBool);
    mOptions[OpenglOptions::AlwaysSwapBuffers].value().set(true);

    // unredirect_driver_blacklist
    mOptions[OpenglOptions::UnredirectDriverBlacklist].setName ("unredirect_driver_blacklist", CompOption::TypeString);
    mOptions[OpenglOptions::UnredirectDriverBlacklist].value().set(CompString ("(nouveau|Intel).*Mesa 8.0"));

    // enable_x11_sync
    mOptions[OpenglOptions::EnableX11Sync].setName ("enable_x11_sync", CompOption::TypeBool);
    mOptions[OpenglOptions::EnableX11Sync].value().set(true);

    // x11_sync_blacklist_vendor
    mOptions[OpenglOptions::X11SyncBlacklistVendor].setName ("x11_sync_blacklist_vendor", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("NVIDIA"));
    list.push_back (value);
    value.set(CompString ("NVIDIA"));
    list.push_back (value);
    mOptions[OpenglOptions::X11SyncBlacklistVendor].value().set (CompOption::TypeString, list);

    // x11_sync_blacklist_model
    mOptions[OpenglOptions::X11SyncBlacklistModel].setName ("x11_sync_blacklist_model", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("GeForce 6150(LE|SE)"));
    list.push_back (value);
    value.set(CompString ("GeForce (7025|7050 PV)"));
    list.push_back (value);
    mOptions[OpenglOptions::X11SyncBlacklistModel].value().set (CompOption::TypeString, list);

}

OpenglOptions::~OpenglOptions ()
{
}


CompOption::Vector &
OpenglOptions::getOptions ()
{
    return mOptions;
}

bool
OpenglOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case OpenglOptions::TextureFilter:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::TextureFilter].empty ())
                    mNotify[OpenglOptions::TextureFilter] (o, OpenglOptions::TextureFilter);
                return true;
            }
            break;
        case OpenglOptions::Lighting:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::Lighting].empty ())
                    mNotify[OpenglOptions::Lighting] (o, OpenglOptions::Lighting);
                return true;
            }
            break;
        case OpenglOptions::SyncToVblank:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::SyncToVblank].empty ())
                    mNotify[OpenglOptions::SyncToVblank] (o, OpenglOptions::SyncToVblank);
                return true;
            }
            break;
        case OpenglOptions::TextureCompression:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::TextureCompression].empty ())
                    mNotify[OpenglOptions::TextureCompression] (o, OpenglOptions::TextureCompression);
                return true;
            }
            break;
        case OpenglOptions::FramebufferObject:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::FramebufferObject].empty ())
                    mNotify[OpenglOptions::FramebufferObject] (o, OpenglOptions::FramebufferObject);
                return true;
            }
            break;
        case OpenglOptions::VertexBufferObject:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::VertexBufferObject].empty ())
                    mNotify[OpenglOptions::VertexBufferObject] (o, OpenglOptions::VertexBufferObject);
                return true;
            }
            break;
        case OpenglOptions::AlwaysSwapBuffers:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::AlwaysSwapBuffers].empty ())
                    mNotify[OpenglOptions::AlwaysSwapBuffers] (o, OpenglOptions::AlwaysSwapBuffers);
                return true;
            }
            break;
        case OpenglOptions::UnredirectDriverBlacklist:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::UnredirectDriverBlacklist].empty ())
                    mNotify[OpenglOptions::UnredirectDriverBlacklist] (o, OpenglOptions::UnredirectDriverBlacklist);
                return true;
            }
            break;
        case OpenglOptions::EnableX11Sync:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::EnableX11Sync].empty ())
                    mNotify[OpenglOptions::EnableX11Sync] (o, OpenglOptions::EnableX11Sync);
                return true;
            }
            break;
        case OpenglOptions::X11SyncBlacklistVendor:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::X11SyncBlacklistVendor].empty ())
                    mNotify[OpenglOptions::X11SyncBlacklistVendor] (o, OpenglOptions::X11SyncBlacklistVendor);
                return true;
            }
            break;
        case OpenglOptions::X11SyncBlacklistModel:
            if (o->set (value))
            {
                if (!mNotify[OpenglOptions::X11SyncBlacklistModel].empty ())
                    mNotify[OpenglOptions::X11SyncBlacklistModel] (o, OpenglOptions::X11SyncBlacklistModel);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

