/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "place_options.h"

PlaceOptions::PlaceOptions (bool init /* = true */) :
    mOptions (PlaceOptions::OptionNum),
    mNotify (PlaceOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
PlaceOptions::initOptions ()
{
    CompOption::Value::Vector list;
    CompOption::Value value;

    // workarounds
    mOptions[PlaceOptions::Workarounds].setName ("workarounds", CompOption::TypeBool);
    mOptions[PlaceOptions::Workarounds].value().set(true);

    // mode
    mOptions[PlaceOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[PlaceOptions::Mode].rest ().set (0, 5);
    mOptions[PlaceOptions::Mode].value().set((int) 2);

    // multioutput_mode
    mOptions[PlaceOptions::MultioutputMode].setName ("multioutput_mode", CompOption::TypeInt);
    mOptions[PlaceOptions::MultioutputMode].rest ().set (0, 3);
    mOptions[PlaceOptions::MultioutputMode].value().set((int) 0);

    // force_placement_match
    mOptions[PlaceOptions::ForcePlacementMatch].setName ("force_placement_match", CompOption::TypeMatch);
    mOptions[PlaceOptions::ForcePlacementMatch].value().set(CompMatch (""));
    mOptions[PlaceOptions::ForcePlacementMatch].value().match ().update ();

    // position_matches
    mOptions[PlaceOptions::PositionMatches].setName ("position_matches", CompOption::TypeList);
    value.set (CompOption::TypeMatch, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::PositionMatches].set (value);

    // position_x_values
    mOptions[PlaceOptions::PositionXValues].setName ("position_x_values", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::PositionXValues].set (value);
    mOptions[PlaceOptions::PositionXValues].rest ().set (MINSHORT, MAXSHORT);

    // position_y_values
    mOptions[PlaceOptions::PositionYValues].setName ("position_y_values", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::PositionYValues].set (value);
    mOptions[PlaceOptions::PositionYValues].rest ().set (MINSHORT, MAXSHORT);

    // position_constrain_workarea
    mOptions[PlaceOptions::PositionConstrainWorkarea].setName ("position_constrain_workarea", CompOption::TypeList);
    value.set (CompOption::TypeBool, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::PositionConstrainWorkarea].set (value);

    // mode_matches
    mOptions[PlaceOptions::ModeMatches].setName ("mode_matches", CompOption::TypeList);
    value.set (CompOption::TypeMatch, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::ModeMatches].set (value);

    // mode_modes
    mOptions[PlaceOptions::ModeModes].setName ("mode_modes", CompOption::TypeList);
    mOptions[PlaceOptions::ModeModes].rest ().set (0, 5);
    list.clear ();
    mOptions[PlaceOptions::ModeModes].value().set (CompOption::TypeInt, list);

    // viewport_matches
    mOptions[PlaceOptions::ViewportMatches].setName ("viewport_matches", CompOption::TypeList);
    value.set (CompOption::TypeMatch, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::ViewportMatches].set (value);

    // viewport_x_values
    mOptions[PlaceOptions::ViewportXValues].setName ("viewport_x_values", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::ViewportXValues].set (value);
    mOptions[PlaceOptions::ViewportXValues].rest ().set (1, 32);

    // viewport_y_values
    mOptions[PlaceOptions::ViewportYValues].setName ("viewport_y_values", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[PlaceOptions::ViewportYValues].set (value);
    mOptions[PlaceOptions::ViewportYValues].rest ().set (1, 32);

    mModeModesMask = 0;
    foreach (CompOption::Value &val, mOptions[PlaceOptions::ModeModes].value ().list ())
        mModeModesMask |= (1 << val.i ());

}

PlaceOptions::~PlaceOptions ()
{
}


CompOption::Vector &
PlaceOptions::getOptions ()
{
    return mOptions;
}

bool
PlaceOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case PlaceOptions::Workarounds:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::Workarounds].empty ())
                    mNotify[PlaceOptions::Workarounds] (o, PlaceOptions::Workarounds);
                return true;
            }
            break;
        case PlaceOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::Mode].empty ())
                    mNotify[PlaceOptions::Mode] (o, PlaceOptions::Mode);
                return true;
            }
            break;
        case PlaceOptions::MultioutputMode:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::MultioutputMode].empty ())
                    mNotify[PlaceOptions::MultioutputMode] (o, PlaceOptions::MultioutputMode);
                return true;
            }
            break;
        case PlaceOptions::ForcePlacementMatch:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::ForcePlacementMatch].empty ())
                    mNotify[PlaceOptions::ForcePlacementMatch] (o, PlaceOptions::ForcePlacementMatch);
                return true;
            }
            break;
        case PlaceOptions::PositionMatches:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::PositionMatches].empty ())
                    mNotify[PlaceOptions::PositionMatches] (o, PlaceOptions::PositionMatches);
                return true;
            }
            break;
        case PlaceOptions::PositionXValues:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::PositionXValues].empty ())
                    mNotify[PlaceOptions::PositionXValues] (o, PlaceOptions::PositionXValues);
                return true;
            }
            break;
        case PlaceOptions::PositionYValues:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::PositionYValues].empty ())
                    mNotify[PlaceOptions::PositionYValues] (o, PlaceOptions::PositionYValues);
                return true;
            }
            break;
        case PlaceOptions::PositionConstrainWorkarea:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::PositionConstrainWorkarea].empty ())
                    mNotify[PlaceOptions::PositionConstrainWorkarea] (o, PlaceOptions::PositionConstrainWorkarea);
                return true;
            }
            break;
        case PlaceOptions::ModeMatches:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::ModeMatches].empty ())
                    mNotify[PlaceOptions::ModeMatches] (o, PlaceOptions::ModeMatches);
                return true;
            }
            break;
        case PlaceOptions::ModeModes:
            if (o->set (value))
            {
                mModeModesMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mModeModesMask |= (1 << val.i ());
                if (!mNotify[PlaceOptions::ModeModes].empty ())
                    mNotify[PlaceOptions::ModeModes] (o, PlaceOptions::ModeModes);
                return true;
            }
            break;
        case PlaceOptions::ViewportMatches:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::ViewportMatches].empty ())
                    mNotify[PlaceOptions::ViewportMatches] (o, PlaceOptions::ViewportMatches);
                return true;
            }
            break;
        case PlaceOptions::ViewportXValues:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::ViewportXValues].empty ())
                    mNotify[PlaceOptions::ViewportXValues] (o, PlaceOptions::ViewportXValues);
                return true;
            }
            break;
        case PlaceOptions::ViewportYValues:
            if (o->set (value))
            {
                if (!mNotify[PlaceOptions::ViewportYValues].empty ())
                    mNotify[PlaceOptions::ViewportYValues] (o, PlaceOptions::ViewportYValues);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

