/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "scaleaddon_options.h"

ScaleaddonOptions::ScaleaddonOptions (bool init /* = true */) :
    mOptions (ScaleaddonOptions::OptionNum),
    mNotify (ScaleaddonOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ScaleaddonOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // close_key
    mOptions[ScaleaddonOptions::CloseKey].setName ("close_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleaddonOptions::CloseKey].value().set (action);

    // close_button
    mOptions[ScaleaddonOptions::CloseButton].setName ("close_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button2");
    mOptions[ScaleaddonOptions::CloseButton].value().set (action);

    // pull_key
    mOptions[ScaleaddonOptions::PullKey].setName ("pull_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleaddonOptions::PullKey].value().set (action);

    // pull_button
    mOptions[ScaleaddonOptions::PullButton].setName ("pull_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[ScaleaddonOptions::PullButton].value().set (action);

    // zoom_key
    mOptions[ScaleaddonOptions::ZoomKey].setName ("zoom_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[ScaleaddonOptions::ZoomKey].value().set (action);

    // zoom_button
    mOptions[ScaleaddonOptions::ZoomButton].setName ("zoom_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("Button3");
    mOptions[ScaleaddonOptions::ZoomButton].value().set (action);

    // window_title
    mOptions[ScaleaddonOptions::WindowTitle].setName ("window_title", CompOption::TypeInt);
    mOptions[ScaleaddonOptions::WindowTitle].rest ().set (0, 2);
    mOptions[ScaleaddonOptions::WindowTitle].value().set((int) 1);

    // title_bold
    mOptions[ScaleaddonOptions::TitleBold].setName ("title_bold", CompOption::TypeBool);
    mOptions[ScaleaddonOptions::TitleBold].value().set(false);

    // title_size
    mOptions[ScaleaddonOptions::TitleSize].setName ("title_size", CompOption::TypeInt);
    mOptions[ScaleaddonOptions::TitleSize].rest ().set (6, 48);
    mOptions[ScaleaddonOptions::TitleSize].value().set((int) 10);

    // border_size
    mOptions[ScaleaddonOptions::BorderSize].setName ("border_size", CompOption::TypeInt);
    mOptions[ScaleaddonOptions::BorderSize].rest ().set (1, 20);
    mOptions[ScaleaddonOptions::BorderSize].value().set((int) 3);

    // font_color
    mOptions[ScaleaddonOptions::FontColor].setName ("font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[ScaleaddonOptions::FontColor].value().set(color);

    // back_color
    mOptions[ScaleaddonOptions::BackColor].setName ("back_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[ScaleaddonOptions::BackColor].value().set(color);

    // window_highlight
    mOptions[ScaleaddonOptions::WindowHighlight].setName ("window_highlight", CompOption::TypeBool);
    mOptions[ScaleaddonOptions::WindowHighlight].value().set(false);

    // highlight_color
    mOptions[ScaleaddonOptions::HighlightColor].setName ("highlight_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0x9696));
    mOptions[ScaleaddonOptions::HighlightColor].value().set(color);

    // layout_mode
    mOptions[ScaleaddonOptions::LayoutMode].setName ("layout_mode", CompOption::TypeInt);
    mOptions[ScaleaddonOptions::LayoutMode].rest ().set (0, 1);
    mOptions[ScaleaddonOptions::LayoutMode].value().set((int) 0);

    // natural_precision
    mOptions[ScaleaddonOptions::NaturalPrecision].setName ("natural_precision", CompOption::TypeFloat);
    mOptions[ScaleaddonOptions::NaturalPrecision].rest ().set (1.0, 20.0, 0.1f);
    mOptions[ScaleaddonOptions::NaturalPrecision].value().set((float) 2.0);

    // constrain_pull_to_screen
    mOptions[ScaleaddonOptions::ConstrainPullToScreen].setName ("constrain_pull_to_screen", CompOption::TypeBool);
    mOptions[ScaleaddonOptions::ConstrainPullToScreen].value().set(true);

    // exit_after_pull
    mOptions[ScaleaddonOptions::ExitAfterPull].setName ("exit_after_pull", CompOption::TypeBool);
    mOptions[ScaleaddonOptions::ExitAfterPull].value().set(false);

}

ScaleaddonOptions::~ScaleaddonOptions ()
{
}


CompOption::Vector &
ScaleaddonOptions::getOptions ()
{
    return mOptions;
}

bool
ScaleaddonOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ScaleaddonOptions::CloseKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::CloseKey].empty ())
                    mNotify[ScaleaddonOptions::CloseKey] (o, ScaleaddonOptions::CloseKey);
                return true;
            }
            break;
        case ScaleaddonOptions::CloseButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::CloseButton].empty ())
                    mNotify[ScaleaddonOptions::CloseButton] (o, ScaleaddonOptions::CloseButton);
                return true;
            }
            break;
        case ScaleaddonOptions::PullKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::PullKey].empty ())
                    mNotify[ScaleaddonOptions::PullKey] (o, ScaleaddonOptions::PullKey);
                return true;
            }
            break;
        case ScaleaddonOptions::PullButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::PullButton].empty ())
                    mNotify[ScaleaddonOptions::PullButton] (o, ScaleaddonOptions::PullButton);
                return true;
            }
            break;
        case ScaleaddonOptions::ZoomKey:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::ZoomKey].empty ())
                    mNotify[ScaleaddonOptions::ZoomKey] (o, ScaleaddonOptions::ZoomKey);
                return true;
            }
            break;
        case ScaleaddonOptions::ZoomButton:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::ZoomButton].empty ())
                    mNotify[ScaleaddonOptions::ZoomButton] (o, ScaleaddonOptions::ZoomButton);
                return true;
            }
            break;
        case ScaleaddonOptions::WindowTitle:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::WindowTitle].empty ())
                    mNotify[ScaleaddonOptions::WindowTitle] (o, ScaleaddonOptions::WindowTitle);
                return true;
            }
            break;
        case ScaleaddonOptions::TitleBold:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::TitleBold].empty ())
                    mNotify[ScaleaddonOptions::TitleBold] (o, ScaleaddonOptions::TitleBold);
                return true;
            }
            break;
        case ScaleaddonOptions::TitleSize:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::TitleSize].empty ())
                    mNotify[ScaleaddonOptions::TitleSize] (o, ScaleaddonOptions::TitleSize);
                return true;
            }
            break;
        case ScaleaddonOptions::BorderSize:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::BorderSize].empty ())
                    mNotify[ScaleaddonOptions::BorderSize] (o, ScaleaddonOptions::BorderSize);
                return true;
            }
            break;
        case ScaleaddonOptions::FontColor:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::FontColor].empty ())
                    mNotify[ScaleaddonOptions::FontColor] (o, ScaleaddonOptions::FontColor);
                return true;
            }
            break;
        case ScaleaddonOptions::BackColor:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::BackColor].empty ())
                    mNotify[ScaleaddonOptions::BackColor] (o, ScaleaddonOptions::BackColor);
                return true;
            }
            break;
        case ScaleaddonOptions::WindowHighlight:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::WindowHighlight].empty ())
                    mNotify[ScaleaddonOptions::WindowHighlight] (o, ScaleaddonOptions::WindowHighlight);
                return true;
            }
            break;
        case ScaleaddonOptions::HighlightColor:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::HighlightColor].empty ())
                    mNotify[ScaleaddonOptions::HighlightColor] (o, ScaleaddonOptions::HighlightColor);
                return true;
            }
            break;
        case ScaleaddonOptions::LayoutMode:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::LayoutMode].empty ())
                    mNotify[ScaleaddonOptions::LayoutMode] (o, ScaleaddonOptions::LayoutMode);
                return true;
            }
            break;
        case ScaleaddonOptions::NaturalPrecision:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::NaturalPrecision].empty ())
                    mNotify[ScaleaddonOptions::NaturalPrecision] (o, ScaleaddonOptions::NaturalPrecision);
                return true;
            }
            break;
        case ScaleaddonOptions::ConstrainPullToScreen:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::ConstrainPullToScreen].empty ())
                    mNotify[ScaleaddonOptions::ConstrainPullToScreen] (o, ScaleaddonOptions::ConstrainPullToScreen);
                return true;
            }
            break;
        case ScaleaddonOptions::ExitAfterPull:
            if (o->set (value))
            {
                if (!mNotify[ScaleaddonOptions::ExitAfterPull].empty ())
                    mNotify[ScaleaddonOptions::ExitAfterPull] (o, ScaleaddonOptions::ExitAfterPull);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

