/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "showdesktop_options.h"

ShowdesktopOptions::ShowdesktopOptions (bool init /* = true */) :
    mOptions (ShowdesktopOptions::OptionNum),
    mNotify (ShowdesktopOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ShowdesktopOptions::initOptions ()
{

    // speed
    mOptions[ShowdesktopOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[ShowdesktopOptions::Speed].rest ().set (0.1, 50.0, 0.1);
    mOptions[ShowdesktopOptions::Speed].value().set((float) 1.2);

    // timestep
    mOptions[ShowdesktopOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[ShowdesktopOptions::Timestep].rest ().set (0.1, 50.0, 0.1);
    mOptions[ShowdesktopOptions::Timestep].value().set((float) 0.1);

    // direction
    mOptions[ShowdesktopOptions::Direction].setName ("direction", CompOption::TypeInt);
    mOptions[ShowdesktopOptions::Direction].rest ().set (0, 12);
    mOptions[ShowdesktopOptions::Direction].value().set((int) 10);

    // window_match
    mOptions[ShowdesktopOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[ShowdesktopOptions::WindowMatch].value().set(CompMatch ("type=toolbar | type=utility | type=dialog | type=normal"));
    mOptions[ShowdesktopOptions::WindowMatch].value().match ().update ();

    // skip_animation
    mOptions[ShowdesktopOptions::SkipAnimation].setName ("skip_animation", CompOption::TypeBool);
    mOptions[ShowdesktopOptions::SkipAnimation].value().set(false);

    // window_opacity
    mOptions[ShowdesktopOptions::WindowOpacity].setName ("window_opacity", CompOption::TypeFloat);
    mOptions[ShowdesktopOptions::WindowOpacity].rest ().set (0.1, 1.0, 0.01);
    mOptions[ShowdesktopOptions::WindowOpacity].value().set((float) 0.3);

    // window_part_size
    mOptions[ShowdesktopOptions::WindowPartSize].setName ("window_part_size", CompOption::TypeInt);
    mOptions[ShowdesktopOptions::WindowPartSize].rest ().set (0, 300);
    mOptions[ShowdesktopOptions::WindowPartSize].value().set((int) 20);

}

ShowdesktopOptions::~ShowdesktopOptions ()
{
}


CompOption::Vector &
ShowdesktopOptions::getOptions ()
{
    return mOptions;
}

bool
ShowdesktopOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ShowdesktopOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::Speed].empty ())
                    mNotify[ShowdesktopOptions::Speed] (o, ShowdesktopOptions::Speed);
                return true;
            }
            break;
        case ShowdesktopOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::Timestep].empty ())
                    mNotify[ShowdesktopOptions::Timestep] (o, ShowdesktopOptions::Timestep);
                return true;
            }
            break;
        case ShowdesktopOptions::Direction:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::Direction].empty ())
                    mNotify[ShowdesktopOptions::Direction] (o, ShowdesktopOptions::Direction);
                return true;
            }
            break;
        case ShowdesktopOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::WindowMatch].empty ())
                    mNotify[ShowdesktopOptions::WindowMatch] (o, ShowdesktopOptions::WindowMatch);
                return true;
            }
            break;
        case ShowdesktopOptions::SkipAnimation:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::SkipAnimation].empty ())
                    mNotify[ShowdesktopOptions::SkipAnimation] (o, ShowdesktopOptions::SkipAnimation);
                return true;
            }
            break;
        case ShowdesktopOptions::WindowOpacity:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::WindowOpacity].empty ())
                    mNotify[ShowdesktopOptions::WindowOpacity] (o, ShowdesktopOptions::WindowOpacity);
                return true;
            }
            break;
        case ShowdesktopOptions::WindowPartSize:
            if (o->set (value))
            {
                if (!mNotify[ShowdesktopOptions::WindowPartSize].empty ())
                    mNotify[ShowdesktopOptions::WindowPartSize] (o, ShowdesktopOptions::WindowPartSize);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

