/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "workspacenames_options.h"

WorkspacenamesOptions::WorkspacenamesOptions (bool init /* = true */) :
    mOptions (WorkspacenamesOptions::OptionNum),
    mNotify (WorkspacenamesOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WorkspacenamesOptions::initOptions ()
{
    unsigned short color[4];
    CompOption::Value::Vector list;
    CompOption::Value value;

    // viewports
    mOptions[WorkspacenamesOptions::Viewports].setName ("viewports", CompOption::TypeList);
    mOptions[WorkspacenamesOptions::Viewports].rest ().set (1, 50);
    list.clear ();
    value.set((int) 1);
    list.push_back (value);
    value.set((int) 2);
    list.push_back (value);
    value.set((int) 3);
    list.push_back (value);
    value.set((int) 4);
    list.push_back (value);
    mOptions[WorkspacenamesOptions::Viewports].value().set (CompOption::TypeInt, list);

    // names
    mOptions[WorkspacenamesOptions::Names].setName ("names", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("Viewport 1"));
    list.push_back (value);
    value.set(CompString ("Viewport 2"));
    list.push_back (value);
    value.set(CompString ("Viewport 3"));
    list.push_back (value);
    value.set(CompString ("Viewport 4"));
    list.push_back (value);
    mOptions[WorkspacenamesOptions::Names].value().set (CompOption::TypeString, list);

    // display_time
    mOptions[WorkspacenamesOptions::DisplayTime].setName ("display_time", CompOption::TypeFloat);
    mOptions[WorkspacenamesOptions::DisplayTime].rest ().set (0.1, 5.0, 0.05);
    mOptions[WorkspacenamesOptions::DisplayTime].value().set((float) 1.5);

    // fade_time
    mOptions[WorkspacenamesOptions::FadeTime].setName ("fade_time", CompOption::TypeFloat);
    mOptions[WorkspacenamesOptions::FadeTime].rest ().set (0.0, 5.0, 0.05);
    mOptions[WorkspacenamesOptions::FadeTime].value().set((float) 0.25);

    // bold_text
    mOptions[WorkspacenamesOptions::BoldText].setName ("bold_text", CompOption::TypeBool);
    mOptions[WorkspacenamesOptions::BoldText].value().set(true);

    // text_font_size
    mOptions[WorkspacenamesOptions::TextFontSize].setName ("text_font_size", CompOption::TypeInt);
    mOptions[WorkspacenamesOptions::TextFontSize].rest ().set (6, 96);
    mOptions[WorkspacenamesOptions::TextFontSize].value().set((int) 24);

    // text_placement
    mOptions[WorkspacenamesOptions::TextPlacement].setName ("text_placement", CompOption::TypeInt);
    mOptions[WorkspacenamesOptions::TextPlacement].rest ().set (0, 2);
    mOptions[WorkspacenamesOptions::TextPlacement].value().set((int) 0);

    // vertical_offset
    mOptions[WorkspacenamesOptions::VerticalOffset].setName ("vertical_offset", CompOption::TypeInt);
    mOptions[WorkspacenamesOptions::VerticalOffset].rest ().set (0, 500);
    mOptions[WorkspacenamesOptions::VerticalOffset].value().set((int) 50);

    // back_color
    mOptions[WorkspacenamesOptions::BackColor].setName ("back_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[WorkspacenamesOptions::BackColor].value().set(color);

    // font_color
    mOptions[WorkspacenamesOptions::FontColor].setName ("font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[WorkspacenamesOptions::FontColor].value().set(color);

}

WorkspacenamesOptions::~WorkspacenamesOptions ()
{
}


CompOption::Vector &
WorkspacenamesOptions::getOptions ()
{
    return mOptions;
}

bool
WorkspacenamesOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WorkspacenamesOptions::Viewports:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::Viewports].empty ())
                    mNotify[WorkspacenamesOptions::Viewports] (o, WorkspacenamesOptions::Viewports);
                return true;
            }
            break;
        case WorkspacenamesOptions::Names:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::Names].empty ())
                    mNotify[WorkspacenamesOptions::Names] (o, WorkspacenamesOptions::Names);
                return true;
            }
            break;
        case WorkspacenamesOptions::DisplayTime:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::DisplayTime].empty ())
                    mNotify[WorkspacenamesOptions::DisplayTime] (o, WorkspacenamesOptions::DisplayTime);
                return true;
            }
            break;
        case WorkspacenamesOptions::FadeTime:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::FadeTime].empty ())
                    mNotify[WorkspacenamesOptions::FadeTime] (o, WorkspacenamesOptions::FadeTime);
                return true;
            }
            break;
        case WorkspacenamesOptions::BoldText:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::BoldText].empty ())
                    mNotify[WorkspacenamesOptions::BoldText] (o, WorkspacenamesOptions::BoldText);
                return true;
            }
            break;
        case WorkspacenamesOptions::TextFontSize:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::TextFontSize].empty ())
                    mNotify[WorkspacenamesOptions::TextFontSize] (o, WorkspacenamesOptions::TextFontSize);
                return true;
            }
            break;
        case WorkspacenamesOptions::TextPlacement:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::TextPlacement].empty ())
                    mNotify[WorkspacenamesOptions::TextPlacement] (o, WorkspacenamesOptions::TextPlacement);
                return true;
            }
            break;
        case WorkspacenamesOptions::VerticalOffset:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::VerticalOffset].empty ())
                    mNotify[WorkspacenamesOptions::VerticalOffset] (o, WorkspacenamesOptions::VerticalOffset);
                return true;
            }
            break;
        case WorkspacenamesOptions::BackColor:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::BackColor].empty ())
                    mNotify[WorkspacenamesOptions::BackColor] (o, WorkspacenamesOptions::BackColor);
                return true;
            }
            break;
        case WorkspacenamesOptions::FontColor:
            if (o->set (value))
            {
                if (!mNotify[WorkspacenamesOptions::FontColor].empty ())
                    mNotify[WorkspacenamesOptions::FontColor] (o, WorkspacenamesOptions::FontColor);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

