/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "td_options.h"

TdOptions::TdOptions (bool init /* = true */) :
    mOptions (TdOptions::OptionNum),
    mNotify (TdOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
TdOptions::initOptions ()
{
    unsigned short color[4];

    // window_match
    mOptions[TdOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[TdOptions::WindowMatch].value().set(CompMatch ("Toolbar | Utility | Dialog | Normal | Unknown"));
    mOptions[TdOptions::WindowMatch].value().match ().update ();

    // min_cube_size
    mOptions[TdOptions::MinCubeSize].setName ("min_cube_size", CompOption::TypeInt);
    mOptions[TdOptions::MinCubeSize].rest ().set (10, 100);
    mOptions[TdOptions::MinCubeSize].value().set((int) 60);

    // max_window_space
    mOptions[TdOptions::MaxWindowSpace].setName ("max_window_space", CompOption::TypeInt);
    mOptions[TdOptions::MaxWindowSpace].rest ().set (0, 50);
    mOptions[TdOptions::MaxWindowSpace].value().set((int) 10);

    // manual_only
    mOptions[TdOptions::ManualOnly].setName ("manual_only", CompOption::TypeBool);
    mOptions[TdOptions::ManualOnly].value().set(true);

    // width
    mOptions[TdOptions::Width].setName ("width", CompOption::TypeFloat);
    mOptions[TdOptions::Width].rest ().set (0.0, 1.0, 0.001);
    mOptions[TdOptions::Width].value().set((float) 0.3);

    // bevel
    mOptions[TdOptions::Bevel].setName ("bevel", CompOption::TypeInt);
    mOptions[TdOptions::Bevel].rest ().set (0, 20);
    mOptions[TdOptions::Bevel].value().set((int) 0);

    // width_color
    mOptions[TdOptions::WidthColor].setName ("width_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3333));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x3333));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[TdOptions::WidthColor].value().set(color);

    // width_color_inactive
    mOptions[TdOptions::WidthColorInactive].setName ("width_color_inactive", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3333));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x3333));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[TdOptions::WidthColorInactive].value().set(color);

    // bevel_topleft
    mOptions[TdOptions::BevelTopleft].setName ("bevel_topleft", CompOption::TypeBool);
    mOptions[TdOptions::BevelTopleft].value().set(true);

    // bevel_topright
    mOptions[TdOptions::BevelTopright].setName ("bevel_topright", CompOption::TypeBool);
    mOptions[TdOptions::BevelTopright].value().set(true);

    // bevel_bottomleft
    mOptions[TdOptions::BevelBottomleft].setName ("bevel_bottomleft", CompOption::TypeBool);
    mOptions[TdOptions::BevelBottomleft].value().set(false);

    // bevel_bottomright
    mOptions[TdOptions::BevelBottomright].setName ("bevel_bottomright", CompOption::TypeBool);
    mOptions[TdOptions::BevelBottomright].value().set(false);

}

TdOptions::~TdOptions ()
{
}


CompOption::Vector &
TdOptions::getOptions ()
{
    return mOptions;
}

bool
TdOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case TdOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::WindowMatch].empty ())
                    mNotify[TdOptions::WindowMatch] (o, TdOptions::WindowMatch);
                return true;
            }
            break;
        case TdOptions::MinCubeSize:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::MinCubeSize].empty ())
                    mNotify[TdOptions::MinCubeSize] (o, TdOptions::MinCubeSize);
                return true;
            }
            break;
        case TdOptions::MaxWindowSpace:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::MaxWindowSpace].empty ())
                    mNotify[TdOptions::MaxWindowSpace] (o, TdOptions::MaxWindowSpace);
                return true;
            }
            break;
        case TdOptions::ManualOnly:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::ManualOnly].empty ())
                    mNotify[TdOptions::ManualOnly] (o, TdOptions::ManualOnly);
                return true;
            }
            break;
        case TdOptions::Width:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::Width].empty ())
                    mNotify[TdOptions::Width] (o, TdOptions::Width);
                return true;
            }
            break;
        case TdOptions::Bevel:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::Bevel].empty ())
                    mNotify[TdOptions::Bevel] (o, TdOptions::Bevel);
                return true;
            }
            break;
        case TdOptions::WidthColor:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::WidthColor].empty ())
                    mNotify[TdOptions::WidthColor] (o, TdOptions::WidthColor);
                return true;
            }
            break;
        case TdOptions::WidthColorInactive:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::WidthColorInactive].empty ())
                    mNotify[TdOptions::WidthColorInactive] (o, TdOptions::WidthColorInactive);
                return true;
            }
            break;
        case TdOptions::BevelTopleft:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::BevelTopleft].empty ())
                    mNotify[TdOptions::BevelTopleft] (o, TdOptions::BevelTopleft);
                return true;
            }
            break;
        case TdOptions::BevelTopright:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::BevelTopright].empty ())
                    mNotify[TdOptions::BevelTopright] (o, TdOptions::BevelTopright);
                return true;
            }
            break;
        case TdOptions::BevelBottomleft:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::BevelBottomleft].empty ())
                    mNotify[TdOptions::BevelBottomleft] (o, TdOptions::BevelBottomleft);
                return true;
            }
            break;
        case TdOptions::BevelBottomright:
            if (o->set (value))
            {
                if (!mNotify[TdOptions::BevelBottomright].empty ())
                    mNotify[TdOptions::BevelBottomright] (o, TdOptions::BevelBottomright);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

