/*
 * Decompiled with CFR 0.152.
 */
package de.congrace.exp4j;

import de.congrace.exp4j.Calculable;
import de.congrace.exp4j.CustomFunction;
import de.congrace.exp4j.CustomOperator;
import de.congrace.exp4j.InvalidCustomFunctionException;
import de.congrace.exp4j.RPNConverter;
import de.congrace.exp4j.UnknownFunctionException;
import de.congrace.exp4j.UnparsableExpressionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionBuilder {
    public static final String PROPERTY_UNARY_HIGH_PRECEDENCE = "exp4j.unary.precedence.high";
    private final Map<String, Double> variables = new LinkedHashMap<String, Double>();
    private final Map<String, CustomFunction> customFunctions;
    private final Map<String, CustomOperator> builtInOperators;
    private Map<String, CustomOperator> customOperators = new HashMap<String, CustomOperator>();
    private final List<Character> validOperatorSymbols;
    private final boolean highUnaryPrecedence;
    private String expression;

    public ExpressionBuilder(String expression) {
        if (expression.trim().length() == 0) {
            throw new IllegalArgumentException("Expression can not be empty!.");
        }
        this.expression = expression;
        this.highUnaryPrecedence = System.getProperty(PROPERTY_UNARY_HIGH_PRECEDENCE) == null || !System.getProperty(PROPERTY_UNARY_HIGH_PRECEDENCE).equals("false");
        this.customFunctions = this.getBuiltinFunctions();
        this.builtInOperators = this.getBuiltinOperators();
        this.validOperatorSymbols = this.getValidOperators();
    }

    private List<Character> getValidOperators() {
        return Arrays.asList(Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('\u00a7'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('~'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('='));
    }

    private Map<String, CustomOperator> getBuiltinOperators() {
        CustomOperator add = new CustomOperator("+"){

            @Override
            protected double applyOperation(double[] values) {
                return values[0] + values[1];
            }
        };
        CustomOperator sub = new CustomOperator("-"){

            @Override
            protected double applyOperation(double[] values) {
                return values[0] - values[1];
            }
        };
        CustomOperator div = new CustomOperator("/", 3){

            @Override
            protected double applyOperation(double[] values) {
                if (values[1] == 0.0) {
                    throw new ArithmeticException("Division by zero!");
                }
                return values[0] / values[1];
            }
        };
        CustomOperator mul = new CustomOperator("*", 3){

            @Override
            protected double applyOperation(double[] values) {
                return values[0] * values[1];
            }
        };
        CustomOperator mod = new CustomOperator("%", true, 3){

            @Override
            protected double applyOperation(double[] values) {
                if (values[1] == 0.0) {
                    throw new ArithmeticException("Division by zero!");
                }
                return values[0] % values[1];
            }
        };
        CustomOperator umin = new CustomOperator("'", false, this.highUnaryPrecedence ? 7 : 5, 1){

            @Override
            protected double applyOperation(double[] values) {
                return -values[0];
            }
        };
        CustomOperator pow = new CustomOperator("^", false, 5, 2){

            @Override
            protected double applyOperation(double[] values) {
                return Math.pow(values[0], values[1]);
            }
        };
        HashMap<String, CustomOperator> operations = new HashMap<String, CustomOperator>();
        operations.put("+", add);
        operations.put("-", sub);
        operations.put("*", mul);
        operations.put("/", div);
        operations.put("'", umin);
        operations.put("^", pow);
        operations.put("%", mod);
        return operations;
    }

    private Map<String, CustomFunction> getBuiltinFunctions() {
        try {
            CustomFunction abs = new CustomFunction("abs"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.abs(args[0]);
                }
            };
            CustomFunction acos = new CustomFunction("acos"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.acos(args[0]);
                }
            };
            CustomFunction asin = new CustomFunction("asin"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.asin(args[0]);
                }
            };
            CustomFunction atan = new CustomFunction("atan"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.atan(args[0]);
                }
            };
            CustomFunction cbrt = new CustomFunction("cbrt"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.cbrt(args[0]);
                }
            };
            CustomFunction ceil = new CustomFunction("ceil"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.ceil(args[0]);
                }
            };
            CustomFunction cos = new CustomFunction("cos"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.cos(args[0]);
                }
            };
            CustomFunction cosh = new CustomFunction("cosh"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.cosh(args[0]);
                }
            };
            CustomFunction exp = new CustomFunction("exp"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.exp(args[0]);
                }
            };
            CustomFunction expm1 = new CustomFunction("expm1"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.expm1(args[0]);
                }
            };
            CustomFunction floor = new CustomFunction("floor"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.floor(args[0]);
                }
            };
            CustomFunction log = new CustomFunction("log"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.log(args[0]);
                }
            };
            CustomFunction sine = new CustomFunction("sin"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.sin(args[0]);
                }
            };
            CustomFunction sinh = new CustomFunction("sinh"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.sinh(args[0]);
                }
            };
            CustomFunction sqrt = new CustomFunction("sqrt"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.sqrt(args[0]);
                }
            };
            CustomFunction tan = new CustomFunction("tan"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.tan(args[0]);
                }
            };
            CustomFunction tanh = new CustomFunction("tanh"){

                @Override
                public double applyFunction(double ... args) {
                    return Math.tanh(args[0]);
                }
            };
            HashMap<String, CustomFunction> customFunctions = new HashMap<String, CustomFunction>();
            customFunctions.put("abs", abs);
            customFunctions.put("acos", acos);
            customFunctions.put("asin", asin);
            customFunctions.put("atan", atan);
            customFunctions.put("cbrt", cbrt);
            customFunctions.put("ceil", ceil);
            customFunctions.put("cos", cos);
            customFunctions.put("cosh", cosh);
            customFunctions.put("exp", exp);
            customFunctions.put("expm1", expm1);
            customFunctions.put("floor", floor);
            customFunctions.put("log", log);
            customFunctions.put("sin", sine);
            customFunctions.put("sinh", sinh);
            customFunctions.put("sqrt", sqrt);
            customFunctions.put("tan", tan);
            customFunctions.put("tanh", tanh);
            return customFunctions;
        }
        catch (InvalidCustomFunctionException e) {
            throw new RuntimeException(e);
        }
    }

    public Calculable build() throws UnknownFunctionException, UnparsableExpressionException {
        for (CustomOperator op : this.customOperators.values()) {
            for (int i = 0; i < op.symbol.length(); ++i) {
                if (this.validOperatorSymbols.contains(Character.valueOf(op.symbol.charAt(i)))) continue;
                throw new UnparsableExpressionException("" + op.symbol + " is not a valid symbol for an operator please choose from: !,#,\u00a7,$,&,;,:,~,<,>,|,=");
            }
        }
        for (String varName : this.variables.keySet()) {
            this.checkVariableName(varName);
            if (!this.customFunctions.containsKey(varName)) continue;
            throw new UnparsableExpressionException("Variable '" + varName + "' cannot have the same name as a function");
        }
        this.builtInOperators.putAll(this.customOperators);
        return RPNConverter.toRPNExpression(this.expression, this.variables, this.customFunctions, this.builtInOperators);
    }

    private void checkVariableName(String varName) throws UnparsableExpressionException {
        char[] name = varName.toCharArray();
        for (int i = 0; i < name.length; ++i) {
            if (!(i == 0 ? !Character.isLetter(name[i]) && name[i] != '_' : !Character.isLetter(name[i]) && !Character.isDigit(name[i]) && name[i] != '_')) continue;
            throw new UnparsableExpressionException(varName + " is not a valid variable name: character '" + name[i] + " at " + i);
        }
    }

    public ExpressionBuilder withCustomFunction(CustomFunction function) {
        this.customFunctions.put(function.name, function);
        return this;
    }

    public ExpressionBuilder withCustomFunctions(Collection<CustomFunction> functions) {
        for (CustomFunction f : functions) {
            this.withCustomFunction(f);
        }
        return this;
    }

    public ExpressionBuilder withVariable(String variableName, double value) {
        this.variables.put(variableName, value);
        return this;
    }

    public ExpressionBuilder withVariableNames(String ... variableNames) {
        for (String variable : variableNames) {
            this.variables.put(variable, null);
        }
        return this;
    }

    public ExpressionBuilder withVariables(Map<String, Double> variableMap) {
        for (Map.Entry<String, Double> v : variableMap.entrySet()) {
            this.variables.put(v.getKey(), v.getValue());
        }
        return this;
    }

    public ExpressionBuilder withOperation(CustomOperator operation) {
        this.customOperators.put(operation.symbol, operation);
        return this;
    }

    public ExpressionBuilder withOperations(Collection<CustomOperator> operations) {
        for (CustomOperator op : operations) {
            this.withOperation(op);
        }
        return this;
    }

    public ExpressionBuilder withExpression(String expression) {
        this.expression = expression;
        return this;
    }
}

