/*
 * Decompiled with CFR 0.152.
 */
package blue.automation;

import blue.Arrangement;
import blue.BlueData;
import blue.InstrumentAssignment;
import blue.SoundLayer;
import blue.automation.Automatable;
import blue.automation.AutomatableCollectionListener;
import blue.automation.LineColors;
import blue.automation.Parameter;
import blue.automation.ParameterIdList;
import blue.automation.ParameterList;
import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Effect;
import blue.mixer.EffectsChain;
import blue.mixer.Mixer;
import blue.mixer.Send;
import blue.score.Score;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.soundObject.PolyObject;
import blue.ui.utilities.MenuScroller;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ListChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class AutomationManager
implements AutomatableCollectionListener,
ObservableListListener<Channel>,
LayerGroupListener {
    private ArrayList<Parameter> allParameters = new ArrayList();
    BlueData data = null;
    Score score = null;
    ActionListener parameterActionListener = ae -> {
        if (this.data == null || this.selectedParamIdList == null) {
            return;
        }
        JMenuItem menuItem = (JMenuItem)ae.getSource();
        Parameter param = (Parameter)menuItem.getClientProperty("param");
        this.parameterSelected(this.selectedParamIdList, param);
        this.selectedParamIdList = null;
    };
    private ParameterIdList selectedParamIdList = null;
    private static AutomationManager instance = null;
    PropertyChangeListener renderTimeListener = pce -> {
        if (pce.getSource() == this.data && pce.getPropertyName().equals("renderStartTime")) {
            this.updateValuesFromAutomations();
        }
    };
    ObservableListListener<ChannelList> channelListListener = e -> {
        List items = e.getAffectedItems();
        switch (e.getType()) {
            case 0: {
                for (ChannelList cList : items) {
                    cList.addListener((ObservableListListener)this);
                    for (Channel c : cList) {
                        this.addListenerToChannel(c);
                    }
                }
                break;
            }
            case 1: {
                for (ChannelList cList : items) {
                    cList.removeListener((ObservableListListener)this);
                    for (Channel c : cList) {
                        this.removeListenerFromChannel(c);
                    }
                }
                break;
            }
        }
    };
    ListChangeListener<Parameter> parameterListListener = e -> {
        while (e.next()) {
            for (Parameter param : e.getAddedSubList()) {
                this.parameterAdded(param);
            }
            for (Parameter param : e.getRemoved()) {
                this.parameterRemoved(param);
            }
        }
    };

    private AutomationManager() {
    }

    public static AutomationManager getInstance() {
        if (instance == null) {
            instance = new AutomationManager();
        }
        return instance;
    }

    private void parameterSelected(ParameterIdList paramIdList, Parameter param) {
        String uniqueId = param.getUniqueId();
        if (param.isAutomationEnabled()) {
            if (paramIdList.contains(uniqueId)) {
                param.setAutomationEnabled(false);
                paramIdList.removeParameterId(uniqueId);
            } else {
                Score score = this.data.getScore();
                for (LayerGroup layerGroup : score) {
                    if (!(layerGroup instanceof PolyObject)) continue;
                    PolyObject pObj = (PolyObject)layerGroup;
                    for (SoundLayer layer : pObj) {
                        ParameterIdList automationParameters;
                        if (layer.getAutomationParameters() == paramIdList || !(automationParameters = layer.getAutomationParameters()).contains(uniqueId)) continue;
                        automationParameters.removeParameterId(uniqueId);
                    }
                }
                paramIdList.addParameterId(uniqueId);
            }
        } else {
            param.setAutomationEnabled(true);
            param.getLine().setColor(LineColors.getColor((int)paramIdList.size()));
            paramIdList.addParameterId(uniqueId);
            param.fireUpdateFromTimeChange();
        }
    }

    public void setData(BlueData data) {
        ChannelList subChannels;
        ChannelList channels;
        Channel c;
        Automatable temp;
        Object instr;
        Arrangement arrangement;
        if (this.data != null) {
            Object parameters;
            arrangement = this.data.getArrangement();
            arrangement.removeAutomatableCollectionListener((AutomatableCollectionListener)this);
            for (int i = 0; i < arrangement.size(); ++i) {
                instr = arrangement.getInstrument(i);
                if (!(instr instanceof Automatable)) continue;
                temp = (Automatable)instr;
                parameters = temp.getParameterList();
                parameters.removeListener(this.parameterListListener);
            }
            Mixer mixer = this.data.getMixer();
            mixer.getChannelListGroups().removeListener(this.channelListListener);
            for (Object list : mixer.getChannelListGroups()) {
                list.removeListener((ObservableListListener)this);
                parameters = list.iterator();
                while (parameters.hasNext()) {
                    c = (Channel)parameters.next();
                    this.removeListenerFromChannel(c);
                }
            }
            channels = mixer.getChannels();
            channels.removeListener((ObservableListListener)this);
            for (Channel c2 : channels) {
                this.removeListenerFromChannel(c2);
            }
            subChannels = mixer.getSubChannels();
            subChannels.removeListener((ObservableListListener)this);
            for (int i = 0; i < subChannels.size(); ++i) {
                this.removeListenerFromChannel((Channel)subChannels.get(i));
            }
            this.removeListenerFromChannel(mixer.getMaster());
            if (this.score != null) {
                for (LayerGroup layerGroup : this.score) {
                    layerGroup.removeLayerGroupListener((LayerGroupListener)this);
                }
            }
            this.data.removePropertyChangeListener(this.renderTimeListener);
        }
        this.allParameters.clear();
        if (data == null) {
            return;
        }
        arrangement = data.getArrangement();
        for (int i = 0; i < arrangement.size(); ++i) {
            instr = arrangement.getInstrument(i);
            if (!(instr instanceof Automatable)) continue;
            temp = (Automatable)instr;
            ParameterList parameters = temp.getParameterList();
            this.allParameters.addAll((Collection<Parameter>)parameters);
            parameters.addListener(this.parameterListListener);
        }
        arrangement.addAutomatableCollectionListener((AutomatableCollectionListener)this);
        Mixer mixer = data.getMixer();
        mixer.getChannelListGroups().addListener(this.channelListListener);
        for (Object list : mixer.getChannelListGroups()) {
            list.addListener((ObservableListListener)this);
            Iterator parameters = list.iterator();
            while (parameters.hasNext()) {
                c = (Channel)parameters.next();
                this.addListenerToChannel(c);
            }
        }
        channels = mixer.getChannels();
        channels.addListener((ObservableListListener)this);
        for (Channel c3 : channels) {
            this.addListenerToChannel(c3);
        }
        subChannels = mixer.getSubChannels();
        subChannels.addListener((ObservableListListener)this);
        for (int i = 0; i < subChannels.size(); ++i) {
            this.addListenerToChannel((Channel)subChannels.get(i));
        }
        this.addListenerToChannel(mixer.getMaster());
        this.data = data;
        this.score = data.getScore();
        for (LayerGroup layerGroup : this.score) {
            layerGroup.addLayerGroupListener((LayerGroupListener)this);
        }
        this.data.addPropertyChangeListener(this.renderTimeListener);
    }

    private void addListenerToChannel(Channel channel) {
        EffectsChain pre = channel.getPreEffects();
        pre.addAutomatableCollectionListener((AutomatableCollectionListener)this);
        for (int i = 0; i < pre.size(); ++i) {
            ParameterList parameterList = ((Automatable)pre.getElementAt(i)).getParameterList();
            parameterList.addListener(this.parameterListListener);
            this.allParameters.addAll((Collection<Parameter>)parameterList);
        }
        EffectsChain post = channel.getPostEffects();
        post.addAutomatableCollectionListener((AutomatableCollectionListener)this);
        for (int i = 0; i < post.size(); ++i) {
            ParameterList parameterList = ((Automatable)post.getElementAt(i)).getParameterList();
            parameterList.addListener(this.parameterListListener);
            this.allParameters.addAll((Collection<Parameter>)parameterList);
        }
        this.allParameters.add(channel.getLevelParameter());
    }

    private void removeListenerFromChannel(Channel channel) {
        EffectsChain pre = channel.getPreEffects();
        pre.removeAutomatableCollectionListener((AutomatableCollectionListener)this);
        for (int i = 0; i < pre.size(); ++i) {
            ((Automatable)pre.getElementAt(i)).getParameterList().removeListener(this.parameterListListener);
        }
        EffectsChain post = channel.getPostEffects();
        post.removeAutomatableCollectionListener((AutomatableCollectionListener)this);
        for (int i = 0; i < post.size(); ++i) {
            ((Automatable)post.getElementAt(i)).getParameterList().removeListener(this.parameterListListener);
        }
    }

    public JPopupMenu getAutomationMenu(ParameterIdList paramIdList) {
        this.selectedParamIdList = paramIdList;
        JPopupMenu menu = new JPopupMenu();
        JMenu instrRoot = new JMenu("Instrument");
        MenuScroller.setScrollerFor((JMenu)instrRoot);
        Arrangement arrangement = this.data.getArrangement();
        for (int i = 0; i < arrangement.size(); ++i) {
            ParameterList params;
            InstrumentAssignment ia = arrangement.getInstrumentAssignment(i);
            if (!ia.enabled || !(ia.instr instanceof Automatable) || (params = ((Automatable)ia.instr).getParameterList()).size() <= 0) continue;
            JMenu instrMenu = new JMenu();
            MenuScroller.setScrollerFor((JMenu)instrMenu);
            instrMenu.setText(ia.arrangementId + ") " + ia.instr.getName());
            for (Parameter param : params.sorted()) {
                JMenuItem paramItem = new JMenuItem();
                paramItem.setText(param.getName());
                paramItem.addActionListener(this.parameterActionListener);
                if (param.isAutomationEnabled()) {
                    if (paramIdList.contains(param.getUniqueId())) {
                        paramItem.setForeground(Color.GREEN);
                    } else {
                        paramItem.setForeground(Color.ORANGE);
                    }
                }
                paramItem.putClientProperty("instr", ia.instr);
                paramItem.putClientProperty("param", param);
                instrMenu.add(paramItem);
            }
            instrRoot.add(instrMenu);
        }
        menu.add(instrRoot);
        Mixer mixer = this.data.getMixer();
        if (mixer.isEnabled()) {
            ChannelList subChannels;
            JMenu mixerRoot = new JMenu("Mixer");
            MenuScroller.setScrollerFor((JMenu)mixerRoot);
            ChannelList channels = mixer.getChannels();
            if (channels.size() > 0) {
                JMenu channelsMenu = new JMenu("Channels");
                for (int i = 0; i < channels.size(); ++i) {
                    channelsMenu.add(this.buildChannelMenu((Channel)channels.get(i), paramIdList));
                }
                mixerRoot.add(channelsMenu);
            }
            if ((subChannels = mixer.getSubChannels()).size() > 0) {
                JMenu subChannelsMenu = new JMenu("Sub-Channels");
                for (int i = 0; i < subChannels.size(); ++i) {
                    subChannelsMenu.add(this.buildChannelMenu((Channel)subChannels.get(i), paramIdList));
                }
                mixerRoot.add(subChannelsMenu);
            }
            Channel master = mixer.getMaster();
            mixerRoot.add(this.buildChannelMenu(master, paramIdList));
            menu.add(mixerRoot);
        }
        menu.addSeparator();
        JMenuItem clearAll = new JMenuItem("Clear All");
        clearAll.addActionListener(e -> {
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)"Please Confirm Clearing All Parameter Data for this SoundLayer"));
            if (retVal == NotifyDescriptor.YES_OPTION) {
                ParameterIdList idList = this.selectedParamIdList;
                for (String paramId : idList.getParameters()) {
                    Parameter param = this.getParameter(paramId);
                    param.setAutomationEnabled(false);
                    idList.removeParameterId(paramId);
                }
            }
        });
        menu.add(clearAll);
        clearAll.setEnabled(this.selectedParamIdList.size() > 0);
        return menu;
    }

    public JMenu buildChannelMenu(Channel channel, ParameterIdList paramIdList) {
        this.selectedParamIdList = paramIdList;
        JMenu retVal = new JMenu();
        retVal.setText(channel.getName());
        EffectsChain preEffects = channel.getPreEffects();
        if (preEffects.size() > 0) {
            JMenu preMenu = new JMenu("Pre-Effects");
            retVal.add(preMenu);
            MenuScroller.setScrollerFor((JMenu)preMenu);
            for (int i = 0; i < preEffects.size(); ++i) {
                Automatable automatable = (Automatable)preEffects.getElementAt(i);
                ParameterList params = automatable.getParameterList();
                if (params.size() <= 0) continue;
                JMenu effectMenu = new JMenu();
                MenuScroller.setScrollerFor((JMenu)effectMenu);
                if (automatable instanceof Effect) {
                    effectMenu.setText(((Effect)automatable).getName());
                } else if (automatable instanceof Send) {
                    effectMenu.setText("Send: " + ((Send)automatable).getSendChannel());
                } else {
                    effectMenu.setText("ERROR");
                }
                preMenu.add(effectMenu);
                for (Parameter param : params.sorted()) {
                    JMenuItem paramItem = new JMenuItem();
                    paramItem.setText(param.getName());
                    paramItem.addActionListener(this.parameterActionListener);
                    if (param.isAutomationEnabled()) {
                        if (paramIdList.contains(param.getUniqueId())) {
                            paramItem.setForeground(Color.GREEN);
                        } else {
                            paramItem.setForeground(Color.ORANGE);
                        }
                    }
                    paramItem.putClientProperty("param", param);
                    effectMenu.add(paramItem);
                }
            }
        }
        JMenuItem volItem = new JMenuItem("Volume");
        Parameter volParam = channel.getLevelParameter();
        volItem.putClientProperty("param", volParam);
        volItem.addActionListener(this.parameterActionListener);
        if (volParam.isAutomationEnabled()) {
            if (paramIdList.contains(volParam.getUniqueId())) {
                volItem.setForeground(Color.GREEN);
            } else {
                volItem.setForeground(Color.ORANGE);
            }
        }
        retVal.add(volItem);
        EffectsChain postEffects = channel.getPostEffects();
        if (postEffects.size() > 0) {
            JMenu postMenu = new JMenu("Post-Effects");
            MenuScroller.setScrollerFor((JMenu)postMenu);
            retVal.add(postMenu);
            for (int i = 0; i < postEffects.size(); ++i) {
                Automatable automatable = (Automatable)postEffects.getElementAt(i);
                ParameterList params = automatable.getParameterList();
                if (params.size() <= 0) continue;
                JMenu effectMenu = new JMenu();
                MenuScroller.setScrollerFor((JMenu)effectMenu);
                if (automatable instanceof Effect) {
                    effectMenu.setText(((Effect)automatable).getName());
                } else if (automatable instanceof Send) {
                    effectMenu.setText("Send: " + ((Send)automatable).getSendChannel());
                } else {
                    effectMenu.setText("ERROR");
                }
                postMenu.add(effectMenu);
                for (Parameter param : params.sorted()) {
                    JMenuItem paramItem = new JMenuItem();
                    paramItem.setText(param.getName());
                    paramItem.addActionListener(this.parameterActionListener);
                    if (param.isAutomationEnabled()) {
                        if (paramIdList.contains(param.getUniqueId())) {
                            paramItem.setForeground(Color.GREEN);
                        } else {
                            paramItem.setForeground(Color.ORANGE);
                        }
                    }
                    paramItem.putClientProperty("param", param);
                    effectMenu.add(paramItem);
                }
            }
        }
        return retVal;
    }

    public void parameterAdded(Parameter param) {
        this.allParameters.add(param);
    }

    public void parameterRemoved(Parameter param) {
        this.allParameters.remove(param);
        for (LayerGroup layerGroup : this.score) {
            if (!(layerGroup instanceof PolyObject)) continue;
            PolyObject pObj = (PolyObject)layerGroup;
            for (SoundLayer layer : pObj) {
                String paramId;
                ParameterIdList automationParameters = layer.getAutomationParameters();
                if (!automationParameters.contains(paramId = param.getUniqueId())) continue;
                automationParameters.removeParameterId(paramId);
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void automatableAdded(Automatable automatable) {
        ParameterList params = automatable.getParameterList();
        params.addListener(this.parameterListListener);
        this.allParameters.addAll((Collection<Parameter>)params);
    }

    public void automatableRemoved(Automatable automatable) {
        ParameterList params = automatable.getParameterList();
        params.removeListener(this.parameterListListener);
        ArrayList<String> removedParamIds = new ArrayList<String>();
        this.allParameters.removeAll((Collection<?>)params);
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = (Parameter)params.get(i);
            removedParamIds.add(param.getUniqueId());
        }
        this.removeParameters(removedParamIds);
    }

    public Parameter getParameter(String paramId) {
        if (this.data == null) {
            return null;
        }
        for (Parameter param : this.allParameters) {
            if (!param.getUniqueId().equals(paramId)) continue;
            return param;
        }
        return null;
    }

    public void listChanged(ObservableListEvent<Channel> listEvent) {
        switch (listEvent.getType()) {
            case 0: {
                for (Channel channel : listEvent.getAffectedItems()) {
                    this.channelAdded(channel);
                }
                break;
            }
            case 1: {
                for (Channel channel : listEvent.getAffectedItems()) {
                    this.channelRemoved(channel);
                }
                break;
            }
        }
    }

    public void channelAdded(Channel channel) {
        this.addListenerToChannel(channel);
    }

    public void channelRemoved(Channel channel) {
        EffectsChain pre = channel.getPreEffects();
        pre.removeAutomatableCollectionListener((AutomatableCollectionListener)this);
        ArrayList<String> removedParamIds = new ArrayList<String>();
        for (int i = 0; i < pre.size(); ++i) {
            ParameterList parameterList = ((Automatable)pre.getElementAt(i)).getParameterList();
            parameterList.removeListener(this.parameterListListener);
            this.allParameters.removeAll((Collection<?>)parameterList);
            for (int j = 0; j < parameterList.size(); ++j) {
                Parameter parameter = (Parameter)parameterList.get(j);
                if (!parameter.isAutomationEnabled()) continue;
                removedParamIds.add(parameter.getUniqueId());
            }
        }
        EffectsChain post = channel.getPostEffects();
        post.removeAutomatableCollectionListener((AutomatableCollectionListener)this);
        for (int i = 0; i < post.size(); ++i) {
            ParameterList parameterList = ((Automatable)post.getElementAt(i)).getParameterList();
            parameterList.removeListener(this.parameterListListener);
            this.allParameters.removeAll((Collection<?>)parameterList);
            for (int j = 0; j < parameterList.size(); ++j) {
                Parameter parameter = (Parameter)parameterList.get(j);
                if (!parameter.isAutomationEnabled()) continue;
                removedParamIds.add(parameter.getUniqueId());
            }
        }
        Parameter levelParameter = channel.getLevelParameter();
        this.allParameters.remove(levelParameter);
        if (levelParameter.isAutomationEnabled()) {
            removedParamIds.add(levelParameter.getUniqueId());
        }
        this.removeParameters(removedParamIds);
    }

    private void removeParameters(ArrayList<String> paramIds) {
        if (paramIds == null || paramIds.isEmpty()) {
            return;
        }
        for (LayerGroup layerGroup : this.score) {
            if (!(layerGroup instanceof PolyObject)) continue;
            PolyObject pObj = (PolyObject)layerGroup;
            for (SoundLayer layer : pObj) {
                ParameterIdList automationParameters = layer.getAutomationParameters();
                for (int k = automationParameters.size() - 1; k >= 0; --k) {
                    String paramId = automationParameters.getParameterId(k);
                    if (!paramIds.contains(paramId)) continue;
                    automationParameters.removeParameterId(k);
                }
            }
        }
    }

    protected void updateValuesFromAutomations() {
        for (Parameter param : this.allParameters) {
            if (!param.isAutomationEnabled()) continue;
            param.fireUpdateFromTimeChange();
        }
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        if (event.getType() != 1 || !(event.getSource() instanceof PolyObject)) {
            return;
        }
        ArrayList layers = event.getLayers();
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            SoundLayer sLayer = (SoundLayer)layer;
            ParameterIdList idList = sLayer.getAutomationParameters();
            for (int i = 0; i < idList.size(); ++i) {
                String paramId = idList.getParameterId(i);
                Parameter param = this.getParameter(paramId);
                if (param == null) continue;
                param.setAutomationEnabled(false);
            }
        }
    }
}

