/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.ui.utilities.FileChooserManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FileSelectionPanel
extends JComponent {
    private static final String DEFAULT_FILE_MANAGER_GROUP = "fileSelectionPanel";
    private String title;
    private File selectedFile;
    private JTextField fileNameText = new JTextField();
    private JLabel fileLabel = new JLabel();
    private String fileManagerGroup;

    public FileSelectionPanel(String fileManagerGroup) {
        this.fileManagerGroup = fileManagerGroup == null ? DEFAULT_FILE_MANAGER_GROUP : fileManagerGroup;
        this.setLayout(new BorderLayout());
        JButton fileButton = new JButton("...");
        fileButton.addActionListener(e -> this.selectFile());
        this.add((Component)this.fileLabel, "West");
        this.add((Component)this.fileNameText, "Center");
        this.add((Component)fileButton, "East");
    }

    protected void selectFile() {
        FileChooserManager.getDefault().setDialogTitle((Object)this.fileManagerGroup, "Choose File");
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)this.fileManagerGroup, null);
        if (retVal.isEmpty()) {
            return;
        }
        File temp = (File)retVal.get(0);
        this.setSelectedFile(temp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
    }

    public String getSelectedFileName() {
        try {
            return this.selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    public void setSelectedFileName(String fileName) {
        String displayText;
        this.selectedFile = new File(fileName);
        try {
            displayText = this.selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            displayText = "";
        }
        this.fileNameText.setText(displayText);
    }

    public static void main(String[] args) {
    }
}

