/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class Knob
extends JComponent {
    private static final float START = 225.0f;
    private static final float LENGTH = 270.0f;
    private static final float PI = 3.1415f;
    private static final float START_ANG = 3.926875f;
    private static final float LENGTH_ANG = 4.7122498f;
    private static final float MULTIP = 57.29747f;
    private static final Color DEFAULT_FOCUS_COLOR = new Color(0x8080FF);
    private int SHADOWX = 1;
    private int SHADOWY = 1;
    private float DRAG_SPEED;
    private float CLICK_SPEED;
    private int size;
    private int middle;
    public static final int SIMPLE = 1;
    public static final int ROUND = 2;
    private int dragType = 2;
    private static final Dimension MIN_SIZE = new Dimension(40, 40);
    private static final int DEFAULT_PREF_WIDTH = 80;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private ChangeEvent changeEvent = null;
    private final EventListenerList listenerList = new EventListenerList();
    private final Arc2D hitArc = new Arc2D.Float(2);
    private float ang = 3.926875f;
    private float val;
    private int dragpos = -1;
    private float startVal;
    private Color focusColor;
    private double lastAng;

    public Knob() {
        this.createKnob(80);
    }

    public Knob(int preferredWidth) {
        this.createKnob(preferredWidth);
    }

    private void createKnob(int preferredWidth) {
        this.DRAG_SPEED = 0.01f;
        this.CLICK_SPEED = 0.01f;
        this.SHADOWX = 1;
        this.SHADOWY = 1;
        this.focusColor = DEFAULT_FOCUS_COLOR;
        Dimension prefSize = new Dimension(preferredWidth, preferredWidth);
        this.setPreferredSize(prefSize);
        this.hitArc.setAngleStart(235.0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Knob.this.dragpos = me.getX() + me.getY();
                Knob.this.startVal = Knob.this.val;
                int xpos = Knob.this.middle - me.getX();
                int ypos = Knob.this.middle - me.getY();
                Knob.this.lastAng = Math.atan2(xpos, ypos);
                Knob.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                Knob.this.hitArc.setAngleExtent(-290.0);
                if (Knob.this.hitArc.contains(me.getX(), me.getY())) {
                    Knob.this.hitArc.setAngleExtent(57.29747f * (Knob.this.ang - 3.926875f) - 10.0f);
                    if (Knob.this.hitArc.contains(me.getX(), me.getY())) {
                        Knob.this.decValue();
                    } else {
                        Knob.this.incValue();
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (Knob.this.dragType == 1) {
                    float f = Knob.this.DRAG_SPEED * (float)(me.getX() + me.getY() - Knob.this.dragpos);
                    Knob.this.setValue(Knob.this.startVal + f);
                } else if (Knob.this.dragType == 2) {
                    int xpos = Knob.this.middle - me.getX();
                    int ypos = Knob.this.middle - me.getY();
                    double ang = Math.atan2(xpos, ypos);
                    double diff = Knob.this.lastAng - ang;
                    Knob.this.setValue((float)((double)Knob.this.getValue() + diff / 4.712249755859375));
                    Knob.this.lastAng = ang;
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k == 39) {
                    Knob.this.incValue();
                } else if (k == 37) {
                    Knob.this.decValue();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Knob.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Knob.this.repaint();
            }
        });
    }

    public void setDragType(int type) {
        this.dragType = type;
    }

    public int getDragType() {
        return this.dragType;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void incValue() {
        this.setValue(this.val + this.CLICK_SPEED);
    }

    private void decValue() {
        this.setValue(this.val - this.CLICK_SPEED);
    }

    public float getValue() {
        return this.val;
    }

    public void setValue(float val) {
        this.setVal(val);
        this.fireChangeEvent();
    }

    public void setVal(float val) {
        if (val < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        this.val = val;
        this.ang = 3.926875f - 4.7122498f * val;
        this.repaint();
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.size = Math.min(width, height) - 22;
        this.middle = 10 + this.size / 2;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getParent().getBackground());
            g2d.addRenderingHints(AALIAS);
            this.hitArc.setFrame(4.0, 4.0, this.size + 12, this.size + 12);
        }
        for (float a2 = 3.926875f; a2 >= -0.78537464f; a2 -= 0.47075424f) {
            int x = 10 + this.size / 2 + (int)((double)(6 + this.size / 2) * Math.cos(a2));
            int y = 10 + this.size / 2 - (int)((double)(6 + this.size / 2) * Math.sin(a2));
            g.drawLine(10 + this.size / 2, 10 + this.size / 2, x, y);
        }
        if (this.hasFocus()) {
            g.setColor(this.focusColor);
        } else {
            g.setColor(Color.white);
        }
        g.fillOval(10, 10, this.size, this.size);
        g.setColor(Color.gray);
        g.fillOval(14 + this.SHADOWX, 14 + this.SHADOWY, this.size - 8, this.size - 8);
        g.setColor(Color.black);
        g.drawArc(10, 10, this.size, this.size, 315, 270);
        g.fillOval(14, 14, this.size - 8, this.size - 8);
        g.setColor(Color.white);
        int x = 10 + this.size / 2 + (int)((double)(this.size / 2) * Math.cos(this.ang));
        int y = 10 + this.size / 2 - (int)((double)(this.size / 2) * Math.sin(this.ang));
        g.drawLine(10 + this.size / 2, 10 + this.size / 2, x, y);
        g.setColor(Color.gray);
        int s2 = Math.max(this.size / 6, 6);
        g.drawOval(10 + s2, 10 + s2, this.size - s2 * 2, this.size - s2 * 2);
        int dx = (int)(2.0 * Math.sin(this.ang));
        int dy = (int)(2.0 * Math.cos(this.ang));
        g.drawLine(10 + dx + this.size / 2, 10 + dy + this.size / 2, x, y);
        g.drawLine(10 - dx + this.size / 2, 10 - dy + this.size / 2, x, y);
    }
}

