/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.Preset;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.PresetsTreeModel;
import blue.orchestra.editor.blueSynthBuilder.TransferablePreset;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class PresetsTreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    JTree sourceTree;
    TransferablePreset transferable;
    Object oldNode;

    public PresetsTreeDragSource(JTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        if (path.getLastPathComponent() instanceof Preset || path.getLastPathComponent() instanceof PresetGroup) {
            this.oldNode = path.getLastPathComponent();
            this.transferable = new TransferablePreset(this.oldNode);
            this.source.startDrag(dge, null, this.transferable, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            if (this.oldNode instanceof Preset) {
                ((PresetsTreeModel)this.sourceTree.getModel()).removePreset((Preset)this.oldNode);
            } else if (this.oldNode instanceof PresetGroup) {
                ((PresetsTreeModel)this.sourceTree.getModel()).removePresetGroup((PresetGroup)this.oldNode);
            }
        }
        this.oldNode = null;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }
}

