/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.editor.blueSynthBuilder.EditModeOnly;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBEditSelection;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBObjectEditorFactory;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBObjectViewHolder;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import org.openide.util.Exceptions;

public class BSBGroupView
extends BorderPane
implements ResizeableView {
    private Label label = new Label();
    private Pane editorPane = new Pane();
    private Pane containerPane = new Pane();
    private Pane resizePane = new Pane();
    private BooleanProperty editEnabledProperty = null;
    private BSBEditSelection selection;
    private ObservableList<BSBGroup> groupsList;
    private BSBGroup bsbGroup;
    SetChangeListener<BSBObject> scl = sce -> {
        if (sce.wasAdded()) {
            this.addBSBObject((BSBObject)sce.getElementAdded());
        } else {
            this.removeBSBObject((BSBObject)sce.getElementRemoved());
        }
    };

    public BSBGroupView(BSBGroup bsbGroup) {
        this.setUserData(bsbGroup);
        this.bsbGroup = bsbGroup;
        this.label.setStyle("-fx-font-smooth-type: lcd;");
        this.label.setAlignment(Pos.CENTER);
        this.label.setPadding(new Insets(2.0, 8.0, 2.0, 8.0));
        this.editorPane.setPadding(new Insets(0.0, 9.0, 9.0, 0.0));
        this.containerPane.getChildren().addAll((Object[])new Node[]{this.resizePane, this.editorPane});
        this.setTop((Node)this.label);
        this.setCenter((Node)this.containerPane);
        this.editorPane.setMinSize(20.0, 20.0);
        this.label.setMaxWidth(Double.MAX_VALUE);
        this.updateBackgroundColor();
        this.updateBorderColor();
        ChangeListener bgColorListener = (obs, old, newVal) -> this.updateBackgroundColor();
        ChangeListener borderColorListener = (obs, old, newVal) -> this.updateBorderColor();
        ChangeListener titleEnabledLIstener = (obs, old, newVal) -> {
            if (newVal.booleanValue()) {
                this.setTop((Node)this.label);
            } else {
                this.setTop(null);
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                this.label.textProperty().unbind();
                bsbGroup.interfaceItemsProperty().removeListener(this.scl);
                bsbGroup.backgroundColorProperty().removeListener(bgColorListener);
                bsbGroup.borderColorProperty().removeListener(borderColorListener);
                this.label.textFillProperty().unbind();
                bsbGroup.titleEnabledProperty().removeListener(titleEnabledLIstener);
                this.resizePane.prefWidthProperty().unbind();
                this.resizePane.prefHeightProperty().unbind();
            } else {
                this.label.textProperty().bind((ObservableValue)bsbGroup.groupNameProperty());
                bsbGroup.interfaceItemsProperty().addListener(this.scl);
                bsbGroup.backgroundColorProperty().addListener(bgColorListener);
                bsbGroup.borderColorProperty().addListener(borderColorListener);
                this.label.textFillProperty().bind((ObservableValue)bsbGroup.labelTextColorProperty());
                if (bsbGroup.isTitleEnabled()) {
                    this.setTop((Node)this.label);
                } else {
                    this.setTop(null);
                }
                bsbGroup.titleEnabledProperty().addListener(titleEnabledLIstener);
                this.resizePane.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> Math.max((double)bsbGroup.getWidth(), this.editorPane.prefWidth(Double.NEGATIVE_INFINITY)), (Observable[])new Observable[]{bsbGroup.widthProperty(), this.editorPane.boundsInParentProperty()}));
                this.resizePane.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> Math.max((double)bsbGroup.getHeight(), this.editorPane.prefHeight(Double.NEGATIVE_INFINITY)), (Observable[])new Observable[]{bsbGroup.heightProperty(), this.editorPane.boundsInParentProperty()}));
            }
        });
    }

    private void updateBackgroundColor() {
        this.resizePane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.bsbGroup.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private void updateBorderColor() {
        this.label.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.bsbGroup.getBorderColor(), new CornerRadii(4.0, 4.0, 0.0, 0.0, false), Insets.EMPTY)}));
        this.resizePane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.bsbGroup.getBorderColor(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.0))}));
    }

    public void initialize(BooleanProperty editEnabledProperty, BSBEditSelection selection, ObservableList<BSBGroup> groupsList) {
        this.editEnabledProperty = editEnabledProperty;
        this.selection = selection;
        this.groupsList = groupsList;
        for (BSBObject bsbObj : this.bsbGroup) {
            this.addBSBObject(bsbObj);
        }
    }

    protected void addBSBObject(BSBObject bsbObj) {
        try {
            Region objectView = BSBObjectEditorFactory.getView(bsbObj);
            BSBObjectViewHolder viewHolder = new BSBObjectViewHolder(this.editEnabledProperty, this.selection, this.groupsList, objectView);
            if (objectView instanceof EditModeOnly) {
                if (this.editEnabledProperty != null) {
                    viewHolder.visibleProperty().bind((ObservableValue)this.editEnabledProperty);
                } else {
                    viewHolder.setVisible(false);
                }
            }
            if (bsbObj instanceof BSBGroup) {
                BSBGroupView bsbGroupView = (BSBGroupView)objectView;
                bsbGroupView.initialize(this.editEnabledProperty, this.selection, this.groupsList);
            }
            this.editorPane.getChildren().add((Object)viewHolder);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    protected void removeBSBObject(BSBObject bsbObj) {
        Node found = null;
        for (Node n : this.editorPane.getChildren()) {
            if (n.getUserData() != bsbObj) continue;
            found = n;
            break;
        }
        if (found != null) {
            this.editorPane.getChildren().remove(found);
            found.visibleProperty().unbind();
        }
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        double base = this.editorPane.prefWidth(this.editorPane.getPrefHeight());
        if (this.getTop() == this.label) {
            base = Math.max(this.label.minWidth(this.label.getPrefHeight()), base);
        }
        return Math.max(20, (int)base);
    }

    @Override
    public int getWidgetMinimumHeight() {
        double base = this.getTop() == this.label ? this.label.minHeight(this.label.getPrefWidth()) : 0.0;
        return Math.max(20, (int)(base + this.editorPane.prefHeight(this.editorPane.getPrefWidth())));
    }

    @Override
    public int getWidgetWidth() {
        return (int)this.getWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        this.bsbGroup.setWidth(width);
    }

    @Override
    public int getWidgetHeight() {
        return (int)this.getHeight();
    }

    @Override
    public void setWidgetHeight(int height) {
        double base = this.getTop() == this.label ? this.label.prefHeight(this.label.getPrefWidth()) : 0.0;
        this.bsbGroup.setHeight(height - (int)base);
    }

    @Override
    public void setWidgetX(int x) {
        this.bsbGroup.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.bsbGroup.getX();
    }

    @Override
    public void setWidgetY(int y) {
        this.bsbGroup.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.bsbGroup.getY();
    }
}

