/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObjectException;
import blue.soundObject.TrackerObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.tracker.TracksEditor;
import blue.soundObject.tracker.Track;
import blue.soundObject.tracker.TrackList;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import skt.swing.SwingUtil;

public class TrackerEditor
extends ScoreObjectEditor {
    private static final String SHORTCUT_TEXT = "ctrl-space             clear or duplicate previous note\nctrl-shift-space       set to OFF note\nctrl-up                increment value\nctrl-down              decrement value\nctrl-t                 toggle note tie\nctrl-x                 cut selected notes\nctrl-c                 copy selected notes\nctrl-v                 paste notes from copy buffer\ndel                    delete selected notes\n\nctrl-k               toggle keyboard note shortcuts\nctrl-shift-up          raise keyboard octave by one\nctrl-shift-down        lower keyboard octave by one";
    TracksEditor tracksEditor = new TracksEditor();
    TrackerObject tracker = null;
    JSpinner spinner;
    JSpinner octaveSpinner;
    JCheckBox useKeyboardNotes;

    public TrackerEditor() {
        Box menuPanel = this.getMenuPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)menuPanel, "North");
        this.add((Component)this.tracksEditor, "Center");
        SwingUtil.installActions((JComponent)this, (Action[])new Action[]{new TestAction(), new UseKeyboardNotesAction(), new IncrementOctaveAction(), new DecrementOctaveAction()}, (int)1);
    }

    private Box getMenuPanel() {
        Box panel = Box.createHorizontalBox();
        JButton addButton = new JButton("+");
        addButton.addActionListener(e -> {
            if (this.tracker != null) {
                Track t = new Track();
                TrackList trackList = this.tracker.getTracks();
                t.setName(trackList.getNextTrackName());
                trackList.addTrack(t);
            }
        });
        addButton.setToolTipText("Add New Track");
        addButton.setFocusPainted(false);
        JLabel label = new JLabel("Tracker");
        label.setFont(new Font("Dialog", 1, 16));
        JButton button = new JButton("Test");
        button.addActionListener(e -> this.testSoundObject());
        button.setFocusPainted(false);
        JButton helpButton = new JButton("[ ? ]");
        helpButton.addActionListener(e -> this.showHelpText());
        helpButton.setFocusPainted(false);
        this.spinner = new JSpinner();
        this.spinner.setModel(new SpinnerNumberModel(16, 1, Integer.MAX_VALUE, 1));
        this.spinner.addChangeListener(e -> {
            if (this.tracker != null) {
                this.tracker.setSteps(((Integer)this.spinner.getValue()).intValue());
                this.tracksEditor.revalidate();
                this.tracksEditor.repaint();
            }
        });
        Dimension d = new Dimension(50, 20);
        this.spinner.setSize(d);
        this.spinner.setPreferredSize(d);
        this.spinner.setMaximumSize(d);
        this.useKeyboardNotes = new JCheckBox("Use Keyboard Notes");
        this.useKeyboardNotes.addActionListener(e -> this.tracksEditor.useKeyboardNoteShortcuts(this.useKeyboardNotes.isSelected()));
        this.octaveSpinner = new JSpinner();
        this.octaveSpinner.setModel(new SpinnerNumberModel(0, -8, 8, 1));
        this.octaveSpinner.addChangeListener(e -> {
            if (this.tracker != null) {
                int oct = (Integer)this.octaveSpinner.getValue();
                this.tracksEditor.setKeyboardOctave(oct);
            }
        });
        this.octaveSpinner.setSize(d);
        this.octaveSpinner.setPreferredSize(d);
        this.octaveSpinner.setMaximumSize(d);
        panel.add(label);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(addButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new JLabel("Steps"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.spinner);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.useKeyboardNotes);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(new JLabel("Octave"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.octaveSpinner);
        panel.add(Box.createHorizontalGlue());
        panel.add(button);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(helpButton);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        return panel;
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            System.err.println("[TrackerEditor::editSoundObject()] ERROR: null SoundObject");
            this.tracker = null;
            return;
        }
        if (!(sObj instanceof TrackerObject)) {
            System.err.println("[PolyObjectEditor::editSoundObject()] ERROR: not an instance of TrackerObject");
            this.tracker = null;
            return;
        }
        this.tracker = null;
        TrackerObject newTracker = (TrackerObject)sObj;
        this.spinner.setValue(new Integer(newTracker.getSteps()));
        this.tracker = newTracker;
        this.tracksEditor.setTrackerObject(this.tracker);
    }

    private void testSoundObject() {
        if (this.tracker == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.tracker.generateNotes(0.0, -1.0);
        }
        catch (SoundObjectException e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    private void showHelpText() {
        InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), SHORTCUT_TEXT, "Shortcuts");
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        TrackerEditor trackerEditor = new TrackerEditor();
        trackerEditor.editScoreObject((ScoreObject)new TrackerObject());
        GUI.showComponentAsStandalone((Component)trackerEditor, (String)"Tracker Editor", (boolean)true);
    }

    class DecrementOctaveAction
    extends AbstractAction {
        public DecrementOctaveAction() {
            super("decrement-octave");
            this.putValue("ShortDescription", "decrement-octave");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, BlueSystem.getMenuShortcutKey() | 0x40));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinnerModel model = TrackerEditor.this.octaveSpinner.getModel();
            if (model.getPreviousValue() != null) {
                model.setValue(model.getPreviousValue());
            }
        }
    }

    class IncrementOctaveAction
    extends AbstractAction {
        public IncrementOctaveAction() {
            super("increment-octave");
            this.putValue("ShortDescription", "increment-octave");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, BlueSystem.getMenuShortcutKey() | 0x40));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinnerModel model = TrackerEditor.this.octaveSpinner.getModel();
            if (model.getNextValue() != null) {
                model.setValue(model.getNextValue());
            }
        }
    }

    class UseKeyboardNotesAction
    extends AbstractAction {
        public UseKeyboardNotesAction() {
            super("useKeyboardNotesAction");
            this.putValue("ShortDescription", "useKeyboardNotesAction");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(75, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrackerEditor.this.useKeyboardNotes.doClick();
        }
    }

    class TestAction
    extends AbstractAction {
        public TestAction() {
            super("test-button");
            this.putValue("ShortDescription", "Test Button");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrackerEditor.this.testSoundObject();
        }
    }
}

