/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.gui.LabelledItemPanel;
import blue.soundObject.PianoRoll;
import blue.soundObject.editor.pianoRoll.NoteBuffer;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import blue.soundObject.editor.pianoRoll.ScaleSelectionPanel;
import blue.soundObject.pianoRoll.PianoNote;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PianoRollPropertiesEditor
extends JScrollPane {
    JTextField noteTemplateText = new JTextField();
    ScaleSelectionPanel scalePanel = new ScaleSelectionPanel();
    JTextField baseFrequencyText = new JTextField();
    JTextField instrumentIDText = new JTextField();
    JRadioButton frequencyOption = new JRadioButton(BlueSystem.getString((String)"pianoRoll.frequency"));
    JRadioButton pchOption = new JRadioButton("blue PCH");
    JRadioButton midiOption = new JRadioButton("MIDI");
    SpinnerNumberModel intModel = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
    JSpinner transposition = new JSpinner(this.intModel);
    private PianoRoll p;
    private boolean isUpdating;
    private NoteBuffer noteBuffer;

    public PianoRollPropertiesEditor() {
        LabelledItemPanel mainPanel = new LabelledItemPanel();
        ActionListener timeActionListener = e -> {
            if (!this.isUpdating) {
                if (e.getSource() == this.frequencyOption) {
                    this.p.setPchGenerationMethod(0);
                } else if (e.getSource() == this.pchOption) {
                    this.p.setPchGenerationMethod(1);
                } else if (e.getSource() == this.midiOption) {
                    this.p.setPchGenerationMethod(2);
                }
            }
        };
        this.frequencyOption.addActionListener(timeActionListener);
        this.pchOption.addActionListener(timeActionListener);
        this.midiOption.addActionListener(timeActionListener);
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1));
        buttonPanel.add(this.frequencyOption);
        buttonPanel.add(this.pchOption);
        buttonPanel.add(this.midiOption);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.frequencyOption);
        bg.add(this.pchOption);
        bg.add(this.midiOption);
        JPanel noteTemplatePanel = new JPanel(new BorderLayout());
        JButton setAllNotesButton = new JButton(BlueSystem.getString((String)"pianoRoll.setAllNotes"));
        JButton setSelectedNotesButton = new JButton(BlueSystem.getString((String)"pianoRoll.setSelectedNotes"));
        JPanel noteButtonPanel = new JPanel(new GridLayout(1, 2));
        noteButtonPanel.add(setSelectedNotesButton);
        noteButtonPanel.add(setAllNotesButton);
        noteTemplatePanel.add((Component)this.noteTemplateText, "Center");
        noteTemplatePanel.add((Component)noteButtonPanel, "East");
        mainPanel.addItem(BlueSystem.getString((String)"pianoRoll.instrumentID"), this.instrumentIDText);
        mainPanel.addItem(BlueSystem.getString((String)"pianoRoll.noteTemplate"), noteTemplatePanel);
        mainPanel.addItem(BlueSystem.getString((String)"pianoRoll.scale"), this.scalePanel);
        mainPanel.addItem(BlueSystem.getString((String)"pianoRoll.baseFrequency"), this.baseFrequencyText);
        mainPanel.addItem(BlueSystem.getString((String)"pianoRoll.pchGeneration"), buttonPanel);
        mainPanel.addItem("Transposition:", this.transposition);
        this.baseFrequencyText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PianoRollPropertiesEditor.this.updateBaseFrequency();
            }
        });
        this.baseFrequencyText.addActionListener(e -> this.updateBaseFrequency());
        this.transposition.addChangeListener(e -> this.updateTransposition());
        this.noteTemplateText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            private void updateNoteTemplate() {
                if (PianoRollPropertiesEditor.this.p != null && !PianoRollPropertiesEditor.this.isUpdating) {
                    PianoRollPropertiesEditor.this.p.setNoteTemplate(PianoRollPropertiesEditor.this.noteTemplateText.getText());
                }
            }
        });
        setAllNotesButton.addActionListener(e -> this.setAllNoteTemplates());
        setSelectedNotesButton.addActionListener(e -> this.setSelectedNoteTemplates());
        this.instrumentIDText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateInstrumentId();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateInstrumentId();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateInstrumentId();
            }

            private void updateInstrumentId() {
                if (PianoRollPropertiesEditor.this.p != null && !PianoRollPropertiesEditor.this.isUpdating) {
                    PianoRollPropertiesEditor.this.p.setInstrumentId(PianoRollPropertiesEditor.this.instrumentIDText.getText());
                }
            }
        });
        this.setViewportView(mainPanel);
        this.setHorizontalScrollBarPolicy(31);
        this.setBorder(null);
        this.scalePanel.addChangeListener(e -> {
            if (this.p != null) {
                this.p.setScale(this.scalePanel.getScale());
            }
        });
    }

    protected void updateTransposition() {
        if (this.p == null) {
            return;
        }
        Integer val = (Integer)this.transposition.getValue();
        this.p.setTransposition(val.intValue());
    }

    protected void setAllNoteTemplates() {
        if (this.p == null) {
            return;
        }
        String noteTemplate = this.p.getNoteTemplate();
        for (PianoNote note : this.p.getNotes()) {
            note.setNoteTemplate(noteTemplate);
        }
    }

    protected void setSelectedNoteTemplates() {
        if (this.p == null || this.noteBuffer == null) {
            return;
        }
        String noteTemplate = this.p.getNoteTemplate();
        for (PianoNoteView pianoNoteView : this.noteBuffer) {
            PianoNote note = pianoNoteView.getPianoNote();
            note.setNoteTemplate(noteTemplate);
        }
    }

    protected void updateBaseFrequency() {
        double newValue;
        try {
            newValue = Double.parseDouble(this.baseFrequencyText.getText());
        }
        catch (NumberFormatException nfe) {
            this.baseFrequencyText.setText(Double.toString(this.p.getScale().getBaseFrequency()));
            return;
        }
        if (newValue < 0.0) {
            newValue = 0.0;
        }
        this.p.getScale().setBaseFrequency(newValue);
    }

    public void editPianoRoll(PianoRoll p) {
        this.isUpdating = false;
        this.p = p;
        this.noteTemplateText.setText(p.getNoteTemplate());
        this.instrumentIDText.setText(p.getInstrumentId());
        this.baseFrequencyText.setText(Double.toString(p.getScale().getBaseFrequency()));
        this.scalePanel.setScale(p.getScale());
        if (p.getPchGenerationMethod() == 0) {
            this.frequencyOption.setSelected(true);
        } else if (p.getPchGenerationMethod() == 1) {
            this.pchOption.setSelected(true);
        } else if (p.getPchGenerationMethod() == 2) {
            this.midiOption.setSelected(true);
        }
        this.transposition.setValue(new Integer(p.getTransposition()));
        this.isUpdating = false;
    }

    public void setNoteBuffer(NoteBuffer noteBuffer) {
        this.noteBuffer = noteBuffer;
    }
}

