/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.soundObjects;

import blue.BlueSystem;
import blue.library.Library;
import blue.library.LibraryItem;
import blue.soundObject.ObjectBuilder;
import blue.soundObject.Sound;
import blue.soundObject.SoundObject;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.LibraryTreeModel;
import blue.tools.blueShare.NamePasswordPanel;
import blue.tools.blueShare.soundObjects.BlueShareSoundObjectCategory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import javafx.scene.control.TreeItem;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcException;

public class SoundObjectExportPane
extends JComponent {
    private static final String SELECT_INSTR_TEXT = "Select a SoundObject to export";
    NamePasswordPanel namePasswordPanel = new NamePasswordPanel();
    JPanel jPanel2 = new JPanel();
    JSplitPane topSplitPane = new JSplitPane();
    JScrollPane descriptionScrollPane = new JScrollPane();
    JTextArea descriptionText = new JTextArea();
    JButton submitButton = new JButton();
    JPanel soundObjectListPanel = new JPanel();
    JTree soundObjectLibraryTree = new JTree();
    JScrollPane soundObjectListScrollPane = new JScrollPane();
    JLabel iLabel = new JLabel();
    JSplitPane mainSplitPane = new JSplitPane();
    JPanel categoryPanel = new JPanel();
    JLabel cateogriesLabel = new JLabel();
    JScrollPane categoryScrollPane = new JScrollPane();
    JTree categoryTree = new JTree();

    public SoundObjectExportPane() {
        this.soundObjectLibraryTree.setModel(new LibraryTreeModel((Library<? extends SoundObject>)BlueSystem.getSoundObjectLibrary()));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.descriptionText.setText(SELECT_INSTR_TEXT);
        this.descriptionText.setEnabled(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.soundObjectListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.categoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cateogriesLabel.setText(BlueSystem.getString((String)"common.categories"));
        this.categoryPanel.setLayout(new BorderLayout());
        this.add((Component)this.namePasswordPanel, "North");
        this.add((Component)this.mainSplitPane, "Center");
        this.add((Component)this.jPanel2, "South");
        this.descriptionText.setText(BlueSystem.getString((String)"blueShare.enterDescription"));
        this.descriptionText.setLineWrap(true);
        this.descriptionScrollPane.setBorder(new TitledBorder(null, BlueSystem.getString((String)"blueShare.instrDescription")));
        this.submitButton.setText(BlueSystem.getString((String)"common.submit"));
        this.soundObjectListPanel.setLayout(new BorderLayout());
        this.iLabel.setText("SoundObjects from Library");
        this.topSplitPane.add((Component)this.soundObjectListPanel, "left");
        this.soundObjectListPanel.add((Component)this.soundObjectListScrollPane, "Center");
        this.soundObjectListPanel.add((Component)this.iLabel, "North");
        this.soundObjectListScrollPane.getViewport().add((Component)this.soundObjectLibraryTree, null);
        this.descriptionScrollPane.getViewport().add((Component)this.descriptionText, null);
        this.jPanel2.add((Component)this.submitButton, null);
        this.topSplitPane.setDividerLocation(300);
        this.mainSplitPane.setOrientation(0);
        this.mainSplitPane.add((Component)this.topSplitPane, "top");
        this.mainSplitPane.add((Component)this.descriptionScrollPane, "bottom");
        this.topSplitPane.add((Component)this.categoryPanel, "right");
        this.categoryPanel.add((Component)this.cateogriesLabel, "North");
        this.categoryPanel.add((Component)this.categoryScrollPane, "Center");
        this.categoryScrollPane.getViewport().add((Component)this.categoryTree, null);
        this.mainSplitPane.setDividerLocation(200);
        this.submitButton.addActionListener(e -> this.submitSoundObject());
        this.soundObjectLibraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = SoundObjectExportPane.this.soundObjectLibraryTree.getSelectionPath();
                if (path == null) {
                    SoundObjectExportPane.this.descriptionText.setText(SoundObjectExportPane.SELECT_INSTR_TEXT);
                    SoundObjectExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                Object userObj = path.getLastPathComponent();
                TreeItem node = (TreeItem)userObj;
                if (!node.isLeaf()) {
                    SoundObjectExportPane.this.descriptionText.setText(SoundObjectExportPane.SELECT_INSTR_TEXT);
                    SoundObjectExportPane.this.descriptionText.setEnabled(false);
                    return;
                }
                SoundObject instr = ((LibraryItem)node.getValue()).getValue();
                if (instr instanceof Sound) {
                    SoundObjectExportPane.this.descriptionText.setText(((Sound)instr).getComment());
                } else if (instr instanceof ObjectBuilder) {
                    SoundObjectExportPane.this.descriptionText.setText(((ObjectBuilder)instr).getComment());
                } else {
                    SoundObjectExportPane.this.descriptionText.setText("");
                }
                SoundObjectExportPane.this.descriptionText.setEnabled(true);
            }
        });
    }

    public void setCategories(BlueShareSoundObjectCategory[] categories) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(BlueSystem.getString((String)"common.categories"));
        this.addSubCategories(root, categories);
        this.categoryTree.setModel(new DefaultTreeModel(root));
    }

    private void addSubCategories(DefaultMutableTreeNode parent, BlueShareSoundObjectCategory[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            DefaultMutableTreeNode temp = new DefaultMutableTreeNode(categories[i]);
            parent.add(temp);
            this.addSubCategories(temp, categories[i].getSubCategories());
        }
    }

    private void submitSoundObject() {
        try {
            TreePath path = this.soundObjectLibraryTree.getSelectionPath();
            if (path == null) {
                return;
            }
            Object userObj = path.getLastPathComponent();
            TreeItem node = (TreeItem)userObj;
            if (!node.isLeaf()) {
                return;
            }
            SoundObject soundObject = ((LibraryItem)node.getValue()).getValue();
            DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)this.categoryTree.getSelectionPath().getLastPathComponent();
            BlueShareSoundObjectCategory category = (BlueShareSoundObjectCategory)tempNode.getUserObject();
            String username = this.namePasswordPanel.getUsername();
            String password = this.namePasswordPanel.getPassword();
            int categoryId = category.getCategoryId();
            String name = soundObject.getName();
            String soundObjectType = soundObject.getClass().getName();
            String description = this.descriptionText.getText();
            String soundObjectText = soundObject.saveAsXML(new HashMap()).toString();
            System.out.println(soundObject.saveAsXML(new HashMap()).getTextString());
            BlueShareRemoteCaller.submitSoundObject(username, password, categoryId, name, soundObjectType, description, soundObjectText);
        }
        catch (IOException | XmlRpcException e) {
            JOptionPane.showMessageDialog(null, "Error submitting SoundObject\n\n" + e.getLocalizedMessage(), BlueSystem.getString((String)"common.error"), 0);
            e.printStackTrace();
            return;
        }
        JOptionPane.showMessageDialog(null, "SoundObject was successfully received.", BlueSystem.getString((String)"common.success"), -1);
    }

    public static void main(String[] args) {
        SoundObjectExportPane soundObjectExportPane1 = new SoundObjectExportPane();
        GUI.showComponentAsStandalone((Component)soundObjectExportPane1, (String)"SoundObject Export Pane Test", (boolean)true);
    }
}

