/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.soundFont;

import blue.tools.soundFont.InstrumentInfo;
import blue.tools.soundFont.InstrumentInfoTableModel;
import blue.tools.soundFont.PresetInfo;
import blue.tools.soundFont.PresetInfoTableModel;
import java.util.StringTokenizer;

public class SoundFontInfo {
    public String instrumentList;
    public String presetList;
    public InstrumentInfoTableModel instrumentTableModel = new InstrumentInfoTableModel();
    public PresetInfoTableModel presetTableModel = new PresetInfoTableModel();

    public SoundFontInfo(String instrumentList, String presetList) {
        this.instrumentList = instrumentList;
        this.presetList = presetList;
        this.setupInstruments();
        this.setupPresets();
    }

    private void setupPresets() {
        StringTokenizer st = new StringTokenizer(this.presetList, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int index = line.indexOf(")");
            int index2 = line.indexOf("prog");
            String[] parts = line.split("\\s+");
            PresetInfo pInfo = new PresetInfo();
            pInfo.num = line.substring(0, index).trim();
            pInfo.name = line.substring(index + 1, index2).trim();
            pInfo.bank = parts[parts.length - 1].substring(5);
            pInfo.presetNum = parts[parts.length - 2].substring(5);
            this.presetTableModel.addPresetInfo(pInfo);
        }
    }

    private void setupInstruments() {
        StringTokenizer st = new StringTokenizer(this.instrumentList, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int index = line.indexOf(")");
            InstrumentInfo instrInfo = new InstrumentInfo();
            instrInfo.num = line.substring(0, index).trim();
            instrInfo.name = line.substring(index + 1).trim();
            this.instrumentTableModel.addInfo(instrInfo);
        }
    }
}

