/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.InstrumentLibrary;
import blue.gui.DragManager;
import blue.orchestra.Instrument;
import blue.orchestra.InstrumentCategory;
import blue.ui.core.orchestra.TransferableInstrument;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class InstrumentTreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    JTree sourceTree;
    TransferableInstrument transferable;
    Object oldNode;

    public InstrumentTreeDragSource(JTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        if (path.getLastPathComponent() instanceof Instrument || path.getLastPathComponent() instanceof InstrumentCategory) {
            this.oldNode = path.getLastPathComponent();
            Object cloneNode = null;
            if (this.oldNode instanceof Instrument) {
                cloneNode = ((Instrument)this.oldNode).deepCopy();
            } else if (this.oldNode instanceof InstrumentCategory) {
                cloneNode = new InstrumentCategory((InstrumentCategory)this.oldNode);
            }
            this.transferable = new TransferableInstrument(cloneNode);
            this.source.startDrag(dge, null, this.transferable, this);
            DragManager.setDragSource(this.sourceTree);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2) {
            if (this.oldNode instanceof Instrument) {
                ((InstrumentLibrary)this.sourceTree.getModel()).removeInstrument((Instrument)this.oldNode);
            } else if (this.oldNode instanceof InstrumentCategory) {
                ((InstrumentLibrary)this.sourceTree.getModel()).removeCategory((InstrumentCategory)this.oldNode);
            }
        }
        this.oldNode = null;
        DragManager.setDragSource(null);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }
}

