/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueData;
import blue.Marker;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.utilities.UiUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="MarkersTopComponent", persistenceType=0)
public final class MarkersTopComponent
extends TopComponent {
    private static MarkersTopComponent instance;
    private MarkersPopup popup = null;
    private BlueData data = null;
    private JScrollPane jScrollPane1;
    private JTable markersTable;

    public MarkersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MarkersTopComponent.class, (String)"CTL_MarkersTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MarkersTopComponent.class, (String)"HINT_MarkersTopComponent"));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    protected void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData currentData = null;
        if (project != null) {
            currentData = project.getData();
        }
        this.data = currentData;
        this.markersTable.setModel((TableModel)currentData.getMarkersList());
        this.markersTable.getColumnModel().getColumn(0).setPreferredWidth(100);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.markersTable = new JTable();
        this.markersTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.markersTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MarkersTopComponent.this.markersTableMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.markersTable);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 291, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    private void markersTableMousePressed(MouseEvent evt) {
        if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
            if (this.popup == null) {
                this.popup = new MarkersPopup();
            }
            this.popup.show(this.markersTable, evt.getX(), evt.getY());
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    class MarkersPopup
    extends JPopupMenu {
        public MarkersPopup() {
            this.add(new SetStartTimeAction());
            this.add(new DeleteMarkerAction());
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (MarkersTopComponent.this.markersTable.getSelectedRow() < 0) {
                return;
            }
            super.show(invoker, x, y);
        }

        class DeleteMarkerAction
        extends AbstractAction {
            public DeleteMarkerAction() {
                super("Delete Marker");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MarkersTopComponent.this.markersTable.getSelectedRow();
                MarkersTopComponent.this.data.getMarkersList().removeMarker(index);
            }
        }

        class SetStartTimeAction
        extends AbstractAction {
            public SetStartTimeAction() {
                super("Set Start Time to Marker Time");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MarkersTopComponent.this.markersTable.getSelectedRow();
                Marker m = MarkersTopComponent.this.data.getMarkersList().getMarker(index);
                MarkersTopComponent.this.data.setRenderStartTime(m.getTime());
            }
        }
    }
}

