/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueData;
import blue.event.SelectionEvent;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.score.layers.LayerGroup;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.layers.SoundObjectProvider;
import blue.ui.nbutilities.lazyplugin.ClassAssociationProcessor;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ScoreObjectEditorTopComponent", persistenceType=0)
public final class ScoreObjectEditorTopComponent
extends TopComponent
implements LookupListener {
    private static ScoreObjectEditorTopComponent instance;
    JPanel editPanel = new JPanel();
    CardLayout cardLayout = new CardLayout();
    ScoreObject currentSoundObject;
    Map<Class, LazyPlugin<ScoreObjectEditor>> sObjEditorMap = new HashMap<Class, LazyPlugin<ScoreObjectEditor>>();
    Map<Class, ScoreObjectEditor> editors = new HashMap<Class, ScoreObjectEditor>();
    JPanel emptyPanel = new JPanel();
    Lookup.Result<ScoreObject> result = null;
    PropertyChangeListener projectListener;

    private ScoreObjectEditorTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ScoreObjectEditorTopComponent.class, (String)"CTL_ScoreObjectEditorTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScoreObjectEditorTopComponent.class, (String)"HINT_ScoreObjectEditorTopComponent"));
        this.emptyPanel.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.editPanel.setLayout(this.cardLayout);
        this.add(this.editPanel, "Center");
        this.editPanel.add((Component)this.emptyPanel, "none");
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/score/objectEditors", ScoreObjectEditor.class, (LazyPluginFactory.MetaDataProcessor)new ClassAssociationProcessor("scoreObjectType"));
        for (LazyPlugin plugin : plugins) {
            this.sObjEditorMap.put((Class)plugin.getMetaData("association"), (LazyPlugin<ScoreObjectEditor>)plugin);
        }
        this.setEditingLibraryObject(null);
        this.setActivatedNodes(null);
        this.projectListener = evt -> this.editScoreObject(null);
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public void componentOpened() {
        BlueProjectManager.getInstance().addPropertyChangeListener(this.projectListener);
        this.result = Utilities.actionsGlobalContext().lookupResult(ScoreObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void componentClosed() {
        BlueProjectManager.getInstance().removePropertyChangeListener(this.projectListener);
        this.result.removeLookupListener((LookupListener)this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void resultChanged(LookupEvent ev) {
        if (!(TopComponent.getRegistry().getActivated() instanceof SoundObjectProvider)) {
            return;
        }
        Collection scoreObjects = this.result.allInstances();
        if (scoreObjects.size() == 1) {
            SwingUtilities.invokeLater(() -> {
                BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
                ScoreObject sObj = (ScoreObject)scoreObjects.iterator().next();
                if (sObj instanceof PolyObject && data.getSoundObjectLibrary().contains((Object)sObj)) {
                    PolyObject pObj = (PolyObject)sObj;
                    ScoreController.getInstance().editLayerGroup((LayerGroup)pObj);
                    this.editScoreObject(null);
                } else {
                    this.editScoreObject(sObj);
                }
            });
        } else {
            SwingUtilities.invokeLater(() -> this.editScoreObject(null));
        }
    }

    public void setEditingLibraryObject(Object objectType) {
        String name = NbBundle.getMessage(ScoreObjectEditorTopComponent.class, (String)"CTL_ScoreObjectEditorTopComponent");
        if (objectType == SelectionEvent.SELECTION_LIBRARY) {
            name = name + " - Library";
        } else if (objectType == SelectionEvent.SELECTION_BLUE_LIVE) {
            name = name + " - blue Live";
        }
        this.setName(name);
    }

    public void editScoreObject(ScoreObject sObj) {
        if (this.currentSoundObject == sObj) {
            return;
        }
        this.currentSoundObject = sObj;
        this.cardLayout.show(this.editPanel, "none");
        if (sObj == null) {
            return;
        }
        ScoreObject sObjToEdit = sObj;
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        if (sObj instanceof Instance) {
            sObjToEdit = ((Instance)sObj).getSoundObject();
            this.setEditingLibraryObject(SelectionEvent.SELECTION_LIBRARY);
        } else if (data.getSoundObjectLibrary().contains((Object)sObjToEdit)) {
            this.setEditingLibraryObject(SelectionEvent.SELECTION_LIBRARY);
        } else {
            this.setEditingLibraryObject(null);
        }
        ScoreObjectEditor editor = this.editors.get(sObjToEdit.getClass());
        if (editor == null) {
            for (Class c : this.sObjEditorMap.keySet()) {
                if (!c.isAssignableFrom(sObjToEdit.getClass())) continue;
                LazyPlugin<ScoreObjectEditor> plugin = this.sObjEditorMap.get(c);
                editor = (ScoreObjectEditor)plugin.getInstance();
                this.editors.put(sObjToEdit.getClass(), editor);
                this.editPanel.add((Component)editor, editor.getClass().getName());
                break;
            }
        }
        if (editor == null) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)("Could not find editor for SoundObject of type: " + sObjToEdit.getClass().getCanonicalName()), "Error", -1, 0, null, null));
            return;
        }
        editor.editScoreObject(sObjToEdit);
        this.cardLayout.show(this.editPanel, editor.getClass().getName());
    }
}

