/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.undo.AlignEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class AlignCenterAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> selected;

    public AlignCenterAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AlignCenterAction(Lookup lookup) {
        super(NbBundle.getMessage(AlignCenterAction.class, (String)"CTL_AlignCenterAction"));
        this.selected = lookup.lookupAll(ScoreObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.selected.size() < 2) {
            return;
        }
        double[] initialStartTimes = new double[this.selected.size()];
        double[] endingStartTimes = new double[this.selected.size()];
        double farLeft = Double.MAX_VALUE;
        double farRight = Double.MIN_VALUE;
        int i = 0;
        for (ScoreObject scoreObject : this.selected) {
            initialStartTimes[i] = scoreObject.getStartTime();
            double end = initialStartTimes[i] + scoreObject.getSubjectiveDuration();
            if (initialStartTimes[i] < farLeft) {
                farLeft = initialStartTimes[i];
            }
            if (end > farRight) {
                farRight = end;
            }
            ++i;
        }
        double centerTime = (farRight - farLeft) / 2.0 + farLeft;
        i = 0;
        for (ScoreObject scoreObject : this.selected) {
            double newEndTime = centerTime - scoreObject.getSubjectiveDuration() / 2.0;
            scoreObject.setStartTime(newEndTime);
            endingStartTimes[i] = newEndTime;
            ++i;
        }
        BlueUndoManager.setUndoManager((String)"score");
        AlignEdit edit = new AlignEdit(this.selected.toArray(new ScoreObject[0]), initialStartTimes, endingStartTimes);
        edit.setPresentationName("Align Center");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }

    @Override
    public boolean isEnabled() {
        return this.selected.size() > 1;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AlignCenterAction(actionContext);
    }
}

