/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.undo.AlignEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FollowTheLeaderAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> selected;

    public FollowTheLeaderAction() {
        this(Utilities.actionsGlobalContext());
    }

    private FollowTheLeaderAction(Lookup lookup) {
        super(NbBundle.getMessage(FollowTheLeaderAction.class, (String)"CTL_FollowTheLeaderAction"));
        this.selected = lookup.lookupAll(ScoreObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<? extends ScoreObject> scoreObjs = new ArrayList<ScoreObject>(this.selected);
        Collections.sort(scoreObjs, (o1, o2) -> {
            double diff = o1.getStartTime() - o2.getStartTime();
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        });
        double[] initialStartTimes = new double[scoreObjs.size()];
        double[] endStartTimes = new double[scoreObjs.size()];
        for (int i = 0; i < scoreObjs.size(); ++i) {
            initialStartTimes[i] = ((ScoreObject)scoreObjs.get(i)).getStartTime();
        }
        ScoreObject initial = (ScoreObject)scoreObjs.get(0);
        double runningTotal = initial.getStartTime() + initial.getSubjectiveDuration();
        endStartTimes[0] = initial.getStartTime();
        for (int i = 1; i < scoreObjs.size(); ++i) {
            ScoreObject current = (ScoreObject)scoreObjs.get(i);
            endStartTimes[i] = runningTotal;
            current.setStartTime(runningTotal);
            runningTotal += current.getSubjectiveDuration();
        }
        BlueUndoManager.setUndoManager((String)"score");
        AlignEdit edit = new AlignEdit(scoreObjs.toArray(new ScoreObject[0]), initialStartTimes, endStartTimes);
        edit.setPresentationName("Follow the Leader");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }

    @Override
    public boolean isEnabled() {
        return this.selected.size() > 1;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new FollowTheLeaderAction(actionContext);
    }
}

