/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class AlignEdit
extends AbstractUndoableEdit {
    private ScoreObject[] soundObjects;
    private double[] initalStartTimes;
    private double[] endingStartTimes;
    private String presentationName;

    public AlignEdit(ScoreObject[] soundObjects, double[] initialStartTimes, double[] endingStartTimes) {
        this.soundObjects = soundObjects;
        this.initalStartTimes = initialStartTimes;
        this.endingStartTimes = endingStartTimes;
        this.presentationName = BlueSystem.getString((String)"scoreGUI.action.align");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (int i = 0; i < this.soundObjects.length; ++i) {
            this.soundObjects[i].setStartTime(this.endingStartTimes[i]);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = 0; i < this.soundObjects.length; ++i) {
            this.soundObjects[i].setStartTime(this.initalStartTimes[i]);
        }
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }
}

