/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.components.LabelledPanel;
import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.utility.GUI;
import blue.utility.TextUtilities;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class UDORepositoryBrowser
extends JDialog {
    private static XmlRpcClient xrpc;
    private static String UDO_REPO_URL;
    JTree categories = new JTree();
    JList<UDOItem> udoList = new JList();
    UDODisplayPanel udoDisplayPanel = new UDODisplayPanel();
    OpcodeList opcodeList = null;

    public UDORepositoryBrowser(Window owner) {
        super(owner);
        this.setTitle("User-Defined Opcode Repository Browser");
        this.categories.setModel(null);
        this.categories.setRootVisible(false);
        this.categories.getSelectionModel().addTreeSelectionListener(e -> {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                return;
            }
            try {
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                UDOItem tempCat = (UDOItem)tempNode.getUserObject();
                this.populateUDOList(tempCat);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        this.udoList.setSelectionMode(0);
        this.udoList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                UDOItem obj = this.udoList.getSelectedValue();
                if (obj == null) {
                    this.populateUDOList(-1);
                } else {
                    UDOItem item = obj;
                    this.populateUDOList(item.itemId);
                }
            }
        });
        JScrollPane catScrollPane = new JScrollPane(this.categories);
        catScrollPane.setBorder(null);
        LabelledPanel categoryPanel = new LabelledPanel("Categories", catScrollPane);
        JScrollPane udoScrollPane = new JScrollPane(this.udoList);
        udoScrollPane.setBorder(null);
        LabelledPanel udoListPanel = new LabelledPanel("User-Defined Opcodes", udoScrollPane);
        LabelledPanel udoPanel = new LabelledPanel("User-Defined Opcode", this.udoDisplayPanel);
        JButton importButton = new JButton("Import");
        importButton.addActionListener(e -> this.addUDOtoOpcodeList());
        udoPanel.add((Component)importButton, "South");
        JSplitPane innerSplitPane = new JSplitPane(0);
        innerSplitPane.setDividerLocation(200);
        innerSplitPane.add(udoListPanel);
        innerSplitPane.add(udoPanel);
        JSplitPane mainSplitPane = new JSplitPane(1);
        mainSplitPane.setDividerLocation(200);
        mainSplitPane.add(categoryPanel);
        mainSplitPane.add(innerSplitPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(mainSplitPane);
        this.setSize(600, 500);
        GUI.centerOnScreen((Component)this);
    }

    protected void addUDOtoOpcodeList() {
        UserDefinedOpcode udo = this.udoDisplayPanel.getUDO();
        if (this.opcodeList == null || udo == null) {
            return;
        }
        this.opcodeList.addOpcode(udo);
    }

    private UserDefinedOpcode loadOpcodeFromXML(Element udoElement) {
        String opcodeName = udoElement.getElement("name").getTextString();
        String codeText = udoElement.getElement("code").getTextString();
        StringBuffer commentBuffer = new StringBuffer();
        String shortDescription = udoElement.getElement("shortDescription").getTextString();
        String description = udoElement.getElement("description").getTextString();
        String syntax = udoElement.getElement("syntax").getTextString();
        String initialization = udoElement.getElement("initialization").getTextString();
        String performance = udoElement.getElement("performance").getTextString();
        String credits = udoElement.getElement("credits").getTextString();
        commentBuffer.append(opcodeName).append(" - ").append(shortDescription);
        commentBuffer.append("\n\nDESCRIPTION\n").append(description);
        commentBuffer.append("\n\nSYNTAX\n").append(syntax);
        commentBuffer.append("\n\nINITIALIZATION\n").append(initialization);
        commentBuffer.append("\n\nPERFORMANCE\n").append(performance);
        commentBuffer.append("\n\nCREDITS\n").append(credits);
        UserDefinedOpcode udo = new UserDefinedOpcode();
        udo.opcodeName = opcodeName;
        udo.comments = commentBuffer.toString();
        StringBuffer cleanedCode = new StringBuffer();
        boolean mode = false;
        String[] lines = codeText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line;
            if (!mode) {
                line = lines[i].trim();
                if (!(line = TextUtilities.stripSingleLineComments((String)line)).startsWith("opcode")) continue;
                String[] parts = line.substring(6).split(",");
                if (parts.length == 3) {
                    udo.outTypes = parts[1].trim();
                    udo.inTypes = parts[2].trim();
                }
                mode = true;
                continue;
            }
            if (!mode) continue;
            line = lines[i];
            if (line.contains("endop")) break;
            cleanedCode.append(line).append("\n");
        }
        udo.codeBody = cleanedCode.toString();
        return udo;
    }

    protected void populateUDOList(int itemId) {
        if (itemId >= 0) {
            String result = null;
            Vector<Integer> v = new Vector<Integer>();
            v.add(new Integer(itemId));
            try {
                result = (String)xrpc.execute("udo.getUDO", v);
            }
            catch (IOException | XmlRpcException e) {
                e.printStackTrace();
            }
            if (result == null) {
                System.err.println("Null Opcode");
                return;
            }
            Document doc = null;
            try {
                doc = new Document(result);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            if (doc == null) {
                return;
            }
            Element root = doc.getRoot();
            this.udoDisplayPanel.setUDO(root);
        }
    }

    protected void populateUDOList(UDOItem tempCat) {
        if (tempCat.itemId >= 0) {
            String result = null;
            Vector<Integer> v = new Vector<Integer>();
            v.add(tempCat.itemId);
            try {
                result = (String)xrpc.execute("udo.getUDOList", v);
            }
            catch (IOException | XmlRpcException e) {
                e.printStackTrace();
            }
            if (result == null) {
                System.out.println("Null List");
                return;
            }
            Document doc = null;
            try {
                doc = new Document(result);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            if (doc == null) {
                return;
            }
            Element root = doc.getRoot();
            DefaultListModel<UDOItem> listItems = new DefaultListModel<UDOItem>();
            Elements nodes = root.getElements();
            while (nodes.hasMoreElements()) {
                Element node = nodes.next();
                UDOItem item = new UDOItem();
                item.itemId = Integer.parseInt(node.getAttributeValue("udoId"));
                item.itemName = node.getAttributeValue("name");
                listItems.addElement(item);
            }
            this.udoList.setModel(listItems);
        }
    }

    public void refreshCategoriesList() {
        String result = null;
        try {
            result = (String)xrpc.execute("udo.getUDOCategoryTree", new Vector());
        }
        catch (IOException | XmlRpcException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return;
        }
        Document doc = null;
        try {
            doc = new Document(result);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        if (doc == null) {
            return;
        }
        Element root = doc.getRoot();
        DefaultMutableTreeNode rootNode = this.getCategory(root);
        this.categories.setModel(new DefaultTreeModel(rootNode));
    }

    private DefaultMutableTreeNode getCategory(Element node) {
        UDOItem catObj = new UDOItem();
        if (node.getName().equals("udoCategories")) {
            catObj.itemName = "UDO Categories";
            catObj.itemId = -1;
        } else {
            catObj.itemName = node.getAttributeValue("name");
            catObj.itemId = Integer.parseInt(node.getAttributeValue("categoryId"));
        }
        DefaultMutableTreeNode retVal = new DefaultMutableTreeNode(catObj);
        Elements nodes = node.getElements();
        while (nodes.hasMoreElements()) {
            Element tempNode = nodes.next();
            retVal.add(this.getCategory(tempNode));
        }
        return retVal;
    }

    public void setOpcodeList(OpcodeList opcodeList) {
        this.opcodeList = opcodeList;
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        UDORepositoryBrowser browser = new UDORepositoryBrowser(null);
        browser.setOpcodeList(new OpcodeList());
        browser.setVisible(true);
        browser.setDefaultCloseOperation(2);
        browser.refreshCategoriesList();
    }

    static {
        UDO_REPO_URL = "http://www.csounds.com/udo/xmlrpc.php";
        try {
            xrpc = new XmlRpcClient(UDO_REPO_URL);
        }
        catch (MalformedURLException e) {
            xrpc = null;
        }
    }

    class UDODisplayPanel
    extends JComponent {
        private MimeTypeEditorComponent codeText = new MimeTypeEditorComponent("text/x-csound-orc");
        private UserDefinedOpcode udo;

        public UDODisplayPanel() {
            this.codeText.getJEditorPane().setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.codeText);
        }

        public void setUDO(Element node) {
            this.udo = UDORepositoryBrowser.this.loadOpcodeFromXML(node);
            String codeBody = "/*\n" + this.udo.comments + "*/\n\n";
            codeBody = codeBody + this.udo.codeBody;
            this.codeText.setText(codeBody);
        }

        public UserDefinedOpcode getUDO() {
            return this.udo;
        }
    }

    static class UDOItem {
        public String itemName = "Category";
        public int itemId = -1;

        UDOItem() {
        }

        public String toString() {
            return this.itemName;
        }
    }
}

