/*
 * Decompiled with CFR 0.152.
 */
package blue.automation;

import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.components.lines.Line;
import blue.components.lines.LinePoint;
import blue.components.lines.LineUtils;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.rmi.dgc.VMID;
import java.util.Vector;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Parameter
implements TableModelListener {
    private double min = 0.0;
    private double max = 1.0;
    private double value = 0.0;
    private String name = "";
    private String label = "";
    private BigDecimal resolution = new BigDecimal(-1);
    private BooleanProperty automationEnabled = new SimpleBooleanProperty(false);
    private boolean updatingLine = false;
    private String uniqueId;
    private Line line;
    transient Vector<ParameterListener> listeners;
    private String compilationVarName = null;

    public Parameter() {
        this.line = new Line(false);
        this.line.addTableModelListener(this);
        this.uniqueId = Integer.toString(new VMID().hashCode());
    }

    public Parameter(Parameter param) {
        this.min = param.min;
        this.max = param.max;
        this.value = param.value;
        this.name = param.name;
        this.label = param.label;
        this.resolution = param.resolution;
        this.line = new Line(param.line);
        this.line.addTableModelListener(this);
        this.setAutomationEnabled(param.isAutomationEnabled());
        this.uniqueId = param.uniqueId;
        this.compilationVarName = param.compilationVarName;
    }

    public void addParameterListener(ParameterListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeParameterListener(ParameterListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireParameterChanged() {
        if (this.listeners == null) {
            return;
        }
        for (ParameterListener cl : this.listeners) {
            cl.parameterChanged(this);
        }
    }

    private void fireLineDataChanged() {
        if (this.listeners == null) {
            return;
        }
        for (ParameterListener cl : this.listeners) {
            cl.lineDataChanged(this);
        }
    }

    public void fireUpdateFromTimeChange() {
        this.fireLineDataChanged();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double min, boolean truncate) {
        double oldMin = this.min;
        this.min = min;
        this.updatingLine = true;
        this.line.setMin(min, truncate);
        this.value = truncate ? LineUtils.truncate(this.value, this.min, this.max) : LineUtils.rescale(this.value, oldMin, this.max, this.min, this.max, this.resolution);
        this.updatingLine = false;
        this.fireParameterChanged();
    }

    public void setMax(double max, boolean truncate) {
        double oldMax = this.max;
        this.max = max;
        this.updatingLine = true;
        this.line.setMax(max, truncate);
        this.value = truncate ? LineUtils.truncate(this.value, this.min, this.max) : LineUtils.rescale(this.value, this.min, oldMax, this.min, this.max, this.resolution);
        this.updatingLine = false;
        this.fireParameterChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireParameterChanged();
    }

    public BigDecimal getResolution() {
        return this.resolution;
    }

    public void setResolution(BigDecimal resolution) {
        this.resolution = resolution;
        this.line.setResolution(resolution);
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.line = line;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.updatingLine) {
            this.fireLineDataChanged();
        }
    }

    public void setValue(double value) {
        if (this.isAutomationEnabled()) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            if (time < 0.0) {
                return;
            }
            this.updatingLine = true;
            LinePoint found = null;
            for (int i = 0; i < this.line.size(); ++i) {
                LinePoint point = this.line.getLinePoint(i);
                if (point.getX() != time) continue;
                found = point;
                break;
            }
            if (found != null) {
                found.setLocation(found.getX(), value);
            } else {
                LinePoint lp = new LinePoint();
                lp.setLocation(time, value);
                this.line.insertLinePoint(lp);
            }
            this.updatingLine = false;
        } else {
            this.value = value;
            if (this.line.size() == 1) {
                this.updatingLine = true;
                LinePoint lp = this.line.getLinePoint(0);
                lp.setLocation(lp.getX(), value);
                this.updatingLine = false;
            }
        }
    }

    public double getValue(double time) {
        double retValue = this.isAutomationEnabled() ? this.line.getValue(time) : this.value;
        return retValue;
    }

    public double getFixedValue() {
        return this.value;
    }

    public final void setAutomationEnabled(boolean value) {
        this.automationEnabled.set(value);
    }

    public final boolean isAutomationEnabled() {
        return this.automationEnabled.get();
    }

    public final BooleanProperty automationEnabledProperty() {
        return this.automationEnabled;
    }

    public Element saveAsXML() {
        Element retVal = new Element("parameter");
        retVal.setAttribute("uniqueId", this.uniqueId);
        retVal.setAttribute("name", this.name);
        retVal.setAttribute("label", this.label);
        retVal.setAttribute("min", Double.toString(this.min));
        retVal.setAttribute("max", Double.toString(this.max));
        retVal.setAttribute("bdresolution", this.resolution.toString());
        retVal.setAttribute("automationEnabled", Boolean.toString(this.isAutomationEnabled()));
        retVal.setAttribute("value", Double.toString(this.value));
        retVal.addElement(this.line.saveAsXML());
        return retVal;
    }

    public static Parameter loadFromXML(Element data) {
        Parameter retVal = new Parameter();
        String val = data.getAttributeValue("uniqueId");
        if (val != null && val.length() > 0) {
            retVal.uniqueId = val;
        }
        if ((val = data.getAttributeValue("name")) != null && val.length() > 0) {
            retVal.name = val;
        }
        if ((val = data.getAttributeValue("label")) != null && val.length() > 0) {
            retVal.label = val;
        }
        if ((val = data.getAttributeValue("min")) != null && val.length() > 0) {
            retVal.min = Double.parseDouble(val);
        }
        if ((val = data.getAttributeValue("max")) != null && val.length() > 0) {
            retVal.max = Double.parseDouble(val);
        }
        if ((val = data.getAttributeValue("resolution")) != null && val.length() > 0) {
            double res = Double.parseDouble(val);
            retVal.resolution = new BigDecimal(res).setScale(5, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        if ((val = data.getAttributeValue("bdresolution")) != null && val.length() > 0) {
            retVal.resolution = new BigDecimal(val);
        }
        if ((val = data.getAttributeValue("automationEnabled")) != null && val.length() > 0) {
            retVal.setAutomationEnabled(Boolean.valueOf(val));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("line")) continue;
            retVal.line = Line.loadFromXML(node);
            retVal.line.addTableModelListener(retVal);
        }
        if (retVal.line.getResolution() != retVal.getResolution()) {
            retVal.line.setResolution(retVal.getResolution());
        }
        if ((val = data.getAttributeValue("value")) != null && val.length() > 0) {
            retVal.value = Double.parseDouble(val);
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return new EqualsBuilder().append((Object)this.uniqueId, (Object)other.uniqueId).append(this.min, other.min).append(this.max, other.max).append((Object)this.label, (Object)other.label).append((Object)this.resolution, (Object)other.resolution).append((Object)this.line, (Object)other.line).append(this.automationEnabled.get(), other.automationEnabled.get()).append(this.updatingLine, other.updatingLine).append(this.value, other.value).isEquals();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCompilationVarName() {
        return this.compilationVarName;
    }

    public void setCompilationVarName(String compilationVarName) {
        this.compilationVarName = compilationVarName;
    }
}

