/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.noteProcessor.NoteProcessorChain;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashMap;
import java.util.Map;

public class NoteProcessorChainMap
extends HashMap<String, NoteProcessorChain> {
    public NoteProcessorChainMap() {
    }

    public NoteProcessorChainMap(NoteProcessorChainMap npcMap) {
        super(npcMap.size());
        for (Map.Entry entry : npcMap.entrySet()) {
            this.put(entry.getKey(), new NoteProcessorChain((NoteProcessorChain)entry.getValue()));
        }
    }

    public NoteProcessorChain getNoteProcessorChain(Object key) {
        return (NoteProcessorChain)this.get(key);
    }

    public static NoteProcessorChainMap loadFromXML(Element data) throws Exception {
        NoteProcessorChainMap map = new NoteProcessorChainMap();
        Elements npcNodes = data.getElements("npc");
        while (npcNodes.hasMoreElements()) {
            Element elem = npcNodes.next();
            String name = elem.getAttributeValue("name");
            NoteProcessorChain npc = NoteProcessorChain.loadFromXML(elem.getElement("noteProcessorChain"));
            map.put(name, npc);
        }
        return map;
    }

    public Element saveAsXML() {
        Element retVal = new Element("noteProcessorChainMap");
        for (String name : this.keySet()) {
            NoteProcessorChain npc = this.getNoteProcessorChain(name);
            Element npcNode = new Element("npc");
            npcNode.setAttribute("name", name);
            npcNode.addElement(npc.saveAsXML());
            retVal.addElement(npcNode);
        }
        return retVal;
    }
}

